/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.client;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.client.ScreenClientHandler;
import com.trongthang.welcometomyworld.client.SoundsClientHandler;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.minecraft.class_746;

public class WelcomeToMyWorldClient
implements ClientModInitializer {
    private class_5498 previousPerspective = class_5498.field_26664;
    private boolean wasPlayerDead = false;
    private boolean stopSendingOriginsScreen = false;
    private boolean removeMessagesFirstJoin = true;
    private int WATER_FALL_DAMAGE_COOLDOWN = 20;
    private int WATER_FALL_DAMAGE_COUNTER = 0;
    private double lastFallDistance = 0.0;
    private int messageCounter = 0;
    List<String> removeMessages = List.of("has made the advancement [Ice and Fire]");

    public void onInitializeClient() {
        SoundsClientHandler.register();
        ScreenClientHandler.register();
        ClientPlayConnectionEvents.JOIN.register((handler, client, c) -> {
            this.preRenderChunks(c);
            this.removeMessagesFirstJoin = true;
            this.messageCounter = 0;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.stopSendingOriginsScreen = false;
        });
        if (WelcomeToMyWorld.compatityChecker.OriginCheck()) {
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                if (this.stopSendingOriginsScreen) {
                    return;
                }
                if (screen != null) {
                    String screenTitle;
                    String string = screenTitle = screen.method_25440() != null ? screen.method_25440().getString() : "No Title";
                    if (screenTitle.equals("origins.screen.choose_origin")) {
                        if (client.field_1724 != null) {
                            this.sendPacketToServer(1);
                        }
                    } else if (client.field_1724 != null) {
                        this.sendPacketToServer(0);
                    }
                }
            });
        } else {
            this.stopSendingOriginsScreen = true;
        }
        ClientTickEvents.END_CLIENT_TICK.register(this::onTicks);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WelcomeToMyWorld.STOP_SENDING_ORIGINS_SCREEN, (client, handler, buf, responseSender) -> client.execute(() -> {
            this.stopSendingOriginsScreen = true;
        }));
        ClientReceiveMessageEvents.ALLOW_GAME.register((a, b) -> {
            if (!this.removeMessagesFirstJoin) {
                return true;
            }
            for (String m : this.removeMessages) {
                if (!a.getString().toLowerCase().contains(m.toLowerCase())) continue;
                ++this.messageCounter;
                if (this.messageCounter >= this.removeMessages.size() - 1) {
                    this.removeMessagesFirstJoin = false;
                }
                return false;
            }
            return true;
        });
    }

    private void onTicks(class_310 client) {
        if (client.field_1724 != null) {
            this.waterFallDamage(client);
            this.switchPerspectiveOnDeath(client);
        }
    }

    private void switchPerspectiveOnDeath(class_310 client) {
        boolean isDead = client.field_1724.method_29504();
        if (isDead && !this.wasPlayerDead) {
            if (client.field_1690.method_31044() == class_5498.field_26664) {
                this.previousPerspective = class_5498.field_26664;
                client.execute(() -> client.field_1690.method_31043(class_5498.field_26665));
            } else {
                this.previousPerspective = client.field_1690.method_31044();
            }
            this.wasPlayerDead = true;
        } else if (!isDead && this.wasPlayerDead) {
            client.execute(() -> client.field_1690.method_31043(this.previousPerspective));
            this.wasPlayerDead = false;
        }
    }

    private void waterFallDamage(class_310 client) {
        if (this.WATER_FALL_DAMAGE_COUNTER < this.WATER_FALL_DAMAGE_COOLDOWN) {
            ++this.WATER_FALL_DAMAGE_COUNTER;
            return;
        }
        class_746 player = client.field_1724;
        assert (player != null);
        if (player.method_7337() || player.method_7325() || player.method_29504()) {
            return;
        }
        class_243 veloc = player.method_18798();
        if (veloc.method_10214() < -0.85 && this.hasLandedWater(player)) {
            float damageAmount = Utils.calculateDamageWithArmor(this.calculateFallDamage(this.lastFallDistance), (class_1309)player);
            if (player.method_5715()) {
                damageAmount /= 2.0f;
            }
            if ((double)damageAmount > 6.5) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeFloat(damageAmount);
                buf.method_10797(player.method_5667());
                ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.FALLING_TO_WATER, (class_2540)buf);
                this.WATER_FALL_DAMAGE_COUNTER = 0;
            }
            this.lastFallDistance = 0.0;
        }
    }

    private boolean hasLandedWater(class_746 player) {
        boolean land;
        class_2338 below = player.method_24515().method_10087(2);
        class_2680 blockState = player.method_37908().method_8320(below);
        boolean bl = land = blockState.method_51176() && !player.method_37908().method_22347(below);
        if (land) {
            this.lastFallDistance = player.field_6017;
        }
        return land;
    }

    private boolean hasLandedGround(class_746 player) {
        class_2338 below = player.method_24515().method_10074();
        return player.method_24828() && !player.method_37908().method_22347(below);
    }

    private float calculateFallDamage(double fallDistance) {
        return (float)Math.abs(fallDistance - 5.0);
    }

    private void sendPacketToServer(int state) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(state);
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            buf.method_10797(client.field_1724.method_5667());
            ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.FIRST_ORIGIN_CHOOSING_SCREEN, (class_2540)buf);
        } else {
            System.err.println("Player object is null, unable to send packet!");
        }
    }

    private void preRenderChunks(class_310 client) {
        WelcomeToMyWorld.LOGGER.info("Pre render chunks...");
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_2338 spawn = client.field_1687.method_43126();
        class_1923 spawnChunk = new class_1923(spawn);
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dz = -5; dz <= 5; ++dz) {
                class_1923 chunkPos = new class_1923(spawnChunk.field_9181 + dx, spawnChunk.field_9180 + dz);
                class_2791 chunk = client.field_1687.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
                if (chunk == null) continue;
                client.field_1769.method_18146(chunkPos.method_8326(), 0, chunkPos.method_8328(), chunkPos.method_8326() + 15, client.field_1687.method_31605(), chunkPos.method_8328() + 15);
            }
        }
    }
}

