/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.entities;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.AnimationName;
import com.trongthang.welcometomyworld.managers.SoundsManager;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class Portaler
extends class_1314 {
    ConcurrentHashMap<AnimationName, class_7094> animationHashMap = new ConcurrentHashMap();
    private static final class_2940<Integer> TEXTURE_VARIANT = class_2945.method_12791(Portaler.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_SWITCHING_PORTAL = class_2945.method_12791(Portaler.class, (class_2941)class_2943.field_13323);
    private static final int WALK_CYCLE_DURATION_MS = 5380;
    private static final int[] FOOTSTEP_TIMINGS_MS = new int[]{1280, 4000};
    private int previousWalkPosition = -1;
    private static final int PORTAL_ANIM_DURATION_MS = 1800;
    private static final int[] PORTAL_SOUND_TIMINGS_MS = new int[]{50, 1500};
    private final Set<Integer> portalPlayedFrames = new HashSet<Integer>();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 switchingPortalAnimationState = new class_7094();
    public int animationTimeout = 0;
    public static final int DEFAULT_ANIMATION_TIMEOUT = 15;
    private double switchingPortalChance = 1.0;
    private double switchingPortalCooldown = 24000.0;
    private double switchingPortalCounter = 0.0;
    private boolean hasSwitchingAnimationCompleted = false;
    private int switchingTimer = 36;
    private int switchingTimerCounter = 0;
    public boolean completeSwitich = false;

    public Portaler(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.animationHashMap.put(AnimationName.IDLE, this.idleAnimationState);
        this.animationHashMap.put(AnimationName.WALK, this.walkAnimationState);
        this.animationHashMap.put(AnimationName.SWITCHING_PORTAL, this.switchingPortalAnimationState);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TEXTURE_VARIANT, (Object)0);
        this.field_6011.method_12784(IS_SWITCHING_PORTAL, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_35115().removeIf(g -> g.method_19058() instanceof class_1379 || g.method_19058() instanceof class_1394);
        this.field_6201.method_6277(1, (class_1352)new StopMovingAndLookingWhenSwitichPortalGoal(this));
        this.field_6201.method_6277(2, (class_1352)new LargeEntityWanderGoal(this, 1.0, 1));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f));
    }

    public void setAnimationStates() {
        if (!this.method_37908().field_9236) {
            if (this.switchingTimerCounter > 0) {
                --this.switchingTimerCounter;
            }
            if (this.getIsSwitchingPortal() && this.switchingTimerCounter <= 0) {
                this.setIsSwitchingPortal(false);
                int nextVariant = (this.getTextureVariant() + 1) % 2;
                this.setTextureVariant(nextVariant);
            }
        }
        if (this.method_37908().field_9236) {
            boolean isMoving;
            class_243 velocity = this.method_18798();
            boolean bl = isMoving = velocity.field_1352 != 0.0 || velocity.field_1350 != 0.0;
            if (!this.switchingPortalAnimationState.method_41327()) {
                if (isMoving) {
                    if (!this.walkAnimationState.method_41327()) {
                        this.startAnimation(AnimationName.WALK);
                    }
                } else if (!this.idleAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.IDLE);
                }
            }
            if (this.animationTimeout <= 0) {
                if (this.getIsSwitchingPortal() && !this.switchingPortalAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.SWITCHING_PORTAL);
                    if (this.getTextureVariant() == 1) {
                        this.spawnPillarEffect(this.method_24515(), this.method_37908(), (class_2394)class_2398.field_11214);
                    } else {
                        this.spawnPillarEffect(this.method_24515(), this.method_37908(), (class_2394)class_2398.field_11207);
                    }
                }
                if (!this.getIsSwitchingPortal() && this.switchingPortalAnimationState.method_41327()) {
                    this.switchingPortalAnimationState.method_41325();
                    this.animationTimeout = 0;
                }
            }
        }
        if (this.animationTimeout >= 0) {
            --this.animationTimeout;
        }
    }

    public void method_5773() {
        super.method_5773();
        this.setAnimationStates();
        if (!this.method_37908().field_9236) {
            this.switchingPortalCounter += 1.0;
            if (this.switchingPortalCounter > this.switchingPortalCooldown) {
                this.switchingPortalCounter = 0.0;
                this.setIsSwitchingPortal(true);
                this.switchingTimerCounter = this.switchingTimer;
            }
        }
        this.handleAnimationSounds();
        this.updateRotation();
    }

    private void updateRotation() {
        class_243 velocity = this.method_18798();
        if (velocity.method_1027() > 1.0E-4) {
            double angle = Math.atan2(-velocity.field_1352, velocity.field_1350);
            this.method_36456((float)Math.toDegrees(angle));
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
        }
    }

    private void handleAnimationSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (this.walkAnimationState.method_41327()) {
            this.handleWalkSounds();
        }
        if (this.switchingPortalAnimationState.method_41327()) {
            this.handleSwitchSounds();
        }
    }

    private void handleWalkSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (!this.walkAnimationState.method_41327()) {
            return;
        }
        long animTime = this.walkAnimationState.method_43687();
        int currentPos = (int)(animTime % 5380L);
        for (int timing : FOOTSTEP_TIMINGS_MS) {
            int timingInCycle = timing % 5380;
            if (this.previousWalkPosition == -1) continue;
            boolean normalCross = this.previousWalkPosition < timingInCycle && currentPos >= timingInCycle;
            boolean wrapAround = timingInCycle == 0 && this.previousWalkPosition > currentPos;
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(this.method_24515());
            buf.method_10812(SoundsManager.PORTALER_STEP.method_14833());
            if (!normalCross && !wrapAround) continue;
            ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.SOUND_PACKET_ID, (class_2540)buf);
        }
        this.previousWalkPosition = currentPos;
    }

    private void handleSwitchSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (!this.switchingPortalAnimationState.method_41327()) {
            return;
        }
        long animTime = this.switchingPortalAnimationState.method_43687();
        int currentPos = (int)(animTime % 1800L);
        for (int timing : PORTAL_SOUND_TIMINGS_MS) {
            boolean cycleWrap;
            int windowStart = timing - 25;
            int windowEnd = timing + 25;
            boolean inWindow = currentPos >= windowStart && currentPos <= windowEnd;
            boolean bl = cycleWrap = timing > 1775 && currentPos < timing - 1800 + 25;
            if (!inWindow && !cycleWrap || this.portalPlayedFrames.contains(timing)) continue;
            this.triggerPortalSound(timing);
            this.portalPlayedFrames.add(timing);
        }
        if (currentPos > 1600) {
            this.portalPlayedFrames.clear();
        }
    }

    private void triggerPortalSound(int timing) {
        class_2960 soundId = timing >= 0 && timing <= 50 ? SoundsManager.PORTALER_SPIN.method_14833() : SoundsManager.PORTALER_PORTAL_CHANGE.method_14833();
        ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.SOUND_PACKET_ID, (class_2540)PacketByteBufs.create().method_10807(this.method_24515()).method_10812(soundId));
    }

    public void method_6125(float speed) {
        super.method_6125(speed);
    }

    public void method_5694(class_1657 player) {
        super.method_5694(player);
        if (!this.method_37908().field_9236) {
            if (this.method_5854() != null) {
                return;
            }
            class_3222 p = (class_3222)player;
            if (this.getTextureVariant() == 0) {
                this.teleportPlayerRelativeToMob(p, (class_5321<class_1937>)class_1937.field_25180);
            } else {
                this.teleportPlayerRelativeToMob(p, (class_5321<class_1937>)class_1937.field_25181);
            }
            Utils.playSound(p.method_51469(), p.method_24515(), class_3417.field_14879);
        }
    }

    private void teleportPlayerRelativeToMob(class_3222 player, class_5321<class_1937> dimension) {
        class_3218 targetWorld = player.method_5682().method_3847(dimension);
        if (targetWorld != null) {
            int x = this.method_24515().method_10263();
            int z = this.method_24515().method_10260();
            int y = this.method_24515().method_10264() + 30;
            player.method_14251(targetWorld, (double)x, (double)y, (double)z, player.method_36454(), player.method_36455());
        }
    }

    public void startAnimation(AnimationName name) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = 15;
        }
    }

    public void startAnimation(AnimationName name, int timeout) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = timeout;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236) {
            Utils.playSound(this.method_37908(), this.method_24515(), SoundsManager.PORTALER_HURT);
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        if (!this.method_37908().field_9236) {
            Utils.playSound(this.method_37908(), this.method_24515(), SoundsManager.PORTALER_DEATH);
        }
    }

    public int getTextureVariant() {
        return (Integer)this.field_6011.method_12789(TEXTURE_VARIANT);
    }

    public void setTextureVariant(int variant) {
        this.field_6011.method_12778(TEXTURE_VARIANT, (Object)variant);
    }

    public boolean getIsSwitchingPortal() {
        return (Boolean)this.field_6011.method_12789(IS_SWITCHING_PORTAL);
    }

    public void setIsSwitchingPortal(boolean variant) {
        this.field_6011.method_12778(IS_SWITCHING_PORTAL, (Object)variant);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("TextureVariant", this.getTextureVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setTextureVariant(nbt.method_10550("TextureVariant"));
    }

    public void spawnPillarEffect(final class_2338 pos, final class_1937 world, final class_2394 particleEffect) {
        int totalTicks = 80;
        int layers = 10;
        double totalHeight = 10.0;
        final AtomicInteger tickCount = new AtomicInteger(0);
        Runnable spinningTask = new Runnable(){

            @Override
            public void run() {
                if (tickCount.get() < 80) {
                    if (tickCount.get() <= 10) {
                        Portaler.this.spawnVerticalBuildUp(pos, world, particleEffect, tickCount.get(), 10.0, 10);
                    } else {
                        Portaler.this.spawnSpinningParticlesAround(pos, world, tickCount.get(), particleEffect, 10.0, 10);
                    }
                    Utils.addRunAfter(this, 1);
                    tickCount.incrementAndGet();
                }
            }
        };
        Utils.addRunAfter(spinningTask, 0);
    }

    private void spawnVerticalBuildUp(class_2338 pos, class_1937 world, class_2394 particleEffect, int currentTick, double totalHeight, int layers) {
        double yIncrement = totalHeight / (double)layers;
        double currentY = (double)pos.method_10264() + (double)currentTick * yIncrement;
        int particlesPerLayer = 30;
        double radius = 1.0;
        for (int i = 0; i < particlesPerLayer; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particlesPerLayer;
            double x = (double)pos.method_10263() + radius * Math.cos(angle);
            double z = (double)pos.method_10260() + radius * Math.sin(angle);
            world.method_8406(particleEffect, x, currentY, z, 0.0, 0.0, 0.0);
        }
    }

    public void spawnSpinningParticlesAround(class_2338 pos, class_1937 world, int tickCount, class_2394 particleEffect, double totalHeight, int layers) {
        double radius = 4.0;
        int particlesPerLayer = 20;
        double yIncrement = totalHeight / (double)layers;
        double baseY = pos.method_10264();
        double rotationAngle = Math.PI * 2 * (double)(tickCount % 100) / 100.0;
        for (int layer = 0; layer < layers; ++layer) {
            double currentY = baseY + (double)layer * yIncrement;
            for (int i = 0; i < particlesPerLayer; ++i) {
                double particleAngle = rotationAngle + Math.PI * 2 * (double)i / (double)particlesPerLayer;
                double x = (double)pos.method_10263() + radius * Math.cos(particleAngle);
                double z = (double)pos.method_10260() + radius * Math.sin(particleAngle);
                double yOffset = 0.2 * Math.sin(particleAngle + rotationAngle);
                world.method_8406(particleEffect, x, currentY + yOffset, z, 0.0, 0.05, 0.0);
            }
        }
    }

    class StopMovingAndLookingWhenSwitichPortalGoal
    extends class_1352 {
        private final Portaler mob;

        public StopMovingAndLookingWhenSwitichPortalGoal(Portaler mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.getIsSwitchingPortal();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.getIsSwitchingPortal();
        }

        public void method_6268() {
            this.mob.method_5942().method_6340();
        }
    }

    public class LargeEntityWanderGoal
    extends class_1352 {
        private final class_1314 mob;
        private double targetX;
        private double targetY;
        private double targetZ;
        private final double speed;
        private final int chance;
        private final class_5819 random;

        public LargeEntityWanderGoal(class_1314 mob, double speed, int chance) {
            this.mob = mob;
            this.speed = speed;
            this.chance = chance;
            this.random = mob.method_6051();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.mob.method_5782()) {
                return false;
            }
            if (this.mob.method_6051().method_43048(LargeEntityWanderGoal.method_38848((int)this.chance)) != 0) {
                return false;
            }
            class_243 target = this.getWanderTarget();
            if (target == null) {
                return false;
            }
            this.targetX = target.field_1352;
            this.targetY = target.field_1351;
            this.targetZ = target.field_1350;
            return true;
        }

        @Nullable
        protected class_243 getWanderTarget() {
            double width = this.mob.method_17681();
            double height = this.mob.method_17682();
            double minDistance = 5.0 + width;
            double maxDistance = 20.0 + width;
            double distance = minDistance + this.random.method_43058() * (maxDistance - minDistance);
            double angle = this.random.method_43058() * 2.0 * Math.PI;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            class_243 target = class_5532.method_31510((class_1314)this.mob, (int)((int)distance), (int)((int)height));
            if (target == null) {
                return new class_243(this.mob.method_23317() + offsetX, this.mob.method_23318(), this.mob.method_23321() + offsetZ);
            }
            return target;
        }

        public boolean method_6266() {
            return !this.mob.method_5942().method_6357();
        }

        public void method_6269() {
            this.mob.method_5942().method_6337(this.targetX, this.targetY + 0.1, this.targetZ, this.speed);
        }

        public void method_6270() {
            this.mob.method_5942().method_6340();
        }
    }
}

