/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AwakeHandler {
    public static final List<String> notSleepyMessages = List.of("I'm not tired", "I'm not really tired...", "I think i can do more...", "Nothing can stop me, even the nights!", "Sleep? Not an option right now!", "My energy knows no bounds!", "I could keep going all night!", "Sleep is overrated, I\u2019m just getting started!", "I feel wide awake, bring it on!", "Tired? Never heard of it!", "I'm powered up and ready for more!", "Who needs sleep when there\u2019s so much to do?", "I\u2019m on a roll, no stopping me now!", "I\u2019m at full capacity, no shutdown!", "Sleep? I\u2019ll take a rain check on that!", "Energy levels are off the charts!", "I feel more alive than ever!", "The night is young, and so am I!", "Who needs sleep when there\u2019s a world to conquer?", "Sleep is for the weak, I\u2019m invincible!", "I\u2019ve got endless fuel, let's keep going!", "I\u2019m not slowing down anytime soon!");
    private static final double WAKE_UP_CHANCE = 1.0;
    private double havingLuckEffectChanceDecrease = 1.0;
    private double rainDescreaseChance = 1.0;
    private double nearASleepingFriendChanceDecrease = 0.3;
    private double nearACampfireChanceDecrease = 0.2;
    private double holdingFlowerChanceDecrease = 0.3;
    public int checkInterval = 40;
    private int counter = 0;
    private static final double GIVE_LUCK_EFFECT_CHANCE = 0.5;
    private static final int LUCK_EFFECT_DURATION = 600;
    private static final Set<class_3218> appliedWorlds = new HashSet<class_3218>();

    public static void checkAndApplyLuckEffect(class_3218 world) {
        long timeOfDay = world.method_8532() % 24000L;
        if (timeOfDay == 18000L && !appliedWorlds.contains(world)) {
            AwakeHandler.applyLuckEffectToAllPlayers(world);
            appliedWorlds.add(world);
        }
        if (timeOfDay > 18000L && timeOfDay < 19000L) {
            appliedWorlds.remove(world);
        }
    }

    private static void applyLuckEffectToAllPlayers(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            player.method_6092(new class_1293(class_1294.field_5926, 600, 0));
            ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_EXPERIENCE_ORB_PICK_UP, (class_2540)PacketByteBufs.empty());
        }
    }

    public void checkAndExplodeIfSleeping(MinecraftServer server) {
        if (WelcomeToMyWorld.random.nextDouble() < 0.5) {
            AwakeHandler.checkAndApplyLuckEffect(server.method_30002());
        }
        ++this.counter;
        if (this.counter < this.checkInterval) {
            return;
        }
        this.counter = 0;
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!player.method_6113()) continue;
            double awakeChance = this.calculateWakeUpChance(player);
            if (!(WelcomeToMyWorld.random.nextDouble() < awakeChance)) continue;
            class_3218 world = player.method_51469();
            class_2338 pos = player.method_18398().orElse(null);
            Utils.spawnParticles(world, pos, class_2398.field_11251);
            Utils.addRunAfter(() -> this.triggerWakeUp(player), 20);
        }
    }

    private double calculateWakeUpChance(class_3222 player) {
        double effectiveChance = 1.0;
        if (player.method_6059(class_1294.field_5926)) {
            return Math.max(0.0, effectiveChance -= this.havingLuckEffectChanceDecrease);
        }
        if (this.isTheWorldRaining(player)) {
            return Math.max(0.0, effectiveChance -= this.rainDescreaseChance);
        }
        if (this.isNearOtherPlayers(player)) {
            effectiveChance -= this.nearASleepingFriendChanceDecrease;
        }
        if (player.method_6047().method_7909() == class_1802.field_8880 || player.method_6047().method_7909() == class_1802.field_8491 || player.method_6047().method_7909() == class_1802.field_17512 || player.method_6047().method_7909() == class_1802.field_17513 || player.method_6047().method_7909() == class_1802.field_8710 || player.method_6047().method_7909() == class_1802.field_17525 || player.method_6047().method_7909() == class_1802.field_42695) {
            effectiveChance -= this.holdingFlowerChanceDecrease;
        }
        if (this.isNearCampfire(player)) {
            effectiveChance -= this.nearACampfireChanceDecrease;
        }
        return Math.max(0.0, effectiveChance);
    }

    private boolean isNearOtherPlayers(class_3222 player) {
        class_1937 world = player.method_37908();
        for (class_3222 otherPlayer : world.method_8503().method_3760().method_14571()) {
            if (otherPlayer.equals((Object)player) || !(player.method_5858((class_1297)otherPlayer) < 100.0) || !player.method_6113()) continue;
            return true;
        }
        return false;
    }

    private boolean isNearCampfire(class_3222 player) {
        class_1937 world = player.method_37908();
        class_2338 playerPos = player.method_24515();
        int radius = 5;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 checkPos = playerPos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26204() != class_2246.field_17350) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTheWorldRaining(class_3222 player) {
        return player.method_37908().method_8419();
    }

    private void triggerWakeUp(class_3222 player) {
        player.method_18400();
        PlayerData p = WelcomeToMyWorld.dataHandler.playerDataMap.get(player.method_5667());
        if (!p.firstWakeup) {
            Utils.grantAdvancement(player, "first_wake_up");
            p.firstWakeup = true;
            Utils.addRunAfter(() -> Utils.UTILS.sendTextAfter(player, "Seems like you're not tired enough."), 60);
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)notSleepyMessages.get(WelcomeToMyWorld.random.nextInt(0, notSleepyMessages.size() - 1))));
        }
    }
}

