/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.ConfigLoader;
import com.trongthang.welcometomyworld.Utilities.SpawnParticiles;
import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerData;
import com.trongthang.welcometomyworld.features.GiveStartingItemsHandler;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class IntroOfTheWorldHandler {
    Random rand = new Random();
    double playersDeathChanceInTheIntro = 0.2;
    byte phantomSpawnAmount = (byte)10;
    public boolean alreadySpawnedPhantom = false;
    private int slownessTimeInTickAfterLand = 240;
    public static boolean firstTimeLoadChunkIntro = false;

    public void teleportPlayersToSkyFirstJoin(class_3222 player) {
        class_243 skyPosition = new class_243(player.method_23317(), 400.0, player.method_23321());
        player.method_20620(skyPosition.field_1352, skyPosition.field_1351, skyPosition.field_1350);
        player.method_6092(new class_1293(class_1294.field_5907, 100, 128));
        player.method_6092(new class_1293(class_1294.field_5919, 60, 0));
        player.method_6092(new class_1293(class_1294.field_5906, 100, 4));
    }

    public void handlePlayerFirstJoin(class_3222 player) {
        int x;
        if (player.method_37908().field_9236) {
            return;
        }
        PlayerData playerData = WelcomeToMyWorld.dataHandler.playerDataMap.get(player.method_5667());
        class_3218 world = player.method_51469();
        boolean isAir = world.method_8320(player.method_24515().method_10087(25)).method_26215();
        if (!firstTimeLoadChunkIntro) {
            firstTimeLoadChunkIntro = true;
        }
        if (!(playerData.firstTouchGround && playerData.firstTeleportedToSky && playerData.completeOriginSelectingScreen)) {
            if (player.method_7337()) {
                WelcomeToMyWorld.dataHandler.playerDataMap.put(player.method_5667(), PlayerData.CreateExistPlayer());
                return;
            }
            --playerData.introTimeLimit;
            if (playerData.introTimeLimit <= 0) {
                WelcomeToMyWorld.dataHandler.playerDataMap.put(player.method_5667(), PlayerData.CreateExistPlayer());
                return;
            }
        }
        if (playerData.playerFirstIntroDeathChance == 0.0) {
            playerData.playerFirstIntroDeathChance = this.rand.nextDouble(0.0, 1.0);
        }
        if (WelcomeToMyWorld.compatityChecker.originMod && !playerData.completeOriginSelectingScreen) {
            this.teleportPlayersToSkyFirstJoin(player);
            if (playerData.firstTouchGround) {
                playerData.completeOriginSelectingScreen = true;
            }
            return;
        }
        if (!playerData.firstTeleportedToSky && (player.method_24828() || player.method_5799())) {
            if (player.method_37908().method_27983().equals(class_1937.field_25179)) {
                this.teleportPlayersToSkyFirstJoin(player);
                for (x = 1; x < 40; ++x) {
                    Utils.addRunAfter(() -> Utils.spawnCircleParticles(player), x);
                }
                playerData.completeSpawningParticles = true;
                Utils.UTILS.sendTextAfter(player, "Finally!", 20);
                for (x = 0; x < this.rand.nextInt(10, 20); ++x) {
                    Utils.addRunAfter(() -> Utils.summonLightning(player.method_24515(), player.method_51469(), true), this.rand.nextInt(5, 20));
                }
                if (!this.alreadySpawnedPhantom) {
                    this.spawnPhantom(player.method_51469(), (class_1657)player);
                    this.alreadySpawnedPhantom = true;
                }
            } else {
                playerData.firstTouchGround = true;
                WelcomeToMyWorld.dataHandler.playerDataMap.put(player.method_5667(), PlayerData.CreateExistPlayer());
                Utils.grantAdvancement(player, "welcome_to_easycraft");
            }
        }
        if (!playerData.firstTeleportedToSky && player.method_23318() >= 350.0) {
            playerData.firstTeleportedToSky = true;
            ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_BLOCK_PORTAL_TRAVEL, (class_2540)PacketByteBufs.empty());
        }
        if (playerData.firstTouchGround || !playerData.firstTeleportedToSky) {
            return;
        }
        if (playerData.completeOriginSelectingScreen && !playerData.completeSpawningParticles) {
            Utils.spawnCircleParticles(player);
            for (x = 1; x < 40; ++x) {
                Utils.addRunAfter(() -> Utils.spawnCircleParticles(player), x);
            }
            playerData.completeSpawningParticles = true;
            Utils.UTILS.sendTextAfter(player, "Finally!");
        }
        if (playerData.playerFirstIntroDeathChance > this.playersDeathChanceInTheIntro) {
            if (!isAir) {
                player.method_6092(new class_1293(class_1294.field_5907, 300, 255));
            }
            if (Utils.isPlayerStandingOnBlock((class_1309)player)) {
                class_2338 landingPos = new class_2338((int)player.method_23317(), (int)player.method_23318(), (int)player.method_23321());
                world.method_8437((class_1297)player, (double)landingPos.method_10263(), (double)landingPos.method_10264(), (double)landingPos.method_10260(), 6.0f, class_1937.class_7867.field_40891);
                player.method_18800(player.method_18798().field_1352, 1.2, player.method_18798().field_1350);
                player.field_6037 = true;
                Utils.addRunAfter(() -> player.method_6092(new class_1293(class_1294.field_5906, 40, 4)), 20);
                player.method_6092(new class_1293(class_1294.field_5909, this.slownessTimeInTickAfterLand, 2));
                this.spawnLandEffect(player);
                SpawnParticiles.spawnExpandingParticleSquare(world, (class_1297)player, 2, 5, 20, class_2398.field_11207);
                playerData.firstTouchGround = true;
                playerData.firstTeleportedToSky = true;
                playerData.introMessageAfterDeath = true;
                Utils.grantAdvancement(player, "successfully_landed");
                this.introMessages(player, false);
            }
        } else if ((player.method_24828() || player.method_5799()) && player.method_6032() <= 0.0f && !playerData.introDeathByGod) {
            Utils.UTILS.sendTextAfter(player, "That was... bad.", 20);
            playerData.firstTouchGround = true;
            playerData.firstTeleportedToSky = true;
            Utils.grantAdvancement(player, "a_rough_start");
        }
    }

    private void spawnLandEffect(class_3222 player) {
        class_3218 world = player.method_51469();
        for (int i = 0; i < 20; ++i) {
            world.method_14199((class_2394)class_2398.field_11207, player.method_23317() + (world.field_9229.method_43058() - 0.5) * 0.5, player.method_23318() + world.field_9229.method_43058() * 1.0, player.method_23321() + (world.field_9229.method_43058() - 0.5) * 0.5, 0, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public void registerIntroEvents() {
        if (ConfigLoader.getInstance().introOfTheWorld) {
            ServerPlayerEvents.AFTER_RESPAWN.register((serverPlayerEntity1, serverPlayerEntity, c) -> {
                PlayerData playerData = WelcomeToMyWorld.dataHandler.playerDataMap.get(serverPlayerEntity.method_5667());
                if (playerData == null) {
                    return;
                }
                if (!playerData.introMessageAfterDeath) {
                    playerData.introMessageAfterDeath = true;
                    this.introMessages(serverPlayerEntity1, true);
                }
            });
            ServerPlayNetworking.registerGlobalReceiver((class_2960)WelcomeToMyWorld.FIRST_ORIGIN_CHOOSING_SCREEN, (server, p, handler, buf, responseSender) -> {
                int state = buf.readInt();
                server.execute(() -> {
                    if (p == null) {
                        System.err.println("Received packet for unknown player");
                        return;
                    }
                    PlayerData playerData = WelcomeToMyWorld.dataHandler.playerDataMap.get(p.method_5667());
                    if (playerData == null) {
                        System.err.println("No data found for player UUID: " + p.method_5667());
                        return;
                    }
                    if (playerData.completeOriginSelectingScreen) {
                        return;
                    }
                    if (state == 1) {
                        playerData.firstOriginSelectingScreen = true;
                    }
                    if (state == 0 && playerData.firstOriginSelectingScreen) {
                        playerData.completeOriginSelectingScreen = true;
                        ServerPlayNetworking.send((class_3222)p, (class_2960)WelcomeToMyWorld.STOP_SENDING_ORIGINS_SCREEN, (class_2540)PacketByteBufs.empty());
                    }
                });
            });
        }
    }

    public void introMessages(class_3222 player, boolean isDeath) {
        if (!isDeath) {
            Utils.UTILS.sendTextAfter(player, "Whew, that was close!", 20);
            Utils.UTILS.sendTextAfter(player, "That was a hard land, try pulling your self together.", 80);
            Utils.UTILS.sendTextAfter(player, "Feeling less dizzy now? It looks like you're done with your old world... so welcome to this new one!", 260);
            Utils.UTILS.sendTextAfter(player, "Oh, and here's a small gift for you. Sorry about the botched summoning ritual.", 360);
            Utils.addRunAfter(() -> WelcomeToMyWorld.giveStartingItemsHandler.giveMoreItems(player), 420);
            Utils.UTILS.sendTextAfter(player, "That Golem will be a great help. Consider it your new best friend.", 480);
            Utils.UTILS.sendTextAfter(player, "I think I have a book that might help you progress in this magical world...", 560);
            Utils.addRunAfter(() -> {
                class_1799 book = GiveStartingItemsHandler.getModdedItems("ftbquests:book", 1);
                if (book != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, book);
                }
            }, 640);
            Utils.UTILS.sendTextAfter(player, "Well, that's it for now. Enjoy Your New World!", 720);
            Utils.addRunAfter(() -> Utils.grantAdvancement(player, "welcome_to_easycraft"), 800);
        } else {
            if (player.method_37908().method_8401().method_152()) {
                Utils.UTILS.sendTextAfter(player, "Oops, my protection spell came a bit late... Looks like it's time to create a new world!");
                Utils.grantAdvancement(player, "welcome_to_easycraft");
                return;
            }
            Utils.UTILS.sendTextAfter(player, "Well, that was a disaster. I'm getting too old for this...", 40);
            Utils.UTILS.sendTextAfter(player, "But let's not dwell on the past. Welcome to this new world!", 120);
            Utils.UTILS.sendTextAfter(player, "I can tell you're looking for adventure. That's why I summoned you here. Now, hold on a moment...", 200);
            Utils.addRunAfter(() -> WelcomeToMyWorld.giveStartingItemsHandler.giveMoreItems(player), 280);
            Utils.UTILS.sendTextAfter(player, "Here you go\u2014a, we've a 'friend' to keep you company, and a controller so you can guide it.", 300);
            Utils.UTILS.sendTextAfter(player, "Well, maybe 'friendship' isn't the healthiest way to describe this...", 360);
            Utils.UTILS.sendTextAfter(player, "There's more, i think there's something for you to eat...", 420);
            Utils.addRunAfter(() -> {
                class_1799 food = GiveStartingItemsHandler.getModdedItems("expandeddelight:cheese_wheel", 1);
                if (food != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, food);
                }
            }, 460);
            Utils.addRunAfter(() -> {
                class_1799 food = GiveStartingItemsHandler.getModdedItems("expandeddelight:chocolate_cooke", 1);
                if (food != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, food);
                }
            }, 500);
            Utils.addRunAfter(() -> {
                class_1799 food = GiveStartingItemsHandler.getModdedItems("croptopia:steamed_rice", 1);
                if (food != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, food);
                }
            }, 540);
            Utils.addRunAfter(() -> {
                class_1799 food = GiveStartingItemsHandler.getModdedItems("croptopia:cooked_bacon", 1);
                if (food != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, food);
                }
            }, 580);
            Utils.UTILS.sendTextAfter(player, "I don't really into cooking much, so that's all from me, but the most important is... Enjoy Your New World!", 620);
            Utils.addRunAfter(() -> Utils.grantAdvancement(player, "welcome_to_easycraft"), 700);
            Utils.UTILS.sendTextAfter(player, "Wait, I forgot a really useful book, here you go", 840);
            Utils.addRunAfter(() -> {
                class_1799 book = GiveStartingItemsHandler.getModdedItems("ftbquests:book", 1);
                if (book != null) {
                    GiveStartingItemsHandler.dropItemToPlayer(player, book);
                }
            }, 880);
        }
    }

    public void spawnPhantom(class_3218 world, class_1657 player) {
        double offsetZ;
        double offsetY;
        if (player == null) {
            return;
        }
        int addDistance = 20;
        int distance = 80;
        class_243 playerPos = player.method_19538();
        for (int x = 0; x < this.phantomSpawnAmount; ++x) {
            double offsetX = (world.method_8409().method_43058() - 0.5) * 2.0 * (double)distance;
            double offsetY2 = world.method_8409().method_43058() * 5.0 - (double)this.rand.nextInt(0, 40);
            double offsetZ2 = (world.method_8409().method_43058() - 0.5) * 2.0 * (double)distance;
            class_2338 spawnPos = new class_2338((int)(playerPos.field_1352 + offsetX), (int)(playerPos.field_1351 + offsetY2), (int)(playerPos.field_1350 + offsetZ2));
            class_1593 phantom = (class_1593)class_1299.field_6078.method_5883((class_1937)world.method_8410());
            if (!world.method_8320(spawnPos).method_26215()) continue;
            if (phantom != null) {
                phantom.method_7091(this.rand.nextInt(50, 200));
                phantom.method_5725(spawnPos, world.method_8409().method_43057() * 360.0f, 0.0f);
                world.method_8649((class_1297)phantom);
            }
            distance += this.rand.nextInt(10, addDistance);
        }
        double offsetX = (world.method_8409().method_43058() - 0.5) * 2.0 * 80.0;
        class_2338 spawnPos = new class_2338((int)(playerPos.field_1352 + offsetX), (int)(playerPos.field_1351 + (offsetY = world.method_8409().method_43058() * 5.0 - (double)this.rand.nextInt(100, 180))), (int)(playerPos.field_1350 + (offsetZ = (world.method_8409().method_43058() - 0.5) * 2.0 * 80.0)));
        if (!world.method_8320(spawnPos).method_26215()) {
            return;
        }
        class_1593 phantom = (class_1593)class_1299.field_6078.method_5883((class_1937)world.method_8410());
        if (phantom != null) {
            phantom.method_7091(200);
            phantom.method_5725(spawnPos, world.method_8409().method_43057() * 360.0f, 0.0f);
            world.method_8649((class_1297)phantom);
        }
    }
}

