/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.managers;

import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerStatsData;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PlayerStatsDataManager {
    private static int SOUND_COOLDOWN = 60;
    private static int SOUND_COOLDOWN_COUNTER = 0;
    private static final List<String> NEW_STATMINA_LEVEL_MESSAGES = List.of("I feel I can run more now!", "My energy is returning!", "My legs feel lighter!");
    public static int COOLDOWN = 10;
    public static int COUNTER = 0;

    public static void start() {
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            if (WelcomeToMyWorld.dataHandler.playerStatsData.get(serverPlayNetworkHandler.method_32311().method_5667()) == null) {
                WelcomeToMyWorld.dataHandler.playerStatsData.put(serverPlayNetworkHandler.method_32311().method_5667(), new PlayerStatsData());
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(PlayerStatsDataManager::endServerTick);
    }

    public static void endServerTick(MinecraftServer server) {
        if (SOUND_COOLDOWN_COUNTER < SOUND_COOLDOWN) {
            ++SOUND_COOLDOWN_COUNTER;
        }
        if (++COUNTER < COOLDOWN) {
            return;
        }
        COUNTER = 0;
        for (class_3222 p : server.method_3760().method_14571()) {
            PlayerStatsData pStats = WelcomeToMyWorld.dataHandler.playerStatsData.get(p.method_5667());
            PlayerStatsDataManager.playerStaminaHandler(p, pStats);
        }
    }

    public static void playerStaminaHandler(class_3222 p, PlayerStatsData pStats) {
        if (p.method_7337() || p.method_7325()) {
            return;
        }
        if (p.method_5624()) {
            if (pStats.staminaLeft >= -2000.0) {
                pStats.staminaLeft -= (double)COOLDOWN;
                if (pStats.staminaLeft <= -1000.0) {
                    p.method_5643(p.method_37908().method_48963().method_48830(), (float)pStats.staminaLeft / 60.0f);
                }
                if (pStats.staminaLeft <= 200.0) {
                    PlayerStatsDataManager.playSoundClient(p, WelcomeToMyWorld.TIRED_SOUND);
                }
                if (pStats.staminaLeft <= 0.0) {
                    PlayerStatsDataManager.giveEffect((class_1309)p, class_1294.field_5909, Math.abs((int)(pStats.staminaLeft / 100.0)), 80);
                } else if (pStats.currentStaminaExp <= pStats.staminaExpRequiredToLevelUp) {
                    pStats.currentStaminaExp += (double)COOLDOWN;
                } else if (pStats.stamilaLevel < 100.0 && pStats.staminaExpRequiredToLevelUp < 100000.0) {
                    pStats.currentStaminaExp = 0.0;
                    pStats.stamilaLevel += 1.0;
                    pStats.staminaExpRequiredToLevelUp *= 1.2;
                    pStats.staminaLeft = pStats.staminaMax = 400.0 + pStats.stamilaLevel * 10.0;
                    p.method_43496((class_2561)class_2561.method_43470((String)NEW_STATMINA_LEVEL_MESSAGES.get(WelcomeToMyWorld.random.nextInt(NEW_STATMINA_LEVEL_MESSAGES.size()))));
                    ServerPlayNetworking.send((class_3222)p, (class_2960)WelcomeToMyWorld.PLAY_BLOCK_LEVER_CLICK, (class_2540)PacketByteBufs.empty());
                }
            }
        } else if (pStats.staminaLeft < pStats.staminaMax) {
            pStats.staminaLeft += (double)COOLDOWN + pStats.stamilaLevel / 5.0;
            if (pStats.staminaLeft > pStats.staminaMax) {
                pStats.staminaLeft = pStats.staminaMax;
            }
        }
    }

    public static void giveEffect(class_1309 entity, class_1291 effect, int level, int timeInTick) {
        class_1293 currentEffect = entity.method_6112(effect);
        if (currentEffect != null) {
            int newAmplifier = Math.min(currentEffect.method_5578() + 1, 24);
            entity.method_6092(new class_1293(effect, timeInTick, newAmplifier));
        } else {
            entity.method_6092(new class_1293(effect, timeInTick, level));
        }
    }

    private static void playSoundClient(class_3222 p, class_2960 sound) {
        if (SOUND_COOLDOWN_COUNTER < SOUND_COOLDOWN) {
            return;
        }
        SOUND_COOLDOWN_COUNTER = 0;
        PlayerStatsDataManager.spawnBreathingAtThePlayerMouth(p, p.method_51469());
        ServerPlayNetworking.send((class_3222)p, (class_2960)sound, (class_2540)PacketByteBufs.empty());
    }

    private static void spawnBreathingAtThePlayerMouth(class_3222 p, class_3218 serverWorld) {
        int i;
        class_243 eyePos = p.method_33571();
        class_243 mouthPos = eyePos.method_1023(0.0, 0.1, 0.0);
        float yaw = p.method_36454();
        float pitch = p.method_36455();
        class_243 lookDirection = new class_243(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)), -Math.sin(Math.toRadians(pitch)), Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
        double lookOffsetX = eyePos.field_1352 + lookDirection.field_1352;
        double lookOffsetY = eyePos.field_1351 + lookDirection.field_1351;
        double lookOffsetZ = eyePos.field_1350 + lookDirection.field_1350;
        for (i = 0; i < 3; ++i) {
            serverWorld.method_14199((class_2394)class_2398.field_17430, mouthPos.field_1352, mouthPos.field_1351, mouthPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 3; ++i) {
            serverWorld.method_14199((class_2394)class_2398.field_17430, lookOffsetX, lookOffsetY, lookOffsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

