/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class ClientScheduler {
    private static final List<ClientTask> tasks = Collections.synchronizedList(new ArrayList());

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ArrayList<ClientTask> tasksCopy;
            if (client.field_1687 == null) {
                return;
            }
            List<ClientTask> list = tasks;
            synchronized (list) {
                tasksCopy = new ArrayList<ClientTask>(tasks);
            }
            for (ClientTask task : tasksCopy) {
                boolean shouldRemove = task.tick();
                if (!shouldRemove) continue;
                List<ClientTask> list2 = tasks;
                synchronized (list2) {
                    tasks.remove(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Runnable task, int delayTicks) {
        List<ClientTask> list = tasks;
        synchronized (list) {
            tasks.add(new ClientTask(task, delayTicks));
        }
    }

    private static class ClientTask {
        private final Runnable task;
        private int remainingTicks;

        public ClientTask(Runnable task, int delayTicks) {
            this.task = task;
            this.remainingTicks = delayTicks;
        }

        public boolean tick() {
            if (--this.remainingTicks <= 0) {
                this.task.run();
                return true;
            }
            return false;
        }
    }
}

