/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BreakingBlocksSpawnMobsHandler {
    List<BlockToMobConfig> blockMobConfigs = List.of(new BlockToMobConfig(List.of("minecraft:grass_block", "minecraft:dirt"), List.of(new MobWithSpawnChance("minecraft:zombie", 0.04)), true, 5), new BlockToMobConfig(List.of("minecraft:sand"), List.of(new MobWithSpawnChance("iceandfire:deathworm", 0.01), new MobWithSpawnChance("minecraft:skeleton", 0.01)), true, 6), new BlockToMobConfig(List.of("minecraft:cobblestone", "minecraft:stone"), List.of(new MobWithSpawnChance("minecraft:skeleton", 0.01), new MobWithSpawnChance("creeperoverhaul:hills_creeper", 0.01)), false, 20), new BlockToMobConfig(List.of("minecraft:gravel"), List.of(new MobWithSpawnChance("minecraft:cod", 0.01), new MobWithSpawnChance("minecraft:salmon", 0.01), new MobWithSpawnChance("iceandfire:sea_serpent", 0.01), new MobWithSpawnChance("iceandfire:siren", 0.01)), true, 6), new BlockToMobConfig(List.of("minecraft:obsidian"), List.of(new MobWithSpawnChance("netherexp:wisp", 0.1)), true, 0), new BlockToMobConfig(List.of("minecraft:oak_leaves", "minecraft:birch_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "minecraft:mangrove_leaves", "minecraft:azalea_leaves", "minecraft:flowering_azalea_leaves", "minecraft:spruce_leaves"), List.of(new MobWithSpawnChance("naturalist:cottonbird", 0.1), new MobWithSpawnChance("naturalist:bluebird", 0.1), new MobWithSpawnChance("naturalist:lark", 0.1), new MobWithSpawnChance("naturalist:milk_snake", 0.1), new MobWithSpawnChance("naturalist:monkey", 0.1), new MobWithSpawnChance("naturalist:meadowlark", 0.1), new MobWithSpawnChance("naturalist:king_snake", 0.1), new MobWithSpawnChance("minecraft:creeper", 0.1), new MobWithSpawnChance("minecraft:chicken", 0.1), new MobWithSpawnChance("netherexp:wisp", 0.1)), true, 10), new BlockToMobConfig(List.of("minecraft:oak_log", "minecraft:birch_log", "minecraft:jungle_log"), List.of(new MobWithSpawnChance("knightquest:ratman", 0.02), new MobWithSpawnChance("netherexp:stampede", 0.01)), true, 8), new BlockToMobConfig(List.of("minecraft:redstone_ore", "minecraft:deepslate_redstone_ore"), List.of(new MobWithSpawnChance("minecraft:skeleton", 0.02)), true, 8), new BlockToMobConfig(List.of("minecraft:bamboo"), List.of(new MobWithSpawnChance("creeperoverhaul:bamboo_creeper", 0.1)), true, 5));
    private final Random rand = new Random();

    public void handleBlockBreakMobSpawn(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (world.field_9236) {
            return;
        }
        block0: for (BlockToMobConfig blockMobConfig : this.blockMobConfigs) {
            for (String blockId : blockMobConfig.blockIds) {
                if (!this.isMatchingBlock(blockState, blockId)) continue;
                ++blockMobConfig.currentBlocksCooldown;
                if (blockMobConfig.currentBlocksCooldown <= blockMobConfig.blocksCooldown) continue block0;
                this.spawnMobsBasedOnConfig(world, player, blockPos, blockMobConfig);
                blockMobConfig.currentBlocksCooldown = 0;
            }
        }
    }

    private boolean isMatchingBlock(class_2680 blockState, String blockId) {
        class_2960 blockIdentifier = new class_2960(blockId.toLowerCase());
        return class_7923.field_41175.method_10250(blockIdentifier) && blockState.method_27852((class_2248)class_7923.field_41175.method_10223(blockIdentifier));
    }

    private void spawnMobsBasedOnConfig(class_1937 world, class_1657 player, class_2338 blockPos, BlockToMobConfig config) {
        if (config.spawnOnlyOneMob) {
            for (MobWithSpawnChance mobWithChance : config.mobs) {
                int randomMob = this.rand.nextInt(0, config.mobs.size());
                MobWithSpawnChance mob = config.mobs.get(randomMob);
                if (!(this.rand.nextDouble() < mob.spawnChance)) continue;
                class_1297 entity = Utils.spawnMob(world, blockPos, config.mobs.get((int)randomMob).mobId);
                ((class_1308)entity).method_5980((class_1309)player);
                return;
            }
        } else {
            for (MobWithSpawnChance mobWithChance : config.mobs) {
                if (!(this.rand.nextDouble() < mobWithChance.spawnChance)) continue;
                class_1297 entity = Utils.spawnMob(world, blockPos, mobWithChance.mobId);
                ((class_1308)entity).method_5980((class_1309)player);
            }
        }
    }

    class BlockToMobConfig {
        List<String> blockIds;
        List<MobWithSpawnChance> mobs = new ArrayList<MobWithSpawnChance>();
        boolean spawnOnlyOneMob;
        int blocksCooldown;
        int currentBlocksCooldown = 0;

        public BlockToMobConfig(List<String> blockIds, List<MobWithSpawnChance> mobs, boolean spawnOnlyOneMob, int blocksCooldown) {
            this.blockIds = blockIds;
            this.mobs = new ArrayList<MobWithSpawnChance>(mobs);
            this.mobs.sort(Comparator.comparingDouble(MobWithSpawnChance::getSpawnChance).reversed());
            this.spawnOnlyOneMob = spawnOnlyOneMob;
            this.blocksCooldown = blocksCooldown;
        }
    }

    class MobWithSpawnChance {
        String mobId;
        double spawnChance;

        public MobWithSpawnChance(String mobId, double spawnChance) {
            this.mobId = mobId;
            this.spawnChance = spawnChance;
        }

        public double getSpawnChance() {
            return this.spawnChance;
        }
    }
}

