/*
 * Decompiled with CFR 0.152.
 */
package org.regionEdit.libs.folialib.impl;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.regionEdit.libs.folialib.FoliaLib;
import org.regionEdit.libs.folialib.impl.SpigotImplementation;
import org.regionEdit.libs.folialib.util.ImplementationTestsUtil;

public class PaperImplementation
extends SpigotImplementation {
    private final FoliaLib foliaLib;
    private Method teleportAsyncMethod;

    public PaperImplementation(FoliaLib foliaLib) {
        super(foliaLib);
        this.foliaLib = foliaLib;
        if (ImplementationTestsUtil.isAsyncTeleportSupported()) {
            try {
                this.teleportAsyncMethod = Entity.class.getMethod("teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Failed to initialize PaperImplementation", noSuchMethodException);
            }
        }
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return ((SpigotImplementation)this).teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        if (!ImplementationTestsUtil.isAsyncTeleportSupported()) {
            return super.teleportAsync(entity, location, teleportCause);
        }
        try {
            return (CompletableFuture)this.teleportAsyncMethod.invoke((Object)entity, location, teleportCause);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return super.teleportAsync(entity, location, teleportCause);
        }
    }
}

