/*
 * Decompiled with CFR 0.152.
 */
package org.regionEdit.libs.folialib.impl;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import o.tQ;
import o.tR;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.regionEdit.libs.folialib.FoliaLib;
import org.regionEdit.libs.folialib.enums.EntityTaskResult;
import org.regionEdit.libs.folialib.impl.PlatformScheduler;
import org.regionEdit.libs.folialib.util.FoliaLibOptions;
import org.regionEdit.libs.folialib.util.ImplementationTestsUtil;
import org.regionEdit.libs.folialib.util.TimeConverter;
import org.regionEdit.libs.folialib.wrapper.task.WrappedBukkitTask;
import org.regionEdit.libs.folialib.wrapper.task.WrappedLegacyBukkitTask;
import org.regionEdit.libs.folialib.wrapper.task.WrappedTask;

public class LegacySpigotImplementation
implements PlatformScheduler {
    private final FoliaLib foliaLib;
    private final FoliaLibOptions options;
    private final Plugin plugin;
    @tQ
    private final BukkitScheduler scheduler;

    public LegacySpigotImplementation(FoliaLib foliaLib) {
        this.foliaLib = foliaLib;
        this.options = foliaLib.getOptions();
        this.plugin = foliaLib.getPlugin();
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Location location) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Location location, int n2) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Block block) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ World world, int n2, int n3) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ World world, int n2, int n3, int n4) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Entity entity) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isGlobalTickThread() {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    @tQ
    public CompletableFuture<Void> runNextTick(@tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTask(this.plugin, () -> {
            consumer.accept(wrappedTaskArray2[0]);
            completableFuture.complete(null);
        }));
        return completableFuture;
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAsync(@tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskAsynchronously(this.plugin, () -> {
            consumer.accept(wrappedTaskArray2[0]);
            completableFuture.complete(null);
        }));
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@tQ Runnable runnable, long l2) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, runnable, l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLater(@tQ Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, () -> {
            consumer.accept(wrappedTaskArray2[0]);
            completableFuture.complete(null);
        }, l2));
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runLater(runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLater(@tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runLater(consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runLaterAsync(@tQ Runnable runnable, long l2) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLaterAsync(@tQ Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLaterAsynchronously(this.plugin, () -> {
            consumer.accept(wrappedTaskArray2[0]);
            completableFuture.complete(null);
        }, l2));
        return completableFuture;
    }

    @Override
    public WrappedTask runLaterAsync(@tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runLaterAsync(runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLaterAsync(@tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runLaterAsync(consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runTimer(@tQ Runnable runnable, long l2, long l3) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runTimer(@tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, () -> consumer.accept(wrappedTaskArray2[0]), l2, l3));
    }

    @Override
    public WrappedTask runTimer(@tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runTimer(runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runTimer(@tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runTimer(consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public WrappedTask runTimerAsync(@tQ Runnable runnable, long l2, long l3) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runTimerAsync(@tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimerAsynchronously(this.plugin, () -> consumer.accept(wrappedTaskArray2[0]), l2, l3));
    }

    @Override
    public WrappedTask runTimerAsync(@tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runTimerAsync(runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runTimerAsync(@tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runTimerAsync(consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocation(Location location, @tQ Consumer<WrappedTask> consumer) {
        return this.runNextTick(consumer);
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @tQ Runnable runnable, long l2) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, runnable, l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocationLater(Location object, @tQ Consumer<WrappedTask> consumer, long l2) {
        object = new CompletableFuture();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, () -> LegacySpigotImplementation.lambda$runAtLocationLater$6(consumer, wrappedTaskArray2, (CompletableFuture)object), l2));
        return object;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocationLater(Location location, @tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @tQ Runnable runnable, long l2, long l3) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runAtLocationTimer(Location wrappedTaskArray, @tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        WrappedTask[] wrappedTaskArray2 = new WrappedTask[1];
        wrappedTaskArray = wrappedTaskArray2;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray2[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, () -> consumer.accept(wrappedTaskArray[0]), l2, l3));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtLocationTimer(location, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtLocationTimer(Location location, @tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtLocationTimer(location, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity object, @tQ Consumer<WrappedTask> consumer) {
        object = new CompletableFuture();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTask(this.plugin, () -> LegacySpigotImplementation.lambda$runAtEntity$8(consumer, wrappedTaskArray2, (CompletableFuture)object)));
        return object;
    }

    @Override
    @tQ
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, @tQ Consumer<WrappedTask> consumer, Runnable runnable) {
        CompletableFuture<EntityTaskResult> completableFuture = new CompletableFuture<EntityTaskResult>();
        WrappedTask[] wrappedTaskArray = new WrappedTask[1];
        WrappedTask[] wrappedTaskArray2 = wrappedTaskArray;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTask(this.plugin, () -> {
            if (this.isValid(entity)) {
                consumer.accept(wrappedTaskArray2[0]);
                completableFuture.complete(EntityTaskResult.SUCCESS);
                return;
            }
            runnable.run();
            completableFuture.complete(EntityTaskResult.ENTITY_RETIRED);
        }));
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, long l2) {
        return this.runAtEntityLater(entity, runnable, null, l2);
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, @tR Runnable runnable2, long l2) {
        if (!this.isValid(entity)) {
            if (runnable2 != null) {
                runnable2.run();
            }
            return null;
        }
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, runnable, l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2) {
        return this.runAtEntityLater(entity, consumer, null, l2);
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity wrappedTaskArray, @tQ Consumer<WrappedTask> consumer, Runnable runnable, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (!this.isValid((Entity)wrappedTaskArray) && runnable != null) {
            runnable.run();
            completableFuture.complete(null);
        }
        WrappedTask[] wrappedTaskArray2 = new WrappedTask[1];
        wrappedTaskArray = wrappedTaskArray2;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray2[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskLater(this.plugin, () -> {
            consumer.accept(wrappedTaskArray[0]);
            completableFuture.complete(null);
        }, l2));
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, long l2, long l3) {
        return this.runAtEntityTimer(entity, runnable, null, l2, l3);
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, Runnable runnable2, long l2, long l3) {
        if (!this.isValid(entity)) {
            if (runnable2 != null) {
                runnable2.run();
            }
            return null;
        }
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runAtEntityTimer(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        this.runAtEntityTimer(entity, consumer, null, l2, l3);
    }

    @Override
    public void runAtEntityTimer(Entity wrappedTaskArray, @tQ Consumer<WrappedTask> consumer, Runnable runnable, long l2, long l3) {
        if (!this.isValid((Entity)wrappedTaskArray) && runnable != null) {
            runnable.run();
        }
        WrappedTask[] wrappedTaskArray2 = new WrappedTask[1];
        wrappedTaskArray = wrappedTaskArray2;
        LegacySpigotImplementation legacySpigotImplementation = this;
        wrappedTaskArray2[0] = legacySpigotImplementation.wrapTask(legacySpigotImplementation.scheduler.runTaskTimer(this.plugin, () -> consumer.accept(wrappedTaskArray[0]), l2, l3));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtEntityTimer(entity, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtEntityTimer(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtEntityTimer(entity, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void cancelTask(WrappedTask wrappedTask) {
        wrappedTask.cancel();
    }

    @Override
    public void cancelAllTasks() {
        this.scheduler.cancelTasks(this.plugin);
    }

    @Override
    public List<WrappedTask> getAllTasks() {
        return this.scheduler.getPendingTasks().stream().filter(bukkitTask -> bukkitTask.getOwner().equals(this.plugin)).map(this::wrapTask).collect(Collectors.toList());
    }

    @Override
    public List<WrappedTask> getAllServerTasks() {
        return this.scheduler.getPendingTasks().stream().map(this::wrapTask).collect(Collectors.toList());
    }

    @Override
    public Player getPlayer(String string) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayer(string));
    }

    @Override
    public Player getPlayerExact(String string) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayerExact(string));
    }

    @Override
    public Player getPlayer(UUID uUID) {
        LegacySpigotImplementation legacySpigotImplementation = this;
        return legacySpigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayer(uUID));
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return this.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause object) {
        object = new CompletableFuture();
        this.runAtEntity(entity, arg_0 -> this.lambda$teleportAsync$16(entity, location, (CompletableFuture)object, arg_0));
        return object;
    }

    @Override
    public WrappedTask wrapTask(@tQ Object object) {
        Objects.requireNonNull(object, "nativeTask cannot be null");
        if (!(object instanceof BukkitTask)) {
            throw new IllegalArgumentException("The nativeTask provided must be a BukkitTask. Got: " + object.getClass().getName() + " instead.");
        }
        if (ImplementationTestsUtil.isCancelledSupported()) {
            return new WrappedBukkitTask((BukkitTask)object);
        }
        return new WrappedLegacyBukkitTask((BukkitTask)object);
    }

    private Player getPlayerFromMainThread(Supplier<Player> supplier) {
        if (this.plugin.getServer().isPrimaryThread()) {
            return supplier.get();
        }
        try {
            return (Player)this.scheduler.callSyncMethod(this.plugin, supplier::get).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private boolean isValid(Entity entity) {
        if (!this.options.useIsValidOnNonFolia()) {
            return true;
        }
        if (entity.isValid()) {
            return !(entity instanceof Player) || ((Player)entity).isOnline();
        }
        return entity instanceof Projectile && !entity.isDead();
    }

    private /* synthetic */ void lambda$teleportAsync$16(Entity entity, Location location, CompletableFuture completableFuture, WrappedTask wrappedTask) {
        if (this.isValid(entity)) {
            boolean bl2 = entity.teleport(location);
            completableFuture.complete(bl2);
            return;
        }
        completableFuture.complete(Boolean.FALSE);
    }

    private static /* synthetic */ void lambda$runAtEntity$8(Consumer consumer, WrappedTask[] wrappedTaskArray, CompletableFuture completableFuture) {
        consumer.accept(wrappedTaskArray[0]);
        completableFuture.complete(EntityTaskResult.SUCCESS);
    }

    private static /* synthetic */ void lambda$runAtLocationLater$6(Consumer consumer, WrappedTask[] wrappedTaskArray, CompletableFuture completableFuture) {
        consumer.accept(wrappedTaskArray[0]);
        completableFuture.complete(null);
    }
}

