/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import b.bc;
import b.tQ;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlinx.serialization.json.internal.ByteArrayPool8k;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\r\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#"}, d2={"Lkotlinx/serialization/json/internal/CharsetReader;", "", "Ljava/io/InputStream;", "p0", "Ljava/nio/charset/Charset;", "p1", "<init>", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "", "", "p2", "read", "([CII)I", "doRead", "fillByteBuffer", "()I", "oneShotReadSlowPath", "", "release", "()V", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetDecoder;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "Ljava/nio/ByteBuffer;", "byteBuffer", "Ljava/nio/ByteBuffer;", "", "hasLeftoverPotentiallySurrogateChar", "Z", "", "leftoverChar", "C"})
public final class CharsetReader {
    @tQ
    private final InputStream inputStream;
    @tQ
    private final Charset charset;
    @tQ
    private final CharsetDecoder decoder;
    @tQ
    private final ByteBuffer byteBuffer;
    private boolean hasLeftoverPotentiallySurrogateChar;
    private char leftoverChar;

    public CharsetReader(@tQ InputStream inputStream, @tQ Charset charset) {
        this.inputStream = inputStream;
        this.charset = charset;
        this.decoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        this.byteBuffer.flip();
    }

    public final int read(@tQ char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        if (!((n2 >= 0 ? n2 < cArray.length : false) && n3 >= 0 && n2 + n3 <= cArray.length)) {
            String string = "Unexpected arguments: " + n2 + ", " + n3 + ", " + cArray.length;
            throw new IllegalArgumentException(string.toString());
        }
        int n4 = 0;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            cArray[n2] = this.leftoverChar;
            ++n2;
            this.hasLeftoverPotentiallySurrogateChar = false;
            n4 = 1;
            if (--n3 == 0) {
                return 1;
            }
        }
        if (n3 == 1) {
            n3 = this.oneShotReadSlowPath();
            if (n3 == -1) {
                if (n4 == 0) {
                    return -1;
                }
                return 1;
            }
            cArray[n2] = (char)n3;
            return n4 + 1;
        }
        return this.doRead(cArray, n2, n3) + n4;
    }

    private final int doRead(char[] object, int n2, int n3) {
        CharBuffer charBuffer = CharBuffer.wrap((char[])object, n2, n3);
        object = charBuffer;
        if (charBuffer.position() != 0) {
            object = ((CharBuffer)object).slice();
        }
        n2 = 0;
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this.decoder.decode(this.byteBuffer, (CharBuffer)object, n2 != 0)).isUnderflow()) {
                if (n2 != 0 || !((Buffer)object).hasRemaining()) break;
                if (this.fillByteBuffer() >= 0) continue;
                n2 = 1;
                if (((Buffer)object).position() == 0 && !this.byteBuffer.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (coderResult.isOverflow()) {
                boolean bl2;
                boolean bl3 = bl2 = ((Buffer)object).position() > 0;
                if (!bc.a || bl2) break;
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            coderResult.throwException();
        }
        if (n2 != 0) {
            this.decoder.reset();
        }
        if (((Buffer)object).position() == 0) {
            return -1;
        }
        return ((Buffer)object).position();
    }

    private final int fillByteBuffer() {
        this.byteBuffer.compact();
        try {
            int n2 = this.byteBuffer.limit();
            int n3 = this.byteBuffer.position();
            n2 = n3 <= n2 ? n2 - n3 : 0;
            n2 = this.inputStream.read(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + n3, n2);
            if (n2 < 0) {
                return n2;
            }
            ((Buffer)this.byteBuffer).position(n3 + n2);
        }
        finally {
            this.byteBuffer.flip();
        }
        return this.byteBuffer.remaining();
    }

    private final int oneShotReadSlowPath() {
        if (this.hasLeftoverPotentiallySurrogateChar) {
            this.hasLeftoverPotentiallySurrogateChar = false;
            return this.leftoverChar;
        }
        char[] cArray = new char[2];
        int n2 = this.read(cArray, 0, 2);
        switch (n2) {
            case -1: {
                return -1;
            }
            case 1: {
                return cArray[0];
            }
            case 2: {
                this.leftoverChar = cArray[1];
                this.hasLeftoverPotentiallySurrogateChar = true;
                return cArray[0];
            }
        }
        throw new IllegalStateException("Unreachable state: ".concat(String.valueOf(n2)).toString());
    }

    public final void release() {
        ByteArrayPool8k.INSTANCE.release(this.byteBuffer.array());
    }
}

