/*
 * Decompiled with CFR 0.152.
 */
package org.regionEdit.libs.folialib.impl;

import c.tQ;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.regionEdit.libs.folialib.FoliaLib;
import org.regionEdit.libs.folialib.enums.EntityTaskResult;
import org.regionEdit.libs.folialib.impl.PlatformScheduler;
import org.regionEdit.libs.folialib.util.InvalidTickDelayNotifier;
import org.regionEdit.libs.folialib.util.TimeConverter;
import org.regionEdit.libs.folialib.wrapper.task.WrappedFoliaTask;
import org.regionEdit.libs.folialib.wrapper.task.WrappedTask;

public class FoliaImplementation
implements PlatformScheduler {
    private final FoliaLib foliaLib;
    private final Plugin plugin;
    private final GlobalRegionScheduler globalRegionScheduler;
    private final RegionScheduler regionScheduler;
    private final AsyncScheduler asyncScheduler;
    private final InvalidTickDelayNotifier tickNotifier;

    public FoliaImplementation(FoliaLib foliaLib) {
        this.foliaLib = foliaLib;
        this.plugin = foliaLib.getPlugin();
        this.globalRegionScheduler = this.plugin.getServer().getGlobalRegionScheduler();
        this.regionScheduler = this.plugin.getServer().getRegionScheduler();
        this.asyncScheduler = this.plugin.getServer().getAsyncScheduler();
        this.tickNotifier = this.foliaLib.getInvalidTickDelayNotifier();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Location location) {
        return this.plugin.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Location location, int n2) {
        return this.plugin.getServer().isOwnedByCurrentRegion(location, n2);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Block block) {
        return this.plugin.getServer().isOwnedByCurrentRegion(block);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ World world, int n2, int n3) {
        return this.plugin.getServer().isOwnedByCurrentRegion(world, n2, n3);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ World world, int n2, int n3, int n4) {
        return this.plugin.getServer().isOwnedByCurrentRegion(world, n2, n3, n4);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@tQ Entity entity) {
        return this.plugin.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isGlobalTickThread() {
        return this.plugin.getServer().isGlobalTickThread();
    }

    @Override
    @tQ
    public CompletableFuture<Void> runNextTick(@tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.globalRegionScheduler.run(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAsync(@tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.asyncScheduler.runNow(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@tQ Runnable runnable, long l2) {
        l2 = this.ensureValidDuration(l2);
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.globalRegionScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLater(@tQ Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        l2 = this.ensureValidDuration(l2);
        this.globalRegionScheduler.runDelayed(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        }, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runLater(runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLater(@tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runLater(consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runLaterAsync(@tQ Runnable runnable, long l2) {
        return this.runLaterAsync(runnable, TimeConverter.toMillis(l2), TimeUnit.MILLISECONDS);
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLaterAsync(@tQ Consumer<WrappedTask> consumer, long l2) {
        return this.runLaterAsync(consumer, TimeConverter.toMillis(l2), TimeUnit.MILLISECONDS);
    }

    @Override
    public WrappedTask runLaterAsync(@tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.asyncScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runLaterAsync(@tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.asyncScheduler.runDelayed(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        }, l2, timeUnit);
        return completableFuture;
    }

    @Override
    public WrappedTask runTimer(@tQ Runnable runnable, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.globalRegionScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l2, l3));
    }

    @Override
    public void runTimer(@tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        this.globalRegionScheduler.runAtFixedRate(this.plugin, scheduledTask -> consumer.accept(this.wrapTask(scheduledTask)), l2, l3);
    }

    @Override
    public WrappedTask runTimer(@tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runTimer(runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runTimer(@tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runTimer(consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public WrappedTask runTimerAsync(@tQ Runnable runnable, long l2, long l3) {
        return this.runTimerAsync(runnable, TimeConverter.toMillis(l2), TimeConverter.toMillis(l3), TimeUnit.MILLISECONDS);
    }

    @Override
    public void runTimerAsync(@tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        this.runTimerAsync(consumer, TimeConverter.toMillis(l2), TimeConverter.toMillis(l3), TimeUnit.MILLISECONDS);
    }

    @Override
    public WrappedTask runTimerAsync(@tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.asyncScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l2, l3, timeUnit));
    }

    @Override
    public void runTimerAsync(@tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.asyncScheduler.runAtFixedRate(this.plugin, scheduledTask -> consumer.accept(this.wrapTask(scheduledTask)), l2, l3, timeUnit);
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocation(Location location, @tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.regionScheduler.run(this.plugin, location, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @tQ Runnable runnable, long l2) {
        l2 = this.ensureValidDuration(l2);
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.regionScheduler.runDelayed(this.plugin, location, scheduledTask -> runnable.run(), l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocationLater(Location location, @tQ Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        l2 = this.ensureValidDuration(l2);
        this.regionScheduler.runDelayed(this.plugin, location, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        }, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtLocationLater(Location location, @tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @tQ Runnable runnable, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        FoliaImplementation foliaImplementation = this;
        return foliaImplementation.wrapTask(foliaImplementation.regionScheduler.runAtFixedRate(this.plugin, location, scheduledTask -> runnable.run(), l2, l3));
    }

    @Override
    public void runAtLocationTimer(Location location, @tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        this.regionScheduler.runAtFixedRate(this.plugin, location, scheduledTask -> consumer.accept(this.wrapTask(scheduledTask)), l2, l3);
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtLocationTimer(location, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtLocationTimer(Location location, @tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtLocationTimer(location, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity entity, @tQ Consumer<WrappedTask> consumer) {
        CompletableFuture<EntityTaskResult> completableFuture = new CompletableFuture<EntityTaskResult>();
        if (entity.getScheduler().run(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(EntityTaskResult.SUCCESS);
        }, null) == null) {
            completableFuture.complete(EntityTaskResult.SCHEDULER_RETIRED);
        }
        return completableFuture;
    }

    @Override
    @tQ
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, @tQ Consumer<WrappedTask> consumer, Runnable runnable) {
        CompletableFuture<EntityTaskResult> completableFuture = new CompletableFuture<EntityTaskResult>();
        if (entity.getScheduler().run(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(EntityTaskResult.SUCCESS);
        }, () -> {
            runnable.run();
            completableFuture.complete(EntityTaskResult.ENTITY_RETIRED);
        }) == null) {
            completableFuture.complete(EntityTaskResult.SCHEDULER_RETIRED);
        }
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, long l2) {
        return this.runAtEntityLater(entity, runnable, null, l2);
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, Runnable runnable2, long l2) {
        l2 = this.ensureValidDuration(l2);
        return this.wrapTask(entity.getScheduler().runDelayed(this.plugin, scheduledTask -> runnable.run(), runnable2, l2));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2) {
        return this.runAtEntityLater(entity, consumer, null, l2);
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @tQ Consumer<WrappedTask> consumer, Runnable runnable, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (runnable != null) {
            runnable = () -> {
                runnable.run();
                completableFuture.complete(null);
            };
        }
        l2 = this.ensureValidDuration(l2);
        entity.getScheduler().runDelayed(this.plugin, scheduledTask -> {
            consumer.accept(this.wrapTask(scheduledTask));
            completableFuture.complete(null);
        }, runnable, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @tQ Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @tQ
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, long l2, long l3) {
        return this.runAtEntityTimer(entity, runnable, null, l2, l3);
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, Runnable runnable2, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        return this.wrapTask(entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), runnable2, l2, l3));
    }

    @Override
    public void runAtEntityTimer(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, long l3) {
        this.runAtEntityTimer(entity, consumer, null, l2, l3);
    }

    @Override
    public void runAtEntityTimer(Entity entity, @tQ Consumer<WrappedTask> consumer, Runnable runnable, long l2, long l3) {
        l2 = this.ensureValidDuration(l2);
        l3 = this.ensureValidDuration(l3);
        entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> consumer.accept(this.wrapTask(scheduledTask)), runnable, l2, l3);
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @tQ Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtEntityTimer(entity, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtEntityTimer(Entity entity, @tQ Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtEntityTimer(entity, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void cancelTask(WrappedTask wrappedTask) {
        wrappedTask.cancel();
    }

    @Override
    public void cancelAllTasks() {
        this.globalRegionScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    public List<WrappedTask> getAllTasks() {
        try {
            return this.getAllScheduledTasks().stream().filter(scheduledTask -> scheduledTask.getOwningPlugin().equals(this.plugin)).map(this::wrapTask).collect(Collectors.toList());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public List<WrappedTask> getAllServerTasks() {
        try {
            return this.getAllScheduledTasks().stream().map(this::wrapTask).collect(Collectors.toList());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @tQ
    private List<ScheduledTask> getAllScheduledTasks() throws NoSuchFieldException, IllegalAccessException {
        Object object = this.globalRegionScheduler.getClass().getDeclaredField("tasksByDeadline");
        boolean bl2 = ((AccessibleObject)object).isAccessible();
        ((Field)object).setAccessible(true);
        Object object22 = (Long2ObjectOpenHashMap)((Field)object).get(this.globalRegionScheduler);
        ((Field)object).setAccessible(bl2);
        object = this.asyncScheduler.getClass().getDeclaredField("tasks");
        bl2 = ((AccessibleObject)object).isAccessible();
        ((Field)object).setAccessible(true);
        Set set = (Set)((Field)object).get(this.asyncScheduler);
        ((Field)object).setAccessible(bl2);
        object = new ArrayList();
        for (Object object22 : object22.values()) {
            object.addAll(object22);
        }
        ArrayList arrayList = new ArrayList(object.size() + set.size());
        arrayList.addAll(object);
        arrayList.addAll(set);
        return arrayList;
    }

    @Override
    public Player getPlayer(String string) {
        return this.plugin.getServer().getPlayer(string);
    }

    @Override
    public Player getPlayerExact(String string) {
        return this.plugin.getServer().getPlayerExact(string);
    }

    @Override
    public Player getPlayer(UUID uUID) {
        return this.plugin.getServer().getPlayer(uUID);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return entity.teleportAsync(location);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return entity.teleportAsync(location, teleportCause);
    }

    @Override
    public WrappedTask wrapTask(@tQ Object object) {
        Objects.requireNonNull(object, "nativeTask");
        if (!(object instanceof ScheduledTask)) {
            throw new IllegalArgumentException("The nativeTask provided must be a ScheduledTask. Got: " + object.getClass().getName() + " instead.");
        }
        return new WrappedFoliaTask((ScheduledTask)object);
    }

    private long ensureValidDuration(long l2) {
        if (l2 <= 0L) {
            this.tickNotifier.notifyOnce(l2);
            return 1L;
        }
        return l2;
    }
}

