/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.fabric.common;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AddressParser {
    public Integer protocol;
    public String viaSuffix;
    public String serverAddress;
    public String viaOptions;

    public AddressParser parse(String address) {
        return this.parse(address, "viafabric");
    }

    public String getSuffixWithOptions() {
        if (this.viaOptions != null && !this.viaOptions.isEmpty()) {
            return this.viaOptions + "." + this.viaSuffix;
        }
        return this.viaSuffix;
    }

    public AddressParser parse(String address, String viaHostName) {
        String suffixRemoved = StringUtils.removeEnd((String)(address = StringUtils.removeEnd((String)address, (String)".")), (String)("." + viaHostName));
        if (suffixRemoved.equals(address)) {
            this.serverAddress = address;
            return this;
        }
        boolean stopOptions = false;
        ArrayList<String> optionsParts = new ArrayList<String>();
        ArrayList<String> serverParts = new ArrayList<String>();
        for (String part : Lists.reverse(Arrays.asList(suffixRemoved.split(Pattern.quote("."))))) {
            if (!stopOptions && this.parseOption(part)) {
                optionsParts.add(part);
                continue;
            }
            stopOptions = true;
            serverParts.add(part);
        }
        this.serverAddress = String.join((CharSequence)".", Lists.reverse(serverParts));
        this.viaOptions = String.join((CharSequence)".", Lists.reverse(optionsParts));
        this.viaSuffix = viaHostName;
        return this;
    }

    public boolean parseOption(String part) {
        String option;
        if (part.length() < 2) {
            return false;
        }
        if (part.startsWith("_")) {
            option = String.valueOf(part.charAt(1));
        } else if (part.charAt(1) == '_') {
            option = String.valueOf(part.charAt(0));
        } else {
            return false;
        }
        String arg = part.substring(2);
        if ("v".equals(option)) {
            this.parseProtocol(arg);
        }
        return true;
    }

    public void parseProtocol(String arg) {
        ProtocolVersion ver;
        this.protocol = Ints.tryParse((String)arg);
        if (this.protocol == null && (ver = ProtocolVersion.getClosest((String)arg.replace("_", "."))) != null) {
            this.protocol = ver.getVersion();
        }
    }
}

