/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.block;

import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockVoidOre
extends DropExperienceBlock {
    public BlockVoidOre(BlockBehaviour.Properties properties) {
        super((IntProvider)UniformInt.of((int)12000, (int)12000), properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!(player.getMainHandItem().isEnchanted() && player.getMainHandItem().getEnchantments().keySet().contains(level.registryAccess().holderOrThrow(Enchantments.SILK_TOUCH)) || level.isClientSide())) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, false, Level.ExplosionInteraction.BLOCK);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.1f, (double)0.1f, (double)0.1f, (double)15.9f, (double)15.9f, (double)15.9f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity != null) {
            entity.hurt(entity.damageSources().fellOutOfWorld(), 4.0f);
            entity.setDeltaMovement(entity.getDeltaMovement().x * 0.2, entity.getDeltaMovement().y, entity.getDeltaMovement().z * 0.2);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.getRandom().nextInt(10) == 0) {
                    livingEntity.setRemainingFireTicks(40);
                }
                if (livingEntity.getRandom().nextInt(60) == 0 && !level.isClientSide()) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 160, 1));
                }
            }
        }
    }

    private static void spawnParticles(Level level, BlockPos pos) {
        double d0 = 0.5625;
        RandomSource randomSource = level.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = pos.relative(direction);
            if (level.getBlockState(blockPos).isSolidRender((BlockGetter)level, blockPos)) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.getStepX() : (double)randomSource.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.getStepY() : (double)randomSource.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.getStepZ() : (double)randomSource.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
            for (int i = 0; i < 4; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(20) == 0) {
            level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)TheTitansNeoSounds.HARCACADIUM_BLOCK_HUM.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        BlockVoidOre.spawnParticles(level, pos);
    }
}

