/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.effect;

import java.awt.Color;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanSpirit;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MobEffectDeath
extends MobEffect {
    public MobEffectDeath() {
        super(MobEffectCategory.HARMFUL, new Color(0.0f, 0.0f, 0.0f, 1.0f).getRGB());
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int k = 40 >> amplifier;
        return k > 0 ? duration % k == 0 : true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.isAlive()) {
            entity.hurt(entity.damageSources().fellOutOfWorld(), 4.0f * (float)(amplifier + 1));
            entity.setRemainingFireTicks(20);
            if (entity.deathTime > 0) {
                ++entity.deathTime;
                if (entity.deathTime > 20 && !entity.level().isClientSide()) {
                    entity.level().broadcastEntityEvent((Entity)entity, (byte)60);
                    entity.remove(Entity.RemovalReason.KILLED);
                }
            }
            if (entity.getMaxHealth() > 1.0E9f && !(entity instanceof EntityTitan) && !(entity instanceof EntityTitanSpirit) && !(entity instanceof Player)) {
                entity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 2.0f, 1.0f + entity.getRandom().nextFloat());
                entity.setHealth(entity.getHealth() / 2.0f);
                if (entity.getHealth() <= 1.0f) {
                    entity.level().explode(null, entity.getX(), entity.getY(), entity.getZ(), 7.0f, false, Level.ExplosionInteraction.MOB);
                    if (!entity.level().isClientSide()) {
                        entity.level().broadcastEntityEvent((Entity)entity, (byte)60);
                        entity.remove(Entity.RemovalReason.KILLED);
                    }
                }
            }
        }
        return true;
    }
}

