/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity;

import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;

public class EntityColorLightningBolt
extends LightningBolt {
    private static final EntityDataAccessor<Float> DATA_EFFECT_RED_ID = SynchedEntityData.defineId(EntityColorLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_EFFECT_GREEN_ID = SynchedEntityData.defineId(EntityColorLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_EFFECT_BLUE_ID = SynchedEntityData.defineId(EntityColorLightningBolt.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public EntityColorLightningBolt(EntityType<? extends EntityColorLightningBolt> entityType, Level level) {
        super(entityType, level);
    }

    public EntityColorLightningBolt(Level level, float red, float green, float blue) {
        super((EntityType)TheTitansNeoEntities.COLOR_LIGHTNING_BLOT.get(), level);
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setDamage(50.0f);
    }

    public float getRed() {
        return ((Float)this.entityData.get(DATA_EFFECT_RED_ID)).floatValue();
    }

    public void setRed(float red) {
        this.entityData.set(DATA_EFFECT_RED_ID, (Object)Float.valueOf(red));
    }

    public float getGreen() {
        return ((Float)this.entityData.get(DATA_EFFECT_GREEN_ID)).floatValue();
    }

    public void setGreen(float green) {
        this.entityData.set(DATA_EFFECT_GREEN_ID, (Object)Float.valueOf(green));
    }

    public float getBlue() {
        return ((Float)this.entityData.get(DATA_EFFECT_BLUE_ID)).floatValue();
    }

    public void setBlue(float blue) {
        this.entityData.set(DATA_EFFECT_BLUE_ID, (Object)Float.valueOf(blue));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_EFFECT_RED_ID, (Object)Float.valueOf(1.0f));
        builder.define(DATA_EFFECT_GREEN_ID, (Object)Float.valueOf(1.0f));
        builder.define(DATA_EFFECT_BLUE_ID, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setRed(tag.getFloat("red"));
        this.setGreen(tag.getFloat("green"));
        this.setBlue(tag.getFloat("blue"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("red", this.getRed());
        tag.putFloat("green", this.getGreen());
        tag.putFloat("blue", this.getBlue());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0 * EntityColorLightningBolt.getViewScale();
        return distance < d0 * d0;
    }
}

