/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.thetitansneo.entity.EntityWitherTurret;
import net.byAqua3.thetitansneo.entity.projectile.EntityMortarWitherSkull;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEnchantments;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityWitherTurretMortar
extends EntityWitherTurret {
    public EntityWitherTurretMortar(EntityType<? extends EntityWitherTurret> entityType, Level level) {
        super(entityType, level);
    }

    public EntityWitherTurretMortar(Level level) {
        this((EntityType<? extends EntityWitherTurret>)((EntityType)TheTitansNeoEntities.WITHER_TURRET_MORTAR.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 7000.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 200.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    protected ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)TheTitansNeoItems.WITHER_TURRET_MORTAR.get());
        if (this.durabilityLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.HEALING), this.durabilityLevel);
        }
        if (this.ferocityLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.DAMAGE), this.ferocityLevel);
        }
        if (this.maniacLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.SHOOTING_SPEED), this.maniacLevel);
        }
        if (this.unstabilityLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.EXPLOSIVE_POWER), this.unstabilityLevel);
        }
        if (this.shurakinLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.SKULL_SPEED), this.shurakinLevel);
        }
        if (this.unbreakingLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(Enchantments.UNBREAKING), this.unbreakingLevel);
        }
        if (this.titanKillerLevel > 0) {
            itemStack.enchant(this.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.TITAN_KILLER), this.titanKillerLevel);
        }
        return itemStack;
    }

    @Override
    protected void performRangedAttack(int head, double x, double y, double z, boolean isDangerous) {
        if (this.shootingTimer <= 0) {
            this.playSound((SoundEvent)TheTitansNeoSounds.MORTAR_SHOOT.get(), 6.0f, 1.0f);
            double d0 = this.getHeadX(head);
            double d1 = this.getHeadY(head);
            double d2 = this.getHeadZ(head);
            double d3 = x - d0;
            double d4 = y - d1;
            double d5 = z - d2;
            Vec3 vec3 = new Vec3(d3, d4, d5);
            EntityMortarWitherSkull witherSkull = new EntityMortarWitherSkull(this.level(), (LivingEntity)this, vec3.normalize());
            witherSkull.setPos(d0, d1, d2);
            witherSkull.setDangerous(true);
            witherSkull.extraDamage = this.ferocityLevel * 2;
            witherSkull.explosivePower = (int)((float)this.unstabilityLevel * 0.75f);
            witherSkull.speedFactor = (float)this.shurakinLevel * 0.1f;
            witherSkull.titanDamage = this.titanKillerLevel * 10;
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)witherSkull);
            }
            BlockPos blockPos = this.blockPosition().below();
            BlockState blockState = this.level().getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block != Blocks.GLOWSTONE) {
                this.level().setBlockAndUpdate(blockPos, Blocks.GLOWSTONE.defaultBlockState());
            }
            this.shootingTimer = 60 - this.maniacLevel * 10;
        }
    }

    @Override
    public void performRangedAttack(LivingEntity target, float velocity) {
        this.performRangedAttack(0, target);
    }

    @Override
    protected void tickDeath() {
        this.playSound((SoundEvent)TheTitansNeoSounds.TURRET_DEATH_3.get(), 6.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)this, this.getX(), this.getY() - 1.0, this.getZ(), 2.0f, true, Level.ExplosionInteraction.MOB);
        }
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ItemStack itemStack = ItemStack.EMPTY;
            if (this.isPlayerCreated()) {
                itemStack = this.getItemStack();
            } else {
                itemStack = new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL);
                itemStack.setCount(3);
                drops.add(new ItemStack((ItemLike)Blocks.BEACON));
                ItemStack netherStar = new ItemStack((ItemLike)Items.NETHER_STAR);
                netherStar.setCount(this.getRandom().nextInt(3));
                drops.add(new ItemStack((ItemLike)Items.NETHER_STAR));
            }
            drops.add(itemStack);
            for (ItemStack drop : drops) {
                ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY() + 3.0, this.getZ(), drop);
                itemEntity.setDefaultPickUpDelay();
                if (this.level().isClientSide()) continue;
                this.level().addFreshEntity((Entity)itemEntity);
            }
            if (!this.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)this.position(), (int)1000);
            }
        }
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    @Override
    public void aiStep() {
        this.originalAiStep();
        BlockPos blockPos = this.blockPosition().below();
        BlockState blockState = this.level().getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block != Blocks.BEDROCK) {
            this.level().setBlockAndUpdate(blockPos, Blocks.BEDROCK.defaultBlockState());
        }
        if (this.getTarget() == null) {
            double d8 = 49.0;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(50.0, 100.0, 50.0).move(dx, 0.0, dz));
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (entity == null || !(entity instanceof LivingEntity) || !this.hasLineOfSight((Entity)(livingEntity = (LivingEntity)entity)) || !this.canTargetEntity(livingEntity)) continue;
                this.setTarget(livingEntity);
            }
        } else {
            this.getLookControl().setLookAt((Entity)this.getTarget(), 10.0f, 180.0f);
            this.performRangedAttack(this.getTarget(), 1.0f);
            if (!this.getTarget().isAlive() || this.getTarget().isRemoved() || this.distanceToSqr((Entity)this.getTarget()) > 10000.0 || !this.hasLineOfSight((Entity)this.getTarget()) || !this.canTargetEntity(this.getTarget())) {
                this.setTarget(null);
            }
        }
    }

    @Override
    public void tick() {
        this.originalTick();
        this.setOnGround(true);
        this.hasImpulse = false;
        this.setYRot(this.yHeadRot);
        this.yBodyRot = this.yHeadRot;
        if (this.shootingTimer >= 0) {
            --this.shootingTimer;
        }
        if (this.shootingTimer <= 0) {
            this.shootingTimer = 0;
        }
        for (int i = 0; i < 6; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + this.getRandom().nextGaussian() * (double)0.3f, this.getY() + (double)this.getEyeHeight() + this.getRandom().nextGaussian() * (double)0.3f, this.getZ() + this.getRandom().nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
        }
        if (this.tickCount % 40 == 0) {
            this.heal(1.0f + (float)this.durabilityLevel);
        }
    }
}

