/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.minion;

import java.util.List;
import java.util.function.Predicate;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;

public class EntityAIFindMaster
extends Goal {
    private IMinion entity;
    private double range;
    private Predicate<EntityTitan> predicate;

    public EntityAIFindMaster(IMinion entity, double range, Predicate<EntityTitan> predicate) {
        this.entity = entity;
        this.range = range;
        this.predicate = predicate;
    }

    public boolean canUse() {
        Mob mob = (Mob)this.entity;
        return mob.isAlive();
    }

    public void tick() {
        Mob mob = (Mob)this.entity;
        if (this.entity.getMaster() == null) {
            List entities = mob.level().getEntitiesOfClass(EntityTitan.class, mob.getBoundingBox().inflate(this.range, this.range, this.range));
            if (!entities.isEmpty()) {
                for (EntityTitan entity : entities) {
                    if (entity == null || !this.predicate.test(entity)) continue;
                    this.entity.setMaster(entity);
                }
            }
        } else {
            if (mob.horizontalCollision) {
                mob.setDeltaMovement(mob.getDeltaMovement().x, 0.2, mob.getDeltaMovement().z);
            }
            if (mob.distanceToSqr((Entity)this.entity.getMaster()) > 2304.0) {
                mob.getMoveControl().setWantedPosition(this.entity.getMaster().getX(), this.entity.getMaster().getY(), this.entity.getMaster().getZ(), 2.0);
            } else if (this.entity.getMaster().getTarget() != null) {
                if (this.entity.getMaster().getTarget().getBbHeight() < 6.0f) {
                    mob.setTarget(this.entity.getMaster().getTarget());
                } else {
                    mob.getLookControl().setLookAt((Entity)this.entity.getMaster().getTarget(), 10.0f, 40.0f);
                }
                if (this.entity.getMaster() instanceof EntityZombieTitan) {
                    if (this.entity.getMaster().getAnimationID() == 11 && this.entity.getMaster().getAnimationTick() > 80) {
                        mob.getMoveControl().setWantedPosition(this.entity.getMaster().getTarget().getX(), this.entity.getMaster().getTarget().getY(), this.entity.getMaster().getTarget().getZ(), 10.0);
                    }
                    if (this.entity.getMaster().getTarget() instanceof Villager && mob.tickCount % 10 == 0) {
                        if (mob.distanceToSqr((Entity)this.entity.getMaster().getTarget()) > 256.0) {
                            mob.getMoveControl().setWantedPosition(this.entity.getMaster().getTarget().getX(), this.entity.getMaster().getTarget().getY(), this.entity.getMaster().getTarget().getZ(), 1.0);
                        } else {
                            mob.getNavigation().moveTo((Entity)this.entity.getMaster().getTarget(), 1.0);
                        }
                    }
                }
            }
        }
    }
}

