/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.minion.ghast;

import net.byAqua3.thetitansneo.entity.minion.EntityGhastTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAIGhastTitanMinionMoveControl
extends MoveControl {
    private EntityGhastTitanMinion entity;
    private int floatDuration;

    public EntityAIGhastTitanMinionMoveControl(EntityGhastTitanMinion entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
            this.floatDuration = this.floatDuration + this.entity.getRandom().nextInt(5) + 2;
            Vec3 vec3 = new Vec3(this.wantedX - this.entity.getX(), this.wantedY - this.entity.getY(), this.wantedZ - this.entity.getZ());
            double d0 = vec3.length();
            if (this.canReach(vec3 = vec3.normalize(), Mth.ceil((double)d0))) {
                double scale;
                double d = scale = this.entity.getMinionType() == EnumMinionType.ZEALOT ? 0.8 : 0.2;
                scale = this.entity.master != null && this.entity.distanceToSqr((Entity)this.entity.master) > 4096.0 ? (this.entity.getMinionType() == EnumMinionType.ZEALOT ? 0.8 : 0.2) : (this.entity.getMinionType() == EnumMinionType.ZEALOT ? 0.4 : 0.1);
                this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(vec3.scale(scale)));
            } else {
                this.operation = MoveControl.Operation.WAIT;
            }
        }
    }

    private boolean canReach(Vec3 pos, int length) {
        AABB aabb = this.entity.getBoundingBox();
        for (int i = 1; i < length; ++i) {
            aabb = aabb.move(pos);
            if (this.entity.level().noCollision((Entity)this.entity, aabb)) continue;
            return false;
        }
        return true;
    }
}

