/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.minion.ghast;

import net.byAqua3.thetitansneo.entity.minion.EntityGhastTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.projectile.EntityGhastTitanMinionFireball;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityAIGhastTitanMinionShoot
extends Goal {
    private EntityGhastTitanMinion entity;

    public EntityAIGhastTitanMinionShoot(EntityGhastTitanMinion entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        return this.entity.getTarget() != null;
    }

    public void start() {
        this.entity.attackCounter = 0;
    }

    public void stop() {
        this.entity.setCharging(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.entity.getTarget();
        if (target != null) {
            if (target.distanceToSqr((Entity)this.entity) < this.getFollowDistance() * this.getFollowDistance() && this.entity.hasLineOfSight((Entity)target)) {
                EntityGhastTitanMinionFireball fireball;
                Vec3 vec31;
                double d4;
                double d3;
                double d2;
                Vec3 vec3;
                double d8;
                Level level = this.entity.level();
                ++this.entity.attackCounter;
                if (this.entity.attackCounter == 10 && !this.entity.isSilent()) {
                    level.levelEvent(null, 1015, this.entity.blockPosition(), 0);
                }
                if (this.entity.getMinionType() == EnumMinionType.TEMPLAR && this.entity.attackCounter > 20) {
                    d8 = 2.0;
                    vec3 = this.entity.getViewVector(1.0f);
                    d2 = target.getX() - (this.entity.getX() + vec3.x * d8);
                    d3 = target.getY() - (this.entity.getY() + vec3.y * d8) + 1.0;
                    d4 = target.getZ() - (this.entity.getZ() + vec3.z * d8);
                    vec31 = new Vec3(d2, d3, d4);
                    if (!this.entity.isSilent()) {
                        level.levelEvent(null, 1016, this.entity.blockPosition(), 0);
                    }
                    fireball = new EntityGhastTitanMinionFireball(level, (LivingEntity)this.entity, vec31.normalize(), this.entity.getExplosionPower());
                    fireball.setPos(this.entity.getX() + vec3.x * d8, this.entity.getY() + vec3.y * d8 + 1.0, this.entity.getZ() + vec3.z * d8);
                    level.addFreshEntity((Entity)fireball);
                }
                if (this.entity.attackCounter >= (this.entity.getMinionType() == EnumMinionType.TEMPLAR ? 40 : 20)) {
                    d8 = 2.0;
                    vec3 = this.entity.getViewVector(1.0f);
                    d2 = target.getX() - (this.entity.getX() + vec3.x * d8);
                    d3 = target.getY() - (this.entity.getY() + vec3.y * d8) + 1.0;
                    d4 = target.getZ() - (this.entity.getZ() + vec3.z * d8);
                    vec31 = new Vec3(d2, d3, d4);
                    if (!this.entity.isSilent()) {
                        level.levelEvent(null, 1016, this.entity.blockPosition(), 0);
                    }
                    fireball = new EntityGhastTitanMinionFireball(level, (LivingEntity)this.entity, vec31.normalize(), this.entity.getExplosionPower());
                    fireball.setPos(this.entity.getX() + vec3.x * d8, this.entity.getY() + vec3.y * d8 + 1.0, this.entity.getZ() + vec3.z * d8);
                    level.addFreshEntity((Entity)fireball);
                    this.entity.attackCounter = this.entity.getMinionType() == EnumMinionType.ZEALOT ? 0 : -40;
                }
            } else if (this.entity.attackCounter > 0) {
                --this.entity.attackCounter;
            }
            this.entity.setCharging(this.entity.attackCounter > 10);
        }
    }

    private double getFollowDistance() {
        return this.entity.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue();
    }
}

