/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.minion;

import java.util.List;
import java.util.Optional;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.minion.EntityZombieTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;

public class EntityDragonMinion
extends EnderDragon
implements IMinion {
    private static final EntityDataAccessor<Integer> MINION_TYPE = SynchedEntityData.defineId(EntityDragonMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public EntityTitan master;

    public EntityDragonMinion(EntityType<? extends EntityDragonMinion> entityType, Level level) {
        super(entityType, level);
        this.type = entityType;
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(entityType));
        this.setHealth(this.getMaxHealth());
        this.getPhaseManager().setPhase(EnderDragonPhase.getById((int)0));
    }

    public EntityDragonMinion(Level level) {
        this((EntityType<? extends EntityDragonMinion>)((EntityType)TheTitansNeoEntities.DRAGON_MINION.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EnderDragon.createAttributes().add(Attributes.MAX_HEALTH, 4000.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof AvoidEntityGoal);
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.EnderColossusSorter));
    }

    @Override
    public int getMinionTypeInt() {
        return (Integer)this.getEntityData().get(MINION_TYPE);
    }

    @Override
    public void setMinionType(int minionType) {
        this.getEntityData().set(MINION_TYPE, (Object)minionType);
        this.refreshAttributes();
    }

    @Override
    public EntityTitan getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(EntityTitan master) {
        this.master = master;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MINION_TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMinionType(tag.getInt("MinionType"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MinionType", this.getMinionTypeInt());
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.SPECIAL;
    }

    public boolean canAttack(LivingEntity target) {
        if (this.master != null) {
            return this.master.canAttack(target);
        }
        return target.canBeSeenByAnyone();
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != TheTitansNeoEntities.ENDER_COLOSSUS.get() && entityType != TheTitansNeoEntities.ENDER_COLOSSUS_MINION.get() && entityType != TheTitansNeoEntities.DRAGON_MINION.get();
    }

    public boolean fireImmune() {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENDER_DRAGON_DEATH;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.master != null) {
            this.master.retractMinionNumFromType(this.getMinionType());
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (this.isInvulnerable()) {
            return false;
        }
        if (entity instanceof EntityZombieTitanMinion || entity instanceof EntityEnderColossus || entity instanceof EnderDragon || entity instanceof EntityDragonMinion) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            for (Entity entity1 : entities) {
                if (entity1 instanceof EntityDragonMinion) {
                    EntityDragonMinion dragonMinion = (EntityDragonMinion)entity1;
                    dragonMinion.setTarget(livingEntity);
                }
                this.setTarget(livingEntity);
            }
        }
        return super.hurt(damageSource, amount);
    }

    public void hurt(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            this.flapTime += 1.0f;
            this.playAmbientSound();
            DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
            entity.hurt(damageSource, 200.0f);
            entity.invulnerableTime = 0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverlevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)damageSource);
        }
    }

    public void aiStep() {
        block4: {
            block2: {
                block3: {
                    super.aiStep();
                    if (this.master == null) break block2;
                    if (this.master.getTarget() == null) break block3;
                    this.setTarget(this.master.getTarget());
                    break block4;
                }
                if (!(this.distanceToSqr((Entity)this.master) > 10000.0)) break block4;
                this.getPhaseManager().setPhase(EnderDragonPhase.TAKEOFF);
                break block4;
            }
            List entities = this.level().getEntitiesOfClass(EntityTitan.class, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            if (!entities.isEmpty()) {
                for (EntityTitan entity : entities) {
                    if (entity == null || !(entity instanceof EntityEnderColossus)) continue;
                    this.setMaster(entity);
                }
            }
        }
    }

    protected void tickDeath() {
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            int x = Mth.floor((double)this.getX());
            int z = Mth.floor((double)this.getZ());
            int y = serverLevel.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
            BlockPos blockPos = new BlockPos(x, y, z);
            this.setDragonFight(new EndDragonFight(serverLevel, serverLevel.getServer().getWorldData().worldGenOptions().seed(), new EndDragonFight.Data(true, false, false, false, Optional.of(this.getUUID()), Optional.of(blockPos), Optional.empty()), blockPos));
        }
        super.tickDeath();
    }
}

