/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.projectile;

import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityMortarWitherSkull
extends WitherSkull {
    private static final EntityDataAccessor<Boolean> BULLET = SynchedEntityData.defineId(EntityMortarWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int lifeTime;
    public int explosivePower;
    public int extraDamage;
    public float speedFactor;
    public int titanDamage;

    public EntityMortarWitherSkull(EntityType<? extends EntityMortarWitherSkull> entityType, Level level) {
        super(entityType, level);
    }

    public EntityMortarWitherSkull(Level level, double x, double y, double z, Vec3 movement) {
        this((EntityType<? extends EntityMortarWitherSkull>)((EntityType)TheTitansNeoEntities.MORTAR_WITHER_SKULL.get()), level);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignDirectionalMovement(movement, this.accelerationPower + (double)this.speedFactor);
    }

    public EntityMortarWitherSkull(Level level, LivingEntity owner, Vec3 movement) {
        this(level, owner.getX(), owner.getY(), owner.getZ(), movement);
        this.setOwner((Entity)owner);
        this.setRot(owner.getYRot(), owner.getXRot());
    }

    public boolean isBullet() {
        return (Boolean)this.entityData.get(BULLET);
    }

    public void setBullet(boolean bullet) {
        this.entityData.set(BULLET, (Object)bullet);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BULLET, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBullet(tag.getBoolean("Bullet"));
        this.lifeTime = tag.getInt("LifeTime");
        this.explosivePower = tag.getInt("ExplosivePower");
        this.extraDamage = tag.getInt("ExtraDamage");
        this.speedFactor = tag.getFloat("SpeedFactor");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Bullet", this.isBullet());
        tag.putInt("LifeTime", this.lifeTime);
        tag.putInt("ExplosivePower", this.explosivePower);
        tag.putInt("ExtraDamage", this.extraDamage);
        tag.putFloat("SpeedFactor", this.speedFactor);
    }

    private void assignDirectionalMovement(Vec3 movement, double accelerationPower) {
        this.setDeltaMovement(movement.normalize().scale(accelerationPower));
        this.hasImpulse = true;
    }

    protected void onHit(HitResult result) {
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f) * 0.6f);
        this.playSound((SoundEvent)TheTitansNeoSounds.MORTAR_HIT.get(), 0.5f, 1.0f);
        this.playSound((SoundEvent)TheTitansNeoSounds.MORTAR_HIT.get(), 2.0f, 1.0f);
        HitResult.Type hitResult$type = result.getType();
        if (hitResult$type == HitResult.Type.ENTITY) {
            LivingEntity livingEntity;
            EntityHitResult entityHitResult = (EntityHitResult)result;
            Entity entity = entityHitResult.getEntity();
            if (this.getOwner() instanceof LivingEntity) {
                livingEntity = (LivingEntity)this.getOwner();
                if (entity instanceof EntityTitan) {
                    EntityTitan titan = (EntityTitan)entity;
                    titan.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 0.9f);
                    titan.hurt(this.damageSources().witherSkull((WitherSkull)this, (Entity)livingEntity), this.isBullet() ? 100.0f + (float)this.extraDamage : 500.0f + (float)this.extraDamage * 100.0f);
                    if (this.titanDamage > 0) {
                        titan.setTitanHealth(Math.max(titan.getHealth() - (float)this.titanDamage, 0.0f));
                    }
                } else if (entity.getBbHeight() >= 6.0f) {
                    entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 0.9f);
                    entity.hurt(this.damageSources().witherSkull((WitherSkull)this, (Entity)livingEntity), this.isBullet() ? 100.0f + (float)this.extraDamage : 5000.0f + (float)this.extraDamage * 1000.0f);
                } else {
                    entity.hurt(this.damageSources().witherSkull((WitherSkull)this, (Entity)livingEntity), this.isBullet() ? 10.0f + (float)this.extraDamage : 500.0f + (float)this.extraDamage * 100.0f);
                }
            } else {
                entity.hurt(this.damageSources().magic(), this.isBullet() ? 5.0f : 500.0f);
            }
            if (entity instanceof LivingEntity) {
                int i;
                livingEntity = (LivingEntity)entity;
                int n = i = this.isBullet() ? 10 : 30;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    i = this.isBullet() ? 20 : 60;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    int n2 = i = this.isBullet() ? 40 : 90;
                }
                if (i > 0 && !this.level().isClientSide()) {
                    if (!this.isBullet()) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 40 * i, 3), this.getEffectSource());
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 3), this.getEffectSource());
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1), this.getEffectSource());
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120, 1), this.getEffectSource());
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 20 * i, 1), this.getEffectSource());
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 3), this.getEffectSource());
                        if (livingEntity.getEyeY() - 0.2 < this.getY()) {
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0), this.getEffectSource());
                        }
                    }
                }
            }
            if (!this.level().isClientSide()) {
                if (!this.isBullet()) {
                    this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 14.0f + (float)this.explosivePower, false, Level.ExplosionInteraction.MOB);
                }
                this.discard();
            }
        }
    }

    public void tick() {
        super.tick();
        ++this.lifeTime;
        if (this.lifeTime >= 1000) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.isBullet() ? 2.0f : 4.0f, (1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f) * 0.6f);
            this.playSound((SoundEvent)TheTitansNeoSounds.MORTAR_HIT.get(), 0.5f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.MORTAR_HIT.get(), 2.0f, 1.0f);
            if (!this.level().isClientSide()) {
                if (!this.isBullet()) {
                    this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 14.0f + (float)this.explosivePower, false, Level.ExplosionInteraction.MOB);
                }
                this.discard();
            }
        }
    }
}

