/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.projectile;

import java.util.List;
import net.byAqua3.thetitansneo.entity.projectile.IEntityProjectileTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntitySnowballTitan
extends AbstractHurtingProjectile
implements IEntityProjectileTitan,
ItemSupplier {
    public EntitySnowballTitan(EntityType<? extends EntitySnowballTitan> entityType, Level level) {
        super(entityType, level);
    }

    public EntitySnowballTitan(Level level, LivingEntity shooter) {
        this((EntityType<? extends EntitySnowballTitan>)((EntityType)TheTitansNeoEntities.SNOWBALL_TITAN.get()), level);
        this.setOwner((Entity)shooter);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.SNOWBALL);
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected boolean canHitEntity(Entity entity) {
        return this.getOwner() != null && entity == this.getOwner() ? false : super.canHitEntity(entity);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && this.getOwner() instanceof EntityTitan) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityTitan titan = (EntityTitan)this.getOwner();
            float amount = 60.0f;
            titan.attackEntity(livingEntity, amount);
            if (!this.level().isClientSide()) {
                this.discard();
            }
        }
        super.onHitEntity(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        for (int i = 0; i < 128; ++i) {
            int x = Mth.floor((double)(this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth()));
            int y = Mth.floor((double)this.getY());
            int z = Mth.floor((double)(this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth()));
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockState blockState = this.level().getBlockState(blockPos);
            if (!blockState.isAir() || !(((Biome)this.level().getBiome(blockPos).value()).getBaseTemperature() < 1.3f) || !Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level(), blockPos)) continue;
            this.level().setBlockAndUpdate(blockPos, Blocks.SNOW.defaultBlockState());
        }
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)(this.getOwner() != null ? this.getOwner() : this), this.getX(), this.getY(), this.getZ(), 1.0f, false, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox());
        for (Entity entity : entities) {
            if (!this.canHitEntity(entity)) continue;
            this.onHitEntity(new EntityHitResult(entity));
        }
    }
}

