/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.blazetitan.EntityAIBlazeTitanAttack;
import net.byAqua3.thetitansneo.entity.minion.EntityBlazeTitanMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityBlazeTitan
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(EntityBlazeTitan.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public final EntityTitanPart[] parts;
    public final EntityTitanPart head;
    public EntityTitanPart[] rods = new EntityTitanPart[12];
    private float heightOffset = 32.0f;
    private int heightOffsetUpdateTime;

    public EntityBlazeTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.shouldParticlesBeUpward = true;
        this.head = new EntityTitanPart(this, "head", 8.0f, 8.0f);
        this.rods[0] = new EntityTitanPart(this, "rod1", 2.0f, 8.0f);
        this.rods[1] = new EntityTitanPart(this, "rod2", 2.0f, 8.0f);
        this.rods[2] = new EntityTitanPart(this, "rod3", 2.0f, 8.0f);
        this.rods[3] = new EntityTitanPart(this, "rod4", 2.0f, 8.0f);
        this.rods[4] = new EntityTitanPart(this, "rod5", 2.0f, 8.0f);
        this.rods[5] = new EntityTitanPart(this, "rod6", 2.0f, 8.0f);
        this.rods[6] = new EntityTitanPart(this, "rod7", 2.0f, 8.0f);
        this.rods[7] = new EntityTitanPart(this, "rod8", 2.0f, 8.0f);
        this.rods[8] = new EntityTitanPart(this, "rod9", 2.0f, 8.0f);
        this.rods[9] = new EntityTitanPart(this, "rod10", 2.0f, 8.0f);
        this.rods[10] = new EntityTitanPart(this, "rod11", 2.0f, 8.0f);
        this.rods[11] = new EntityTitanPart(this, "rod12", 2.0f, 8.0f);
        this.parts = new EntityTitanPart[]{this.head, this.rods[0], this.rods[1], this.rods[2], this.rods[3], this.rods[4], this.rods[5], this.rods[6], this.rods[7], this.rods[8], this.rods[9], this.rods[10], this.rods[11]};
        if (!level.isClientSide()) {
            for (EntityTitanPart part : this.parts) {
                level.addFreshEntity((Entity)part);
            }
        }
    }

    public EntityBlazeTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.BLAZE_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 50000.0).add(Attributes.ATTACK_DAMAGE, 600.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/blaze_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        switch (this.getRandom().nextInt(2)) {
            case 0: {
                return ChatFormatting.RED.getColor();
            }
            case 1: {
                return ChatFormatting.GOLD.getColor();
            }
        }
        return 16167425;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 34;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 10;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new EntityAIBlazeTitanAttack(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.BlazeTitanSorter));
    }

    public boolean isCharged() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setCharged(boolean charged) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return groupData;
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50000.0 + (double)this.getExtraPower() * 4000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(600.0 + (double)this.getExtraPower() * 40.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25000.0 + (double)this.getExtraPower() * 2000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(300.0 + (double)this.getExtraPower() * 20.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        ArrayList parts = Lists.newArrayList((Object[])this.parts);
        return !parts.contains(entity) && !(entity instanceof EntityBlazeTitanMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public int getRegenTime() {
        return 10;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getTitanHealth() <= this.getMaxHealth() / 4.0f;
    }

    @Override
    public SimpleParticleType getParticles() {
        if (this.getRandom().nextInt(this.isInWaterOrRain() ? 2 : 6) == 0) {
            return ParticleTypes.POOF;
        }
        return ParticleTypes.LARGE_SMOKE;
    }

    @Override
    public int getParticleCount() {
        return 40;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.blazeTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.blazeTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.blazeTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.blazeTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.blazeTitanTemplarSpawnCap.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    public boolean isOnFire() {
        return this.isCharged() && this.invulnerableTime < 20;
    }

    @Override
    public float getSpeed() {
        return 0.5f + (float)this.getExtraPower() * 0.001f;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_BLAZE_BREATHE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_BLAZE_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_BLAZE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        this.hurt(damageSource, amount);
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isArmored()) {
            amount /= 2.0f;
        }
        if (damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE)) {
            this.heal(amount);
            return false;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getInvulTime() < 0) {
            LivingEntity entity;
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 300;
                this.heightOffset = 40.0f + (float)this.getRandom().nextGaussian() * 16.0f;
            }
            if ((entity = this.getTarget()) != null && entity.getY() + (double)entity.getEyeHeight() > this.getY() + (double)this.getEyeHeight() + (double)this.heightOffset) {
                this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + (0.9 - this.getDeltaMovement().y) * 0.9, this.getDeltaMovement().z);
                this.hasImpulse = true;
            }
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < 32; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 18000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.BLAZE_ROD), 144);
        drops.put(new ItemStack((ItemLike)Items.BLAZE_POWDER), 96);
        drops.put(new ItemStack((ItemLike)Items.COAL), 64);
        drops.put(new ItemStack((ItemLike)Items.GOLD_INGOT), 24);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 16);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 16);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 1);
        rateDrops.put(new ItemStack((ItemLike)Items.BLAZE_ROD), 144);
        rateDrops.put(new ItemStack((ItemLike)Items.BLAZE_POWDER), 96);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 64);
        rateDrops.put(new ItemStack((ItemLike)Items.GOLD_INGOT), 64);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 24);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 24);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 8);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        if (this.getRandom().nextInt(5) == 0) {
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), new ItemStack((ItemLike)Blocks.BEDROCK), this.getRandom().nextInt(2) + 1);
            itemTitan.setPickUpDelay(40);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)itemTitan);
            }
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        if (this.deathTicks > 200) {
            this.setInvulTime(this.getInvulTime() + 10);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.hasImpulse = true;
        this.setOnGround(false);
        if (this.tickCount > 5) {
            int i;
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = (float)this.tickCount * (float)Math.PI * 0.008f + 0.15f;
            for (i = 0; i < 4; ++i) {
                this.rods[i].setPos(this.getX() - (double)(Mth.cos((float)(f1 + f)) * 10.0f), this.getY() - (double)(4.0f + Mth.cos((float)((float)(i * 2 + this.tickCount) * 0.03f))), this.getZ() - (double)(Mth.sin((float)(f1 + f)) * 10.0f));
                f1 += 1.0f;
            }
            f1 = 0.7853982f + (float)this.tickCount * (float)Math.PI * -0.005f - 1.4f;
            for (i = 4; i < 8; ++i) {
                this.rods[i].setPos(this.getX() - (double)(Mth.cos((float)(f1 + f)) * 7.0f), this.getY() - (double)(10.0f + Mth.cos((float)((float)(i * 3 + this.tickCount) * 0.05f))), this.getZ() - (double)(Mth.sin((float)(f1 + f)) * 7.0f));
                f1 += 1.0f;
            }
            f1 = 0.47123894f + (float)this.tickCount * (float)Math.PI * 0.003f - 0.8f;
            for (i = 8; i < 12; ++i) {
                this.rods[i].setPos(this.getX() - (double)(Mth.cos((float)(f1 + f)) * 4.0f), this.getY() - (double)(17.0f + Mth.cos((float)(((float)i * 1.5f + (float)this.tickCount) * 0.02f))), this.getZ() - (double)(Mth.sin((float)(f1 + f)) * 4.0f));
                f1 += 1.0f;
            }
            this.head.setPos(this.getX(), this.getY(), this.getZ());
            for (int u = 0; u < this.getParticleCount(); ++u) {
                for (int w = 0; w < this.rods.length; ++w) {
                    this.level().addParticle((ParticleOptions)this.getParticles(), this.rods[w].getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.rods[w].getBbWidth(), this.rods[w].getY() + this.getRandom().nextDouble() * (double)this.rods[w].getBbHeight(), this.rods[w].getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.rods[w].getBbWidth(), 0.0, 0.0, 0.0);
                }
            }
            for (EntityTitanPart part : this.parts) {
                if (this.isAlive()) {
                    this.collideWithEntities(part, this.level().getEntities((Entity)this, part.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                }
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getTarget() != null) {
            this.lookAt((Entity)this.getTarget(), 5.0f, 180.0f);
            this.getMoveControl().setWantedPosition(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 20.0);
            if (this.getY() < this.getTarget().getY() + 20.0) {
                if (this.getDeltaMovement().y < 0.0) {
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                }
                this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + (0.8 - this.getDeltaMovement().y) * 0.8, this.getDeltaMovement().z);
            }
        } else if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.25, this.getDeltaMovement().z);
        }
    }
}

