/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.EntityWitherTurret;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanAttack1;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanAttack2;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanAttack3;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanAttack4;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanCreation;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanDeath;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanSpit;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanStunned;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.AnimationCreeperTitanThunderClap;
import net.byAqua3.thetitansneo.entity.ai.creepertitan.EntityAICreeperTitanSwell;
import net.byAqua3.thetitansneo.entity.minion.EntityCreeperTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.projectile.EntityGunpowderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMobEffects;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityCreeperTitan
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(EntityCreeperTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.defineId(EntityCreeperTitan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final EntityTitanPart[] parts;
    public final EntityTitanPart head = new EntityTitanPart(this, "head", 8.0f, 8.0f);
    public final EntityTitanPart body = new EntityTitanPart(this, "body", 7.0f, 12.0f);
    public final EntityTitanPart leg1 = new EntityTitanPart(this, "leg1", 4.5f, 8.0f);
    public final EntityTitanPart leg2 = new EntityTitanPart(this, "leg2", 4.5f, 8.0f);
    public final EntityTitanPart leg3 = new EntityTitanPart(this, "leg3", 4.5f, 8.0f);
    public final EntityTitanPart leg4 = new EntityTitanPart(this, "leg4", 4.5f, 8.0f);
    public int damageToLegs;
    public boolean isStunned;
    private int timeSinceIgnited;
    private int fuseTime = 200;

    public EntityCreeperTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.parts = new EntityTitanPart[]{this.head, this.body, this.leg1, this.leg2, this.leg3, this.leg4};
        if (!level.isClientSide()) {
            for (EntityTitanPart part : this.parts) {
                level.addFreshEntity((Entity)part);
            }
        }
    }

    public EntityCreeperTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.CREEPER_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 50000.0).add(Attributes.ATTACK_DAMAGE, 540.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        if (this.getCharged()) {
            return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/charged_creeper_titan.png");
        }
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/creeper_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        if (this.getCharged()) {
            switch (this.getRandom().nextInt(5)) {
                case 0: {
                    return ChatFormatting.DARK_GREEN.getColor();
                }
                case 1: {
                    return ChatFormatting.DARK_RED.getColor();
                }
                case 2: {
                    return ChatFormatting.GOLD.getColor();
                }
                case 3: {
                    return ChatFormatting.GREEN.getColor();
                }
                case 4: {
                    return ChatFormatting.YELLOW.getColor();
                }
            }
        }
        return 894731;
    }

    @Override
    public int getBossBarWidth() {
        return 215;
    }

    @Override
    public int getBossBarHeight() {
        return 33;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 16;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new EntityAICreeperTitanSwell(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanCreation(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanAttack4(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanSpit(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanStunned(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationCreeperTitanThunderClap(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.CreeperTitanSorter));
    }

    public int getCreeperState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void setCreeperState(int creeperState) {
        this.entityData.set(STATE, (Object)creeperState);
    }

    public boolean getCharged() {
        return (Boolean)this.entityData.get(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.entityData.set(CHARGED, (Object)charged);
        this.refreshAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(CHARGED, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCreeperState(tag.getInt("CreeperState"));
        this.setCharged(tag.getBoolean("IsCharged"));
        this.damageToLegs = tag.getInt("DamageToLegs");
        this.isStunned = tag.getBoolean("IsStunned");
        this.fuseTime = tag.getInt("FuseTime");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("CreeperState", this.getCreeperState());
        tag.putBoolean("IsCharged", this.getCharged());
        tag.putInt("DamageToLegs", this.damageToLegs);
        tag.putBoolean("IsStunned", this.isStunned);
        tag.putInt("FuseTime", this.fuseTime);
    }

    public void doLightningAttackToEntity(LivingEntity entity) {
        float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE) / 3.0f;
        if (this.getCharged()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.getRandom().nextFloat() * 0.2f, true);
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.getRandom().nextFloat() * 0.2f, true);
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), 8.0f, false, Level.ExplosionInteraction.MOB);
                this.level().explode((Entity)this, this.getX(), this.head.getY() + 4.0, this.getZ(), 4.0f, false, Level.ExplosionInteraction.MOB);
            }
            int knockbackAmount = this.getKnockbackAmount();
            if (entity != this) {
                entity.hurt(this.damageSources().lightningBolt(), 50.0f);
                this.attackEntity(entity, amount);
                entity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            }
            EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 1.0f);
            EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 1.0f);
            colorLightningBolt1.setPos(this.getX(), this.head.getY() + 4.0, this.getZ());
            colorLightningBolt2.setPos(entity.getX(), entity.getY(), entity.getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt1);
                this.level().addFreshEntity((Entity)colorLightningBolt2);
            }
        } else {
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), 4.0f, false, Level.ExplosionInteraction.MOB);
                this.level().explode((Entity)this, this.getX(), this.head.getY() + 4.0, this.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
            }
            int knockbackAmount = this.getKnockbackAmount();
            if (entity != this) {
                entity.hurt(this.damageSources().lightningBolt(), 50.0f);
                this.attackEntity(entity, amount);
                entity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            }
            EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 0.25f);
            EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 0.25f);
            colorLightningBolt1.setPos(this.getX(), this.head.getY() + 4.0, this.getZ());
            colorLightningBolt2.setPos(entity.getX(), entity.getY(), entity.getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt1);
                this.level().addFreshEntity((Entity)colorLightningBolt2);
            }
        }
    }

    private void explode() {
        LivingEntity livingEntity;
        for (int i = 0; i < 1000; ++i) {
            float f = (this.getRandom().nextFloat() - 0.5f) * 16.0f;
            float f1 = (this.getRandom().nextFloat() - 0.5f) * 48.0f;
            float f2 = (this.getRandom().nextFloat() - 0.5f) * 16.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, this.getRandom().nextDouble() - 0.5, 0.0, this.getRandom().nextDouble() - 0.5);
        }
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_EXPLOSION.get(), Float.MAX_VALUE, 1.0f);
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_LAND.get(), 10000.0f, 1.0f);
        this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
        double d1 = (this.getCharged() ? (Integer)TheTitansNeoConfigs.chargedCreeperTitanExplodeRange.get() : (Integer)TheTitansNeoConfigs.creeperTitanExplodeRange.get()).intValue();
        double d2 = d1 * 8.0;
        if (((Boolean)TheTitansNeoConfigs.creeperTitanExplodeAsync.get()).booleanValue()) {
            this.destroyBlocksInAABBGriefingBypassAsync(this.getBoundingBox().inflate(d1, d1, d1));
        } else {
            this.destroyBlocksInAABBGriefingBypass(this.getBoundingBox().inflate(d1, d1, d1));
        }
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(d1, d1, d1));
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof EntityCreeperTitan) {
                EntityCreeperTitan creeperTitan = (EntityCreeperTitan)livingEntity;
                creeperTitan.heal(this.getCharged() ? 10000.0f : 5000.0f);
                creeperTitan.setCharged(true);
                continue;
            }
            this.attackEntity(livingEntity, this.getCharged() ? 10000.0f : 5000.0f);
        }
        entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(d2, d2, d2));
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(TheTitansNeoMobEffects.RADIATION, 30000, 1));
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setWaiting(true);
        return groupData;
    }

    public Component getName() {
        if (this.getCharged()) {
            return Component.translatable((String)"entity.thetitansneo.charged_creeper_titan");
        }
        return Component.translatable((String)"entity.thetitansneo.creeper_titan");
    }

    @Override
    protected void refreshAttributes() {
        if (this.getCharged()) {
            if (this.level().getDifficulty() == Difficulty.HARD) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(60000.0 + (double)this.getExtraPower() * 2500.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(1620.0 + (double)this.getExtraPower() * 270.0);
            } else {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(30000.0 + (double)this.getExtraPower() * 1250.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(540.0 + (double)this.getExtraPower() * 90.0);
            }
        } else if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50000.0 + (double)this.getExtraPower() * 2500.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(540.0 + (double)this.getExtraPower() * 90.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25000.0 + (double)this.getExtraPower() * 1250.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(270.5 + (double)this.getExtraPower() * 45.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        ArrayList parts = Lists.newArrayList((Object[])this.parts);
        return !parts.contains(entity) && !(entity instanceof EntityCreeperTitanMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + 600.0;
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.creeperTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.creeperTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.creeperTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.creeperTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.creeperTitanTemplarSpawnCap.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    @Override
    public int getThreashHold() {
        return this.fuseTime;
    }

    @Override
    public float getSpeed() {
        return this.getCharged() ? 0.35f + (float)this.getExtraPower() * 0.001f : 0.3f + (float)this.getExtraPower() * 0.001f;
    }

    protected SoundEvent getAmbientSound() {
        if (!this.getWaiting() && this.getAnimationID() != 13 && !this.isStunned) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_LIVING.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        for (int i = 0; i < 2; ++i) {
            this.shakeNearbyPlayerCameras(4000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.1f);
        }
        if (!this.getWaiting() && this.getAnimationID() != 13) {
            if (this.footID == 0) {
                this.destroyBlocksInAABB(this.leg1.getBoundingBox().move(0.0, -1.0, 0.0));
                this.destroyBlocksInAABB(this.leg3.getBoundingBox().move(0.0, -1.0, 0.0));
                ++this.footID;
            } else {
                this.destroyBlocksInAABB(this.leg2.getBoundingBox().move(0.0, -1.0, 0.0));
                this.destroyBlocksInAABB(this.leg4.getBoundingBox().move(0.0, -1.0, 0.0));
                this.footID = 0;
            }
        }
    }

    public void thunderHit(ServerLevel level, LightningBolt lightningBolt) {
        if (this.getRandom().nextInt(1000) == 0) {
            this.setCharged(true);
        }
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        if (damageSource == this.damageSources().lightningBolt() || damageSource.getEntity() instanceof EntityCreeperTitan || damageSource.is(DamageTypes.EXPLOSION) && !(damageSource.getEntity() instanceof EntityWitherTurret)) {
            this.heal(amount);
            return false;
        }
        if (this.hurt(damageSource, amount) && damageSource.getEntity() != null && damageSource.getEntity() instanceof Player && this.damageToLegs < 8 && !this.isStunned && (entityTitanPart == this.leg1 || entityTitanPart == this.leg2 || entityTitanPart == this.leg3 || entityTitanPart == this.leg4)) {
            ++this.damageToLegs;
            this.hurt(damageSource, 100.0f);
            this.setTarget((LivingEntity)damageSource.getEntity());
            if (this.damageToLegs >= 8) {
                this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
                this.isStunned = true;
                this.damageToLegs = 0;
            }
        }
        return true;
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        this.setOnGround(true);
        this.hasImpulse = false;
        if (fallDistance <= 0.0f) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.getEffect(MobEffects.JUMP);
        float f1 = mobEffectInstance != null ? (float)(mobEffectInstance.getAmplifier() + 1) : 0.0f;
        int i = Mth.ceil((float)(fallDistance - 24.0f - f1));
        if (i > 0) {
            this.shakeNearbyPlayerCameras(400000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_LAND.get(), 10000.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 10.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 10.0f, 1.0f);
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.getBoundingBox().inflate(24.0, 4.0, 24.0)));
            this.destroyBlocksInAABBTopless(this.getBoundingBox().inflate(24.0, 1.0, 24.0));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(48.0, 4.0, 48.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity) || entity instanceof EntityTitan) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                float smash = 50.0f - this.distanceTo((Entity)livingEntity);
                if (smash <= 1.0f) {
                    smash = 1.0f;
                }
                this.attackEntity(livingEntity, smash);
                double d0 = this.getBoundingBox().minX + this.getBoundingBox().maxX;
                double d1 = this.getBoundingBox().minZ + this.getBoundingBox().maxZ;
                double d2 = entity.getX() - d0;
                double d3 = entity.getZ() - d1;
                double d4 = d2 * d2 + d3 * d3;
                entity.push(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
            }
        }
        return true;
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < (this.getCharged() ? 60 : 16); ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 16000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.GUNPOWDER), 256);
        drops.put(new ItemStack((ItemLike)Blocks.TNT), 64);
        drops.put(new ItemStack((ItemLike)Items.COAL), 32);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        drops.put(new ItemStack((ItemLike)Items.GUNPOWDER), 256);
        drops.put(new ItemStack((ItemLike)Blocks.TNT), 64);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 4);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        if (this.getRandom().nextInt(10) == 0) {
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), new ItemStack((ItemLike)Blocks.BEDROCK), 1);
            itemTitan.setPickUpDelay(40);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)itemTitan);
            }
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isStunned = false;
        if (this.deathTicks < 300) {
            this.timeSinceIgnited = 0;
        }
        if (this.deathTicks >= 300) {
            if (this.timeSinceIgnited == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_WARNING.get(), Float.MAX_VALUE, 1.0f);
            }
            ++this.timeSinceIgnited;
            this.setAnimationTick(this.getAnimationTick() - 1);
            this.setCreeperState(1);
            float f = (this.random.nextFloat() - 0.5f) * 16.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 12.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 16.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.timeSinceIgnited >= this.getThreashHold()) {
            this.deathTicks = 200;
            this.explode();
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL && entity instanceof EntityCreeperTitanMinion) {
            EntityCreeperTitanMinion creeperTitanMinion = (EntityCreeperTitanMinion)entity;
            creeperTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
            if (this.getCharged()) {
                LightningBolt lightningBolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                lightningBolt.setPos(creeperTitanMinion.getX(), creeperTitanMinion.getY(), creeperTitanMinion.getZ());
                this.level().addFreshEntity((Entity)lightningBolt);
            }
        }
    }

    public void animationTick() {
        float amount;
        int knockbackAmount;
        float amount2;
        if (this.getAnimationID() == 13) {
            this.addDayTime(14000L, 50L);
            if (this.getAnimationTick() == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 1000.0f, 1.0f);
            }
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_AWAKEN.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 130) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 160) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_BEGINMOVE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 260 || this.getAnimationTick() == 261 || this.getAnimationTick() == 390 || this.getAnimationTick() == 410) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), this.getSoundVolume(), 1.0f);
            }
        }
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(48.0, 48.0, 48.0)));
            for (int i = 0; i < 4; ++i) {
                this.attackEntity(this.getTarget(), amount2);
            }
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity, amount2);
                }
                livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            }
        }
        if (this.getAnimationID() == 2 && (this.getAnimationTick() == 60 || this.getAnimationTick() == 104)) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 8.0, 32.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount2);
                livingEntity.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
            }
        }
        if (this.getAnimationID() == 3 && this.getAnimationTick() == 90) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            double d8 = 12.0;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move(dx, 0.0, dz));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity((LivingEntity)entity, amount * 2.0f);
                }
                livingEntity.push(0.0, (double)(1.0f + this.getRandom().nextFloat() + this.getRandom().nextFloat()), 0.0);
            }
        }
        if (this.getAnimationID() == 4 && this.getAnimationTick() == 32) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
            if (this.getTarget() != null) {
                this.doLightningAttackToEntity(this.getTarget());
            }
            float d0 = 16.0f;
            float f3 = this.yBodyRot * (float)Math.PI / 180.0f;
            float f11 = Mth.sin((float)f3);
            float f4 = Mth.cos((float)f3);
            float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount2 = this.getKnockbackAmount();
            this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(48.0, 12.0, 48.0).move((double)(-(f11 * d0)), -8.0, (double)(f4 * d0))));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 8.0, 32.0).move((double)(-(f11 * d0)), -4.0, (double)(f4 * d0)));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity, amount3 * 2.0f);
                }
                livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            }
        }
        if (this.getAnimationID() == 5 && this.getAnimationTick() == 30 && this.getTarget() != null) {
            float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(4.0, 2.0, 4.0)));
            this.attackEntity(this.getTarget(), amount4);
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount4);
                livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            }
        }
        if (this.getAnimationID() == 6 && this.getAnimationTick() <= 50 && this.getAnimationTick() >= 20 && this.getTarget() != null) {
            int num = this.getCharged() ? 50 + this.getRandom().nextInt(50) : 10 + this.getRandom().nextInt(10);
            block13: for (int i = 0; i < num; ++i) {
                switch (this.getRandom().nextInt(3)) {
                    case 0: {
                        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_GHAST_FIREBALL.get(), 100.0f, 1.25f);
                        Vec3 vec3 = this.getViewVector(1.0f);
                        double d5 = this.getTarget().getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f) - this.head.getX() + vec3.x * 6.0;
                        double d6 = this.getTarget().getY() - 16.0 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f) - this.head.getY() + 1.0;
                        double d7 = this.getTarget().getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f) - this.head.getZ() + vec3.z * 6.0;
                        EntityGunpowderTitan gunpowderTitan = new EntityGunpowderTitan(this.level(), (LivingEntity)this);
                        gunpowderTitan.setPos(this.head.getX() + vec3.x * 6.0, this.head.getY() + 1.0, this.head.getZ() + vec3.z * 6.0);
                        gunpowderTitan.shoot(d5, d6, d7, 1.0f, 1.0f);
                        if (this.level().isClientSide()) continue block13;
                        this.level().addFreshEntity((Entity)gunpowderTitan);
                        continue block13;
                    }
                    case 1: {
                        this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.0f);
                        PrimedTnt tnt = new PrimedTnt(this.level(), this.getTarget().getX() + 0.5 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f), this.getTarget().getY() + 32.0 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f), this.getTarget().getZ() + 0.5 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f), (LivingEntity)this);
                        tnt.setFuse(100 + this.getRandom().nextInt(60));
                        if (this.level().isClientSide()) continue block13;
                        this.level().addFreshEntity((Entity)tnt);
                    }
                }
            }
        }
        if (this.getAnimationID() == 7) {
            List entities;
            if (this.getAnimationTick() == 100) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.1f);
                if (this.getTarget() != null) {
                    this.doLightningAttackToEntity(this.getTarget());
                }
                double d8 = 12.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount3 = this.getKnockbackAmount();
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + 10.0, this.getZ() + dz, 3.0f, false, Level.ExplosionInteraction.MOB);
                }
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(16.0, 2.0, 16.0)));
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount3 * 0.2, (double)knockbackAmount3 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount3 * 0.2);
                }
            }
            if (this.getAnimationTick() == 150) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
                double d8 = 12.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount4 = this.getKnockbackAmount();
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    for (int i = 0; i < 2; ++i) {
                        this.attackEntity(livingEntity, amount * 2.0f);
                    }
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount4 * 0.2, (double)knockbackAmount4 * 0.2 + 1.0 + this.getRandom().nextDouble() + this.getRandom().nextDouble(), Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount4 * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_STUN.get(), this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.getAnimationTick() == 120) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 8.0f, 0.9f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 10.0f, 1.0f);
            }
            this.isStunned = this.getAnimationTick() <= 500;
            this.setTarget(null);
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 50 || this.getAnimationTick() == 70 || this.getAnimationTick() == 100) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
            }
            if (this.getAnimationTick() == 120) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            }
            if (this.getAnimationTick() == 160) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getCharged()) {
            boolean flag = true;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(20000.0, 20000.0, 20000.0));
            for (Entity entity : entities) {
                if (entity == null || !entity.isAlive() || !(entity instanceof EntityEnderColossus)) continue;
                flag = false;
            }
            if (flag && !this.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                serverLevel.setWeatherParameters(0, ServerLevel.THUNDER_DURATION.sample(serverLevel.getRandom()), true, true);
            }
            if (this.getRandom().nextInt(20) == 0) {
                EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 1.0f);
                colorLightningBolt.setPos(this.getX(), this.head.getY() + 4.0, this.getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
            }
            if (this.getRandom().nextInt(40) == 0) {
                for (int l = 0; l < 50; ++l) {
                    int i = Mth.floor((double)this.getX());
                    int j = Mth.floor((double)this.getY());
                    int k = Mth.floor((double)this.getZ());
                    int i1 = i + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-2, (int)2);
                    int j1 = j + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-2, (int)2);
                    int k1 = k + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-2, (int)2);
                    BlockPos blockPos = new BlockPos(i1, j1 - 1, k1);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    if (blockState.isAir() || !blockState.isSolid()) continue;
                    EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 0.0f, 0.5f, 1.0f);
                    colorLightningBolt.setPos(i1, j1, k1);
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
            }
        }
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                float f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                float f5 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getWaiting()) {
            AnimationUtils.sendPacket(this, 13);
            Player player = this.level().getNearestPlayer((Entity)this, 24.0);
            if (player != null) {
                this.setWaiting(false);
                this.lookAt((Entity)player, 180.0f, 0.0f);
            }
        } else if (this.getAnimationID() == 13) {
            this.setTitanDeltaMovement(0.0, 0.0, 0.0);
            this.setOnGround(true);
        }
        if (this.tickCount > 5) {
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            float offset = this.getAnimationID() == 3 && this.getAnimationTick() > 30 && this.getAnimationTick() < 70 || this.getAnimationID() == 7 && this.getAnimationTick() > 30 && this.getAnimationTick() < 130 ? 6.0f : 0.0f;
            this.head.setPos(this.getX(), this.getY() + (this.getAnimationID() == 8 ? 12.0 : 18.0), this.getZ());
            this.body.setPos(this.getX(), this.getY() + (this.getAnimationID() == 8 ? 0.0 : 6.0), this.getZ());
            this.leg1.setPos(this.getX() - (double)(f1 * 5.5f) + (double)(f2 * 5.5f), this.getY() + (double)offset, this.getZ() + (double)(f2 * 5.5f) + (double)(f1 * 5.5f));
            this.leg2.setPos(this.getX() - (double)(f1 * 5.5f) - (double)(f2 * 5.5f), this.getY() + (double)offset, this.getZ() + (double)(f2 * 5.5f) - (double)(f1 * 5.5f));
            this.leg3.setPos(this.getX() + (double)(f1 * 5.5f) + (double)(f2 * 5.5f), this.getY(), this.getZ() - (double)(f2 * 5.5f) + (double)(f1 * 5.5f));
            this.leg4.setPos(this.getX() + (double)(f1 * 5.5f) - (double)(f2 * 5.5f), this.getY(), this.getZ() - (double)(f2 * 5.5f) - (double)(f1 * 5.5f));
            for (EntityTitanPart part : this.parts) {
                if (this.isAlive() && !this.isStunned) {
                    this.collideWithEntities(part, this.level().getEntities((Entity)this, part.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                }
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 1);
                } else {
                    switch (this.getRandom().nextInt(4)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 2);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 5);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 4);
                        }
                    }
                }
            } else if (this.getRandom().nextInt(100) == 0) {
                switch (this.getRandom().nextInt(2)) {
                    case 0: {
                        AnimationUtils.sendPacket(this, 7);
                        break;
                    }
                    case 1: {
                        AnimationUtils.sendPacket(this, 6);
                    }
                }
            }
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        if (this.getTarget() != null && !(this.getTarget() instanceof EntityTitan) && this.getRandom().nextInt(this.getCharged() ? 30 : 150) == 0 && !this.isStunned) {
            this.doLightningAttackToEntity((LivingEntity)this);
            this.doLightningAttackToEntity(this.getTarget());
        }
        if (this.getAnimationID() == 0 && this.getRandom().nextInt(120) == 0 && this.getTarget() != null && this.onGround()) {
            int rate;
            if (this.distanceToSqr((Entity)this.getTarget()) > 300.0) {
                int rate2;
                int n = rate2 = this.getCharged() ? 50 : 600;
                if (this.getRandom().nextInt(rate2) == 0) {
                    this.jumpFromGround();
                    this.playSound(this.getHurtSound(null), this.getSoundVolume(), this.getVoicePitch());
                }
            }
            int n = rate = this.getCharged() ? 50 : 600;
            if (this.getRandom().nextInt(rate) == 0) {
                if (this.getRandom().nextInt(4) == 0) {
                    this.jumpFromGround();
                    double d01 = this.getTarget().getX() - this.getX();
                    double d11 = this.getTarget().getZ() - this.getZ();
                    float f21 = (float)Math.sqrt(d01 * d01 + d11 * d11);
                    double hor = f21 / 16.0f;
                    double ver = 2.0;
                    this.setTitanDeltaMovement(d01 / (double)f21 * hor * hor + this.getDeltaMovement().x * hor, ver, d11 / (double)f21 * hor * hor + this.getDeltaMovement().z * hor);
                } else {
                    this.jumpAtEntity(this.getTarget());
                }
            }
        }
        this.meleeTitan = true;
        this.animationTick();
    }
}

