/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusAttack1;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusAttack2;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusAttack3;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusChainLightning;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusDeath;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusDragonLightningBall;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusLightningAttack;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusLightningBall;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusMeteorRain;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusScream;
import net.byAqua3.thetitansneo.entity.ai.endercolossus.AnimationEnderColossusStun;
import net.byAqua3.thetitansneo.entity.minion.EntityDragonMinion;
import net.byAqua3.thetitansneo.entity.minion.EntityEnderColossusMinion;
import net.byAqua3.thetitansneo.entity.projectile.EntityEnderPearlTitan;
import net.byAqua3.thetitansneo.entity.projectile.EntityLightningBall;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossusCrystal;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDimensions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.byAqua3.thetitansneo.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityEnderColossus
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Integer> EYE_LASER_TIME = SynchedEntityData.defineId(EntityEnderColossus.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CAN_CALL_BACK_UP = SynchedEntityData.defineId(EntityEnderColossus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SCREAMING = SynchedEntityData.defineId(EntityEnderColossus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final EntityTitanPart[] parts;
    public EntityTitanPart head = new EntityTitanPart(this, "head", 12.0f, 12.0f);
    public EntityTitanPart body = new EntityTitanPart(this, "body", 10.0f, 18.0f);
    public EntityTitanPart leftEye = new EntityTitanPart(this, "lefteye", 3.0f, 2.0f);
    public EntityTitanPart rightEye = new EntityTitanPart(this, "righteye", 3.0f, 2.0f);
    public EntityTitanPart leftArm = new EntityTitanPart(this, "leftarm", 4.0f, 4.0f);
    public EntityTitanPart rightArm = new EntityTitanPart(this, "rightarm", 4.0f, 4.0f);
    public EntityTitanPart leftLeg = new EntityTitanPart(this, "leftleg", 4.0f, 42.0f);
    public EntityTitanPart rightLeg = new EntityTitanPart(this, "rightleg", 4.0f, 42.0f);
    private int roarcooldownTimer;
    public int numOfCrystals;
    public int maxNumOfCrystals = 20;
    public int destroyedCrystals;
    public boolean healCrystals;
    public boolean isStunned;

    public EntityEnderColossus(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.parts = new EntityTitanPart[]{this.head, this.body, this.leftEye, this.rightEye, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg};
        if (!level.isClientSide()) {
            for (EntityTitanPart part : this.parts) {
                level.addFreshEntity((Entity)part);
            }
        }
    }

    public EntityEnderColossus(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.ENDER_COLOSSUS.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 100000.0).add(Attributes.ATTACK_DAMAGE, 5000.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/ender_colossus.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 13369594;
    }

    @Override
    public int getBossBarWidth() {
        return 193;
    }

    @Override
    public int getBossBarHeight() {
        return 23;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusDeath(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusAntiTitanAttack(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusAttack1(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusAttack2(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusAttack3(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusChainLightning(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusDragonLightningBall(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusLightningAttack(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusLightningBall(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusMeteorRain(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusScream(this));
        this.goalSelector.addGoal(0, (Goal)new AnimationEnderColossusStun(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.EnderColossusSorter));
    }

    public int getEyeLaserTime() {
        return (Integer)this.entityData.get(EYE_LASER_TIME);
    }

    public void setEyeLaserTime(int eyeLaserTime) {
        this.entityData.set(EYE_LASER_TIME, (Object)eyeLaserTime);
    }

    public int getRoarCooldownTimer() {
        return this.roarcooldownTimer;
    }

    public void setRoarCooldownTimer(int roarcooldownTimer) {
        this.roarcooldownTimer = roarcooldownTimer;
    }

    public boolean getCanCallBackUp() {
        return (Boolean)this.entityData.get(CAN_CALL_BACK_UP);
    }

    public void setCanCallBackUp(boolean canCallBackUp) {
        this.entityData.set(CAN_CALL_BACK_UP, (Object)canCallBackUp);
    }

    public boolean isScreaming() {
        return (Boolean)this.entityData.get(SCREAMING);
    }

    public void setScreaming(boolean screaming) {
        if (screaming) {
            this.playSound(this.getRoarSound(), this.getSoundVolume(), 1.0f);
        }
        if (!this.level().isClientSide()) {
            this.entityData.set(SCREAMING, (Object)screaming);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EYE_LASER_TIME, (Object)0);
        builder.define(CAN_CALL_BACK_UP, (Object)false);
        builder.define(SCREAMING, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setEyeLaserTime(tag.getInt("EyeLaserTime"));
        this.setRoarCooldownTimer(tag.getInt("RoarCooldownTimer"));
        this.setCanCallBackUp(tag.getBoolean("CanCallBackUp"));
        this.setScreaming(tag.getBoolean("Screaming"));
        this.destroyedCrystals = tag.getInt("DestroyedCrystals");
        this.healCrystals = tag.getBoolean("HealCrystals");
        this.isStunned = tag.getBoolean("IsStunned");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("EyeLaserTime", this.getEyeLaserTime());
        tag.putInt("RoarCooldownTimer", this.getRoarCooldownTimer());
        tag.putBoolean("CanCallBackUp", this.getCanCallBackUp());
        tag.putBoolean("Screaming", this.isScreaming());
        tag.putInt("DestroyedCrystals", this.destroyedCrystals);
        tag.putBoolean("HealCrystals", this.healCrystals);
        tag.putBoolean("IsStunned", this.isStunned);
    }

    protected boolean isLookingAtMe(Player player, EntityTitanPart entityTitanPart) {
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(entityTitanPart.getX() + this.getRandom().nextDouble() * (double)entityTitanPart.getBbWidth() - (double)entityTitanPart.getBbWidth() * 0.5 - player.getX(), entityTitanPart.getBoundingBox().minY + this.getRandom().nextDouble() * (double)entityTitanPart.getBbHeight() - player.getY() + (double)player.getEyeHeight(), entityTitanPart.getZ() + this.getRandom().nextDouble() * (double)entityTitanPart.getBbWidth() - (double)entityTitanPart.getBbWidth() * 0.5 - player.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 ? player.hasLineOfSight((Entity)this) : false;
    }

    protected Player findPlayerToLookAt() {
        Player player = this.level().getNearestPlayer((Entity)this, -1.0);
        if (player != null && player.isAlive() && this.isAlive() && (this.isLookingAtMe(player, this.leftEye) || this.isLookingAtMe(player, this.rightEye))) {
            int knockbackAmount = 100;
            this.getLookControl().setLookAt((Entity)player, 180.0f, 30.0f);
            this.setTarget((LivingEntity)player);
            this.attackEntity((LivingEntity)player, 20.0f);
            if (!ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.ULTIMA_BLADE.get()) && !ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.OPTIMA_AXE.get())) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_STARE.get(), Float.MAX_VALUE, 1.0f);
                player.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, player.getX(), player.getY(), player.getZ(), 8.0f, true, Level.ExplosionInteraction.MOB);
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 400, 1));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 99));
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 400, 1));
                }
            }
            return player;
        }
        return null;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setScreaming(true);
        this.setCanCallBackUp(true);
        this.setRoarCooldownTimer(-20 - this.getRandom().nextInt(20));
        return groupData;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        float width = 12.0f;
        float height = this.isScreaming() ? 82.0f : 72.0f;
        float eyeHeight = this.isScreaming() ? 76.0f : 65.0f;
        return EntityDimensions.scalable((float)width, (float)height).withEyeHeight(eyeHeight);
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(100000.0 + (double)this.getExtraPower() * 2500.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(5000.0 + (double)this.getExtraPower() * 3000.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50000.0 + (double)this.getExtraPower() * 1250.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2500.0 + (double)this.getExtraPower() * 1500.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        ArrayList parts = Lists.newArrayList((Object[])this.parts);
        return !parts.contains(entity) && !(entity instanceof EntityEnderColossusCrystal) && !(entity instanceof EntityEnderColossusMinion) && !(entity instanceof EntityDragonMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable() && this.getAnimationID() != 5;
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + 2000.0;
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public SimpleParticleType getParticles() {
        return ParticleTypes.PORTAL;
    }

    @Override
    public int getParticleCount() {
        return 60;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusTemplarSpawnCap.get();
    }

    @Override
    public int getSpecialMinionCap() {
        return (Integer)TheTitansNeoConfigs.enderColossusSpecialSpawnCap.get();
    }

    @Override
    public boolean canSpawnSpecialMinion() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.enderColossusSummonSpecialMinionSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    @Override
    public float getSpeed() {
        return (float)(0.4 + (double)this.getExtraPower() * 0.001);
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public int getMaxHeadXRot() {
        return this.getEyeLaserTime() >= 0 ? 180 : 40;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_DEATH.get();
    }

    protected SoundEvent getRoarSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_ROAR.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.shakeNearbyPlayerCameras(6000.0);
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 0.85f);
        float f1 = this.getYRot() * (float)Math.PI / 180.0f;
        float f2 = Mth.sin((float)f1);
        float f3 = Mth.cos((float)f1);
        this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 10.0f), 0.0, (double)(f3 * 10.0f))));
        this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 10.0f), 0.0, (double)(f3 * 10.0f))));
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        this.hurt(damageSource, amount);
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isStunned) {
            amount *= 2.0f;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        this.setOnGround(true);
        this.hasImpulse = false;
        if (fallDistance <= 0.0f) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.getEffect(MobEffects.JUMP);
        float f1 = mobEffectInstance != null ? (float)(mobEffectInstance.getAmplifier() + 1) : 0.0f;
        int i = Mth.ceil((float)(fallDistance - 24.0f - f1));
        if (i > 0) {
            this.shakeNearbyPlayerCameras(400000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_LAND.get(), 10000.0f, 1.0f);
            this.destroyBlocksInAABBTopless(this.getBoundingBox().inflate(24.0, 1.0, 24.0));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(48.0, 4.0, 48.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity) || entity instanceof EntityTitan || entity instanceof EnderDragonPart) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                float smash = 100.0f - this.distanceTo((Entity)livingEntity);
                if (smash <= 1.0f) {
                    smash = 1.0f;
                }
                this.attackEntity(livingEntity, smash * 4.0f);
                double d0 = this.getBoundingBox().minX + this.getBoundingBox().maxX;
                double d1 = this.getBoundingBox().minZ + this.getBoundingBox().maxZ;
                double d2 = entity.getX() - d0;
                double d3 = entity.getZ() - d1;
                double d4 = d2 * d2 + d3 * d3;
                entity.push(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
            }
        }
        return true;
    }

    public void kill() {
        this.playSound(SoundEvents.ENDERMAN_TELEPORT, 100.0f, 0.6f);
        if (this.level().dimension() == Level.END || this.level().dimension() == TheTitansNeoDimensions.THE_VOID) {
            this.setPos(0.0, 128.0, 0.0);
        } else {
            this.setPos(this.getX() + (this.getRandom().nextDouble() - 0.5) * 48.0, 128.0, this.getZ() + (this.getRandom().nextDouble() - 0.5) * 48.0);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getEyeLaserTime() >= 0 && this.tickCount % 5 == 0 && !this.isStunned) {
            double d8 = 300.0;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dy = vec3.y * d8;
            double dz = vec3.z * d8;
            float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(d8, d8, d8).move(dx, dy, dz));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !entity.isAlive() || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount);
            }
        }
        if (this.isAlive() && !this.isStunned) {
            if (this.healCrystals) {
                if (this.numOfCrystals < this.maxNumOfCrystals) {
                    if (this.tickCount % 20 == 0) {
                        EntityEnderColossusCrystal enderColossusCrystal = new EntityEnderColossusCrystal(this.level());
                        enderColossusCrystal.owner = this;
                        enderColossusCrystal.setPos(this.getX(), this.getY() + 92.0, this.getZ());
                        enderColossusCrystal.push(0.0, 2.0, 0.0);
                        if (!this.level().isClientSide()) {
                            this.level().addFreshEntity((Entity)enderColossusCrystal);
                        }
                        ++this.numOfCrystals;
                    }
                } else {
                    this.healCrystals = false;
                }
            } else if (this.destroyedCrystals == 0 && this.numOfCrystals < this.maxNumOfCrystals) {
                this.healCrystals = true;
            }
        }
    }

    @Override
    protected void dropRateItem() {
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.GOLDEN_APPLE), 64);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND_SWORD), 64);
        drops.put(new ItemStack((ItemLike)Items.NAME_TAG), 64);
        Map.Entry entry = (Map.Entry)drops.entrySet().stream().toList().get(this.getRandom().nextInt(drops.entrySet().size()));
        ItemStack itemStack = (ItemStack)entry.getKey();
        int count = (Integer)entry.getValue();
        EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
        itemTitan.setPickUpDelay(40);
        if (!this.level().isClientSide()) {
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < 90; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 26000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.ENDER_EYE), 512);
        drops.put(new ItemStack((ItemLike)Items.ENDER_PEARL), 128);
        drops.put(new ItemStack((ItemLike)Blocks.COAL_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 128);
        drops.put(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 128);
        drops.put(new ItemStack((ItemLike)Blocks.DRAGON_EGG), 64);
        drops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 64);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.VOID.get()), 32);
        drops.put(new ItemStack((ItemLike)Blocks.END_PORTAL_FRAME), 60);
        rateDrops.put(new ItemStack((ItemLike)Items.ENDER_EYE), 512);
        rateDrops.put(new ItemStack((ItemLike)Items.ENDER_PEARL), 128);
        rateDrops.put(new ItemStack((ItemLike)Blocks.COAL_BLOCK), 256);
        rateDrops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 256);
        rateDrops.put(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 128);
        rateDrops.put(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 128);
        rateDrops.put(new ItemStack((ItemLike)Blocks.DRAGON_EGG), 64);
        rateDrops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 64);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.VOID.get()), 32);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), new ItemStack((ItemLike)TheTitansNeoItems.VOID_SWORD.get()));
        itemEntity.setPickUpDelay(40);
        if (!this.level().isClientSide()) {
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isStunned = false;
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            this.setAnimationTick(this.getAnimationTick() - 1);
            float f = (this.random.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 12.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void animationTick() {
        LivingEntity livingEntity;
        float amount;
        int knockbackAmount;
        float amount2;
        if (this.getAnimationID() == 1) {
            if (this.getAnimationTick() == 4 && this.getAntiTitanAttackAnimationID() == 0) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_CHOMP.get(), 100.0f, 1.0f);
            }
            if (this.getAnimationTick() == 12 && this.getTarget() != null) {
                this.shakeNearbyPlayerCameras(20000.0);
                amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                for (int i = 0; i < 16; ++i) {
                    this.attackEntity(this.getTarget(), amount2);
                }
                this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    for (int i = 0; i < 4; ++i) {
                        LivingEntity livingEntity2 = (LivingEntity)entity;
                        this.attackEntity(livingEntity2, amount2);
                        livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                    }
                }
            }
        }
        if (this.getAnimationID() == 2 && this.getAnimationTick() >= 40 && this.getAnimationTick() <= 80 && this.getTarget() != null) {
            for (int i = 0; i < 3; ++i) {
                for (int it = 0; it < 2; ++it) {
                    double d2 = this.getTarget().getX() + this.getRandom().nextGaussian() * 64.0;
                    double d3 = this.getTarget().getY() + 150.0 + this.getRandom().nextGaussian() * 32.0;
                    double d4 = this.getTarget().getZ() + this.getRandom().nextGaussian() * 64.0;
                    double d5 = this.getTarget().getX() - d2;
                    double d6 = this.getTarget().getY() - d3;
                    double d7 = this.getTarget().getZ() - d4;
                    EntityEnderPearlTitan enderPearlTitan = new EntityEnderPearlTitan(this.level(), (LivingEntity)this);
                    enderPearlTitan.setOwner((Entity)this);
                    enderPearlTitan.setPos(d2, d3, d4);
                    enderPearlTitan.shoot(d5, d6, d7, 1.0f, 4.0f);
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)enderPearlTitan);
                }
            }
        }
        if (this.getAnimationID() == 3) {
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_CHARGE.get(), 100.0f, 1.0f);
            }
            if (this.getAnimationTick() == 64) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_CHARGE.get(), 100.0f, 1.0f);
                double d8 = 24.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount2 = this.getKnockbackAmount();
                EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                colorLightningBolt1.setPos(this.getX() + dx, this.getY() + (this.isBaby() ? 9.0 : 18.0), this.getZ() + dz);
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt1);
                }
                if (this.getTarget() != null) {
                    EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                    colorLightningBolt2.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)colorLightningBolt2);
                    }
                    this.attackEntity(this.getTarget(), amount * 3.0f);
                    this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2 + 1.0 + (double)this.getRandom().nextFloat(), Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
                    if (!this.level().isClientSide()) {
                        this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        this.level().explode((Entity)this, this.getX() + dx, this.getY() + 26.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                    }
                    List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(4.0, 4.0, 4.0));
                    for (Entity entity : entities) {
                        if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                        LivingEntity livingEntity3 = (LivingEntity)entity;
                        EntityColorLightningBolt colorLightningBolt3 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                        colorLightningBolt3.setPos(livingEntity3.getX(), livingEntity3.getY(), livingEntity3.getZ());
                        if (!this.level().isClientSide()) {
                            this.level().addFreshEntity((Entity)colorLightningBolt3);
                        }
                        this.attackEntity(livingEntity3, amount);
                        livingEntity3.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
                        List entities1 = this.level().getEntities((Entity)livingEntity3, livingEntity3.getBoundingBox().inflate(4.0, 4.0, 4.0));
                        for (Entity entity1 : entities1) {
                            if (entity1 == null || entity1 == this || !(entity1 instanceof LivingEntity) || !this.canAttackEntity(entity1)) continue;
                            LivingEntity livingEntity1 = (LivingEntity)entity1;
                            EntityColorLightningBolt colorLightningBolt4 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                            colorLightningBolt4.setPos(livingEntity1.getX(), livingEntity1.getY(), livingEntity1.getZ());
                            if (!this.level().isClientSide()) {
                                this.level().addFreshEntity((Entity)colorLightningBolt4);
                            }
                            this.attackEntity(livingEntity1, amount);
                            livingEntity1.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
                            List entities2 = this.level().getEntities((Entity)livingEntity1, livingEntity1.getBoundingBox().inflate(4.0, 4.0, 4.0));
                            for (Entity entity2 : entities2) {
                                if (entity2 == null || entity2 == this || entity2 == livingEntity3 || !(entity2 instanceof LivingEntity) || !this.canAttackEntity(entity2)) continue;
                                LivingEntity livingEntity2 = (LivingEntity)entity2;
                                EntityColorLightningBolt colorLightningBolt5 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                                colorLightningBolt5.setPos(livingEntity2.getX(), livingEntity2.getY(), livingEntity2.getZ());
                                if (!this.level().isClientSide()) {
                                    this.level().addFreshEntity((Entity)colorLightningBolt5);
                                }
                                this.attackEntity(livingEntity2, amount);
                                livingEntity2.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
                                List entities3 = this.level().getEntities((Entity)livingEntity2, livingEntity2.getBoundingBox().inflate(4.0, 4.0, 4.0));
                                for (Entity entity3 : entities3) {
                                    if (entity3 == null || entity3 == this || entity3 == livingEntity3 || entity3 == livingEntity1 || !(entity3 instanceof LivingEntity) || !this.canAttackEntity(entity3)) continue;
                                    LivingEntity livingEntity32 = (LivingEntity)entity3;
                                    EntityColorLightningBolt colorLightningBolt6 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                                    colorLightningBolt6.setPos(livingEntity32.getX(), livingEntity32.getY(), livingEntity32.getZ());
                                    if (!this.level().isClientSide()) {
                                        this.level().addFreshEntity((Entity)colorLightningBolt6);
                                    }
                                    this.attackEntity(livingEntity32, amount);
                                    livingEntity32.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.getAnimationID() == 4 && this.getAnimationTick() == 50 && this.getTarget() != null) {
            this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_THROW.get(), 100.0f, 1.0f);
            double d8 = 24.0;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                this.level().explode((Entity)this, this.getX() + dx, this.getY() + 24.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
            }
            EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
            colorLightningBolt.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt);
            }
            this.getTarget().hurt(this.damageSources().lightningBolt(), 100.0f);
            double d5 = this.getTarget().getX() - this.getX();
            double d6 = this.getTarget().getY() - d8 - this.getY();
            double d7 = this.getTarget().getZ() - this.getZ();
            EntityLightningBall lightningBall = new EntityLightningBall(this.level(), (LivingEntity)this);
            lightningBall.setOwner((Entity)this);
            lightningBall.setPos(this.getX() + vec3.x * d8, this.getY() + d8, this.getZ() + vec3.z * d8);
            lightningBall.shoot(d5, d6, d7, 1.0f, 0.0f);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)lightningBall);
            }
        }
        if (this.getAnimationID() == 5) {
            if (this.getAnimationTick() == 80) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_SCREAM_LONG.get(), Float.MAX_VALUE, 1.0f);
            }
            if (this.getAnimationTick() > 80) {
                if (!this.level().isClientSide()) {
                    ServerLevel serverLevel = (ServerLevel)this.level();
                    serverLevel.setWeatherParameters(0, 0, false, false);
                }
                this.setScreaming(false);
                amount2 = 1.0E7f;
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
                List entities = this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(256.0, 256.0, 256.0));
                for (Object entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity((Entity)entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    for (int i = 0; i < 3; ++i) {
                        this.attackEntity(livingEntity, this.getAnimationTick());
                    }
                    this.attackEntity(livingEntity, amount2);
                    livingEntity.setDeltaMovement(0.0, livingEntity.getDeltaMovement().y, 0.0);
                    livingEntity.setXRot(livingEntity.getXRot() + 1.0f);
                    if (this.level().isClientSide()) continue;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 400, 1));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 99));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 400, 1));
                }
            }
        }
        if (this.getAnimationID() == 6) {
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_SCREAM.get(), 100.0f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.1f);
            }
            if (this.getAnimationTick() == 32) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 36) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                double d8 = 24.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount3 = this.getKnockbackAmount();
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(48.0, 12.0, 48.0).move(dx, -6.0, dz)));
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 8.0, 32.0).move(dx, -4.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity4 = (LivingEntity)entity;
                    this.attackEntity(livingEntity4, amount);
                    livingEntity4.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount3 * 0.2, (double)knockbackAmount3 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount3 * 0.2);
                }
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(64.0, 8.0, 64.0)));
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(64.0, 8.0, 64.0));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity5 = (LivingEntity)entity;
                    livingEntity5.push(0.0, (double)(2.0f + this.getRandom().nextFloat() + this.getRandom().nextFloat()), 0.0);
                }
            }
        }
        if (this.getAnimationID() == 7 && (this.getAnimationTick() == 60 || this.getAnimationTick() == 104)) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_SCREAM.get(), 100.0f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f);
            float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(36.0, 8.0, 32.0)));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 8.0, 32.0));
            for (Object entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity((Entity)entity)) continue;
                livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount3);
                livingEntity.push(0.0, (double)(2.0f + this.getRandom().nextFloat() + this.getRandom().nextFloat()), 0.0);
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 15) {
                this.level().playSound((Entity)this, this.head.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.MASTER, 10.0f, (1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f) * 0.7f);
                for (int i = 0; i < 50; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.head.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.head.getBbWidth(), this.head.getY() + this.getRandom().nextDouble() * (double)this.head.getBbHeight(), this.head.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.head.getBbWidth(), 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.head.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.head.getBbWidth(), this.head.getY() + this.getRandom().nextDouble() * (double)this.head.getBbHeight(), this.head.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.head.getBbWidth(), 0.0, 0.0, 0.0);
                }
            }
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_SCREAM.get(), this.getSoundVolume(), 1.25f);
            }
            if (this.getAnimationTick() == 90) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
                for (int i = 0; i < 2; ++i) {
                    this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                    this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                }
            }
            if (this.getAnimationTick() >= 360) {
                this.isStunned = false;
            } else {
                this.setTarget(null);
                this.isStunned = true;
            }
        }
        if (this.getAnimationID() == 9) {
            if (this.getAnimationTick() == 26) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 28 && this.getTarget() != null) {
                float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(4.0, 2.0, 4.0)));
                this.attackEntity(this.getTarget(), amount4);
                this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity6 = (LivingEntity)entity;
                    this.attackEntity(livingEntity6, amount4);
                    livingEntity6.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 30 || this.getAnimationTick() == 70) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
            }
            if (this.getAnimationTick() == 150 || this.getAnimationTick() == 230) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
                for (int i = 0; i < 4; ++i) {
                    this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                    this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                }
            }
            if (this.getAnimationTick() == 240) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
        }
        if (this.getAnimationID() == 11) {
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_CHARGE.get(), 100.0f, 1.0f);
            }
            if (this.getAnimationTick() == 50 && this.getTarget() != null) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_THROW.get(), 100.0f, 1.0f);
                double d8 = 24.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + 24.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                }
                for (int i = 0; i < 5; ++i) {
                    EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                    colorLightningBolt.setPos(this.getX() + dx, this.getY() + 24.0, this.getZ() + dz);
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
                this.getTarget().hurt(this.damageSources().lightningBolt(), 100.0f);
            }
        }
        if (this.getAnimationID() == 13 && this.getAnimationTick() == 50 && this.getTarget() != null) {
            float amount5 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
            }
            EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
            colorLightningBolt1.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt1);
            }
            this.attackEntity(this.getTarget(), amount5);
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(12.0, 12.0, 12.0));
            for (Entity entity : entities) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity7 = (LivingEntity)entity;
                for (int i = 0; i < 4; ++i) {
                    EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
                    colorLightningBolt2.setPos(livingEntity7.getX(), livingEntity7.getY(), livingEntity7.getZ());
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt2);
                }
                this.attackEntity(livingEntity7, amount5);
                livingEntity7.push(0.0, (double)(1.0f + this.getRandom().nextFloat()), 0.0);
            }
        }
    }

    @Override
    public void tick() {
        float fl;
        super.tick();
        this.refreshDimensions();
        if (this.getCanCallBackUp() && this.getTarget() != null && this.getTarget() instanceof EntityWitherzilla) {
            this.setCanCallBackUp(false);
        }
        this.setEyeLaserTime(this.getEyeLaserTime() - 1);
        if (this.destroyedCrystals < 0) {
            this.destroyedCrystals = 0;
        }
        if (this.destroyedCrystals > 12) {
            this.destroyedCrystals = 0;
            if (this.isAlive()) {
                this.isStunned = true;
            }
        }
        if (this.numOfCrystals < 0) {
            this.numOfCrystals = 0;
        }
        if (this.isAlive()) {
            if (this.tickCount % 120 == 0) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_LIVING.get(), this.getSoundVolume(), this.getVoicePitch());
            }
            ++this.roarcooldownTimer;
        }
        if (this.roarcooldownTimer == 0) {
            ServerLevel level;
            this.setScreaming(true);
            if (!this.level().isClientSide() && (level = (ServerLevel)this.level()).dimensionType().hasSkyLight() && level.isDay()) {
                level.setDayTime(level.getDayTime() + 14000L);
            }
        }
        if (this.roarcooldownTimer >= 60 || !this.isAlive()) {
            this.roarcooldownTimer = -(400 - this.getRandom().nextInt(200));
            this.setScreaming(false);
        }
        if ((fl = this.getLightLevelDependentMagicValue()) > 0.5f && !this.level().isClientSide() && this.level().dimensionType().hasSkyLight() && this.level().isDay() && this.tickCount % 1 == 0) {
            this.setXRot(this.yHeadRot / 6.0f);
            this.yHeadRot = -90.0f;
        }
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * 16.0f;
                float f4 = (this.getRandom().nextFloat() - 0.5f) * 5.0f;
                float f5 = (this.getRandom().nextFloat() - 0.5f) * 16.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 15.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount > 5) {
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            this.head.setPos(this.getX(), this.getY() + 60.0, this.getZ());
            this.body.setPos(this.getX(), this.getY() + 42.0, this.getZ());
            this.leftEye.setPos(this.getX() - (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 4.0f) - (double)(Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 7.0f), this.getY() + (double)this.getEyeHeight() - 1.0, this.getZ() - (double)(Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 4.0f) + (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 8.0f));
            this.rightEye.setPos(this.getX() + (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 4.0f) - (double)(Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 7.0f), this.getY() + (double)this.getEyeHeight() - 1.0, this.getZ() + (double)(Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 4.0f) + (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 8.0f));
            this.leftArm.setPos(this.getX() - (double)(f2 * 8.0f), this.getY() + 56.0, this.getZ() - (double)(f1 * 8.0f));
            this.rightArm.setPos(this.getX() + (double)(f2 * 8.0f), this.getY() + 56.0, this.getZ() + (double)(f1 * 8.0f));
            this.leftLeg.setPos(this.getX() - (double)(f2 * 3.0f), this.getY(), this.getZ() - (double)(f1 * 3.0f));
            this.rightLeg.setPos(this.getX() + (double)(f2 * 3.0f), this.getY(), this.getZ() + (double)(f1 * 3.0f));
            for (EntityTitanPart part : this.parts) {
                if (this.isAlive() && !this.isStunned) {
                    this.collideWithEntities(part, this.level().getEntities((Entity)this, part.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                }
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null && !this.isStunned) {
            if (this.getEyeLaserTime() < 0) {
                double d0 = this.distanceToSqr((Entity)this.getTarget());
                if (d0 < this.getMeleeRange()) {
                    if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                        AnimationUtils.sendPacket(this, 1);
                    } else {
                        switch (this.getRandom().nextInt(3)) {
                            case 0: {
                                AnimationUtils.sendPacket(this, 6);
                                break;
                            }
                            case 1: {
                                AnimationUtils.sendPacket(this, 7);
                                break;
                            }
                            case 2: {
                                AnimationUtils.sendPacket(this, 9);
                            }
                        }
                    }
                } else if (this.getRandom().nextInt(80) == 0) {
                    switch (this.getRandom().nextInt(6)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 4);
                            break;
                        }
                        case 1: {
                            if (this.getRandom().nextInt(25) == 0) {
                                AnimationUtils.sendPacket(this, 5);
                                break;
                            }
                            AnimationUtils.sendPacket(this, 2);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 11);
                            break;
                        }
                        case 4: {
                            AnimationUtils.sendPacket(this, 13);
                            break;
                        }
                        case 5: {
                            AnimationUtils.sendPacket(this, 2);
                        }
                    }
                }
            }
            if (!this.getWaiting() && this.getEyeLaserTime() <= -400 && this.getRandom().nextInt(40) == 0) {
                this.setEyeLaserTime(200);
            }
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        if (this.isInWaterOrRain() && !this.isInWater() && this.getAnimationID() != 13 && this.getAnimationID() != 10) {
            AnimationUtils.sendPacket(this, 5);
        }
        for (int i = 0; i < this.getParticleCount() * 5; ++i) {
            if (!this.isStunned) {
                this.findPlayerToLookAt();
            }
            this.level().addParticle((ParticleOptions)this.getParticles(), this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth() * 3.0, this.getY() + this.getRandom().nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth() * 3.0, 0.0, 0.25, 0.0);
        }
        this.meleeTitan = true;
        this.animationTick();
    }
}

