/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.List;
import net.byAqua3.thetitansneo.entity.EntityFlying;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class EntityEnderColossusCrystal
extends EntityFlying {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public int innerRotation = this.getRandom().nextInt(100000);
    public EntityEnderColossus owner;

    public EntityEnderColossusCrystal(EntityType<? extends EntityFlying> entityType, Level level) {
        super(entityType, level);
        this.hasImpulse = true;
        this.setOnGround(false);
    }

    public EntityEnderColossusCrystal(Level level) {
        this((EntityType<? extends EntityFlying>)((EntityType)TheTitansNeoEntities.ENDER_COLOSSUS_CRYSTAL.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 2.147483647E9);
    }

    private boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double p_70790_7_) {
        double d4 = (this.waypointX - this.getX()) / p_70790_7_;
        double d5 = (this.waypointY - this.getY()) / p_70790_7_;
        double d6 = (this.waypointZ - this.getZ()) / p_70790_7_;
        AABB aabb = this.getBoundingBox().move(d4, d5, d6);
        int i = 1;
        while ((double)i < p_70790_7_) {
            if (!this.level().getEntityCollisions((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return super.shouldRenderAtSqrDistance(distance) || this.owner != null;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.owner != null) {
            if (!this.owner.healCrystals) {
                this.owner.attackEntityFromPart(this.owner.leftEye, this.damageSources().mobAttack((LivingEntity)this), 1000.0f);
                this.owner.attackEntityFromPart(this.owner.rightEye, this.damageSources().mobAttack((LivingEntity)this), 1000.0f);
                this.owner.invulnerableTime = 0;
            }
            if (!this.owner.isStunned) {
                ++this.owner.destroyedCrystals;
            }
            --this.owner.numOfCrystals;
            this.owner = null;
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (damageSource.getEntity() instanceof EnderDragon || damageSource.getEntity() instanceof EntityEnderColossus || damageSource.getEntity() instanceof EntityEnderColossusCrystal) {
            return false;
        }
        if (damageSource.is(DamageTypes.EXPLOSION) || damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE)) {
            this.setOnGround(true);
            return true;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (this.onGround()) {
            this.setHealth(0.0f);
        }
    }

    public void kill() {
    }

    protected void serverAiStep() {
        double d0 = this.waypointX - this.getX();
        double d1 = this.waypointY - this.getY();
        double d2 = this.waypointZ - this.getZ();
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (this.distanceToSqr(this.waypointX, this.waypointY, this.waypointZ) > 10000.0) {
            double d5 = Math.sqrt(d3);
            this.push(d0 / d5 * 0.75 - this.getDeltaMovement().x, d1 / d5 * 0.75 - this.getDeltaMovement().y, d2 / d5 * 0.75 - this.getDeltaMovement().z);
        }
        if (d3 < 1.0 || d3 > 20000.0) {
            if (this.owner != null) {
                this.waypointX = this.owner.getX() + (double)((this.getRandom().nextFloat() * 4.0f - 2.0f) * this.owner.getBbWidth() * 2.0f);
                this.waypointY = this.owner.getY() + (double)this.owner.getBbHeight() + 48.0 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 24.0f);
                this.waypointZ = this.owner.getZ() + (double)((this.getRandom().nextFloat() * 4.0f - 2.0f) * this.owner.getBbWidth() * 2.0f);
            } else {
                this.waypointX = this.getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.waypointY = this.getY() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.waypointZ = this.getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f);
            }
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.getRandom().nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3 = Math.sqrt(d3))) {
                if (d3 > 4048.0) {
                    this.push(d0 / d3 * 0.2, d1 / d3 * 0.2, d2 / d3 * 0.2);
                } else {
                    this.push(d0 / d3 * 0.1, d1 / d3 * 0.1, d2 / d3 * 0.1);
                }
            } else {
                this.waypointX = this.getX();
                this.waypointY = this.getY();
                this.waypointZ = this.getZ();
            }
        }
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().x, -1.0, this.getDeltaMovement().z);
        }
        if (this.owner == null) {
            List entities = this.level().getEntitiesOfClass(EntityEnderColossus.class, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            for (EntityEnderColossus entity : entities) {
                if (entity.numOfCrystals >= 20) continue;
                this.owner = entity;
                ++this.owner.numOfCrystals;
            }
        }
    }

    protected void tickDeath() {
        this.setDeltaMovement(this.getDeltaMovement().x * 0.99, this.getDeltaMovement().y * 0.99 - 0.1, this.getDeltaMovement().z * 0.99);
        for (int i = 0; i < 200; ++i) {
            double d2 = this.getRandom().nextGaussian() * 0.02;
            double d0 = this.getRandom().nextGaussian() * 0.02;
            double d1 = this.getRandom().nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)(this.getRandom().nextFloat() * this.getBbWidth() * 2.0f), this.getY() + (double)(this.getRandom().nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.getRandom().nextFloat() * this.getBbWidth() * 2.0f), d2, d0, d1);
        }
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 6.0f, true, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        this.noCulling = true;
        ++this.innerRotation;
        if (this.isOnFire()) {
            this.setOnGround(true);
        }
        if (this.owner != null) {
            if (this.isAlive() && !this.owner.isStunned) {
                this.owner.heal(2.0f);
            }
            if (!this.owner.isAlive()) {
                this.setOnGround(true);
            }
        } else if (this.getRandom().nextInt(10) == 0) {
            float f = 256.0f;
            List entities = this.level().getEntitiesOfClass(EntityEnderColossus.class, this.getBoundingBox().inflate((double)f, (double)f, (double)f));
            double d0 = Double.MAX_VALUE;
            for (EntityEnderColossus entity : entities) {
                double d1 = entity.distanceToSqr((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                this.owner = entity;
            }
        }
    }
}

