/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.Optional;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntityExperienceOrbTitan
extends Entity {
    private int age;
    private int count;

    public EntityExperienceOrbTitan(EntityType<? extends EntityExperienceOrbTitan> entityType, Level level) {
        super(entityType, level);
    }

    public EntityExperienceOrbTitan(Level level, double posX, double posY, double posZ, int count) {
        this((EntityType<? extends EntityExperienceOrbTitan>)((EntityType)TheTitansNeoEntities.EXPERIENCE_ORB_TITAN.get()), level);
        this.setPos(posX, posY, posZ);
        this.count = count;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.age = tag.getInt("Age");
        this.count = tag.getInt("Count");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Age", this.age);
        tag.putInt("Count", this.count);
    }

    private int repairPlayerItems(ServerPlayer player, int value) {
        Optional optional = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)player, ItemStack::isDamaged);
        if (optional.isPresent()) {
            int k;
            ItemStack itemstack = ((EnchantedItemInUse)optional.get()).itemStack();
            int i = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)player.serverLevel(), (ItemStack)itemstack, (int)((int)((float)value * itemstack.getXpRepairRatio())));
            int j = Math.min(i, itemstack.getDamageValue());
            itemstack.setDamageValue(itemstack.getDamageValue() - j);
            if (j > 0 && (k = value - j * value / i) > 0) {
                return this.repairPlayerItems(player, k);
            }
            return 0;
        }
        return value;
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected void doWaterSplashEffect() {
    }

    public void updateFluidHeightAndDoFluidPushing() {
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        this.setOnGround(true);
        this.hasImpulse = false;
        if (fallDistance <= 0.0f) {
            return false;
        }
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 5.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
        this.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 5.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
        this.level().addParticle((ParticleOptions)(this.count < 2000 ? ParticleTypes.EXPLOSION_EMITTER : ParticleTypes.EXPLOSION), this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + 3.0 + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbHeight(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
        return super.causeFallDamage(fallDistance, multiplier, damageSource);
    }

    public void playerTouch(Player player) {
        if (this.level().isClientSide()) {
            return;
        }
        if (player.takeXpDelay == 0) {
            player.takeXpDelay = 2;
            ServerLevel serverLevel = (ServerLevel)this.level();
            ServerChunkCache serverChunkCache = serverLevel.getChunkSource();
            Holder holder = serverLevel.registryAccess().registryOrThrow(Registries.SOUND_EVENT).wrapAsHolder((Object)SoundEvents.EXPERIENCE_ORB_PICKUP);
            serverChunkCache.broadcastAndSend((Entity)player, (Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 5.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f, serverLevel.getServer().getWorldData().worldGenOptions().seed()));
            int i = this.repairPlayerItems((ServerPlayer)player, this.count);
            if (i > 0) {
                player.giveExperiencePoints(i);
            }
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (this.count < 100) {
            this.count = 100;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.age;
        if (this.age >= 6000 && !this.level().isClientSide()) {
            this.discard();
        }
    }
}

