/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanAttack1;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanAttack2;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanAttack3;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanAttack4;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanDeath;
import net.byAqua3.thetitansneo.entity.ai.irongolemtitan.AnimationIronGolemTitanRangedAttack;
import net.byAqua3.thetitansneo.entity.projectile.EntityIronIngotTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityGhastTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityIronGolemTitan
extends EntityTitan
implements IBossBarDisplay {
    private static final EntityDataAccessor<Boolean> PLAYER_CREATED = SynchedEntityData.defineId(EntityIronGolemTitan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int attackTimer;
    private int holdRoseTick;

    public EntityIronGolemTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
    }

    public EntityIronGolemTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.IRON_GOLEM_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 100000.0).add(Attributes.ATTACK_DAMAGE, 5000.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/iron_golem_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 0x6E6E6E;
    }

    @Override
    public int getBossBarWidth() {
        return 191;
    }

    @Override
    public int getBossBarHeight() {
        return 26;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanAttack4(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationIronGolemTitanRangedAttack(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<Mob>((Mob)this, Mob.class, 0, false, false, entity -> entity instanceof Enemy));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityTitan>((Mob)this, EntityTitan.class, 0, false, false, PredicateTitanTarget.IronGolemTitanSorter));
    }

    public boolean isPlayerCreated() {
        return (Boolean)this.entityData.get(PLAYER_CREATED);
    }

    public void setPlayerCreated(boolean playerCreated) {
        this.entityData.set(PLAYER_CREATED, (Object)playerCreated);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int getHoldRoseTick() {
        return this.holdRoseTick;
    }

    public void setHoldingRose(boolean holdingRose) {
        if (holdingRose) {
            this.holdRoseTick = 800;
            this.level().broadcastEntityEvent((Entity)this, (byte)11);
        } else {
            this.holdRoseTick = 0;
            this.level().broadcastEntityEvent((Entity)this, (byte)34);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER_CREATED, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPlayerCreated(tag.getBoolean("PlayerCreated"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return groupData;
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(100000.0 + (double)this.getExtraPower() * 2500.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(5000.0 + (double)this.getExtraPower() * 3000.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50000.0 + (double)this.getExtraPower() * 1250.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2500.0 + (double)this.getExtraPower() * 1500.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        return !(entity instanceof IronGolem) && (!(entity instanceof Player) || !this.isPlayerCreated());
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isPlayerCreated() && !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + 2000.0;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    public int getArmorValue() {
        return 24;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.shakeNearbyPlayerCameras(6000.0);
        for (int i = 0; i < 8; ++i) {
            this.playSound(SoundEvents.IRON_GOLEM_STEP, 10.0f, 0.5f);
        }
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
    }

    @Override
    protected float getSoundVolume() {
        return 100.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f : (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.5f;
    }

    @Override
    public void attackEntity(LivingEntity entity, float amount) {
        if (entity instanceof EntityWitherzilla) {
            amount *= 5.0f;
        }
        if (entity instanceof EntityGhastTitan && entity.getY() > this.getY() + 32.0) {
            EntityGhastTitan titan = (EntityGhastTitan)entity;
            titan.setTitanDeltaMovement(titan.getDeltaMovement().x, titan.getDeltaMovement().y - 1.0, titan.getDeltaMovement().z);
        }
        for (int i = 0; i < 7 + this.getRandom().nextInt(14); ++i) {
            super.attackEntity(entity, amount);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (amount > 1000.0f) {
            amount = 1000.0f;
        }
        return super.hurt(damageSource, amount);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 100.0f, 0.5f);
            this.attackTimer = 10;
        } else if (id == 11) {
            this.holdRoseTick = 800;
        } else if (id == 34) {
            this.holdRoseTick = 0;
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.holdRoseTick > 0) {
            --this.holdRoseTick;
        }
        float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox());
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity) && (!(entity instanceof Player) || this.isPlayerCreated()) || !entity.onGround() || entity instanceof EntityTitan || this.canAttackEntity(entity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            super.attackEntity(livingEntity, amount / 2.0f);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < 24; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 24000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 512);
        drops.put(new ItemStack((ItemLike)Items.POPPY), 128);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 32);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 32);
        rateDrops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 512);
        rateDrops.put(new ItemStack((ItemLike)Items.POPPY), 128);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 96);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 96);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 16);
        rateDrops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 8);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void animationTick() {
        float amount;
        Vec3 vec3;
        List entities;
        int knockbackAmount;
        float amount2;
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            for (int i = 0; i < 4; ++i) {
                this.attackEntity(this.getTarget(), amount2);
            }
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 6; ++i) {
                    this.attackEntity(livingEntity, amount2);
                }
                livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
            }
        }
        if (this.getAnimationID() == 5 && this.getAnimationTick() == 34 && this.getTarget() != null) {
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.attackEntity(this.getTarget(), amount2);
            double d8 = 30.0;
            Vec3 vec32 = this.getViewVector(1.0f);
            double d2 = this.getTarget().getX() - this.getX() + vec32.x * d8;
            double d3 = this.getTarget().getY() - this.getY() + d8;
            double d4 = this.getTarget().getZ() - this.getZ() + vec32.z * d8;
            EntityIronIngotTitan ironIngotTitan = new EntityIronIngotTitan(this.level(), (LivingEntity)this);
            ironIngotTitan.setOwner((Entity)this);
            ironIngotTitan.setPos(this.getX() + vec32.x * d8, this.getY() + d8, this.getZ() + vec32.z * d8);
            ironIngotTitan.shoot(d2, d3, d4, 1.0f, 0.0f);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)ironIngotTitan);
            }
        }
        if (this.getAnimationID() == 6) {
            if (this.getAnimationTick() == 34) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 100.0f, 1.0f);
                for (int i = 0; i < 2; ++i) {
                    this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 100.0f, 0.5f);
                }
            }
            if (this.getAnimationTick() == 38) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 20.0f, 1.0f);
                double d8 = 48.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount2 = this.getKnockbackAmount();
                List entities2 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(48.0, 16.0, 48.0).move(dx, -16.0, dz));
                for (Entity entity : entities2) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    for (int i = 0; i < 2; ++i) {
                        this.attackEntity(livingEntity, amount);
                    }
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 7 && (this.getAnimationTick() == 60 || this.getAnimationTick() == 104)) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            List entities3 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(48.0, 16.0, 48.0));
            for (Entity entity : entities3) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount3);
                livingEntity.push(0.0, (double)(2.0f + this.getRandom().nextFloat() + this.getRandom().nextFloat()), 0.0);
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 26) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 100.0f, 1.0f);
                for (int i = 0; i < 2; ++i) {
                    this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 100.0f, 0.5f);
                }
            }
            if (this.getAnimationTick() == 28 && this.getTarget() != null) {
                float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount() * 20;
                this.attackEntity(this.getTarget(), amount4);
                this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2 + 2.0, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 2.0, 6.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    super.attackEntity(livingEntity, amount4);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2 + 2.0, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 9) {
            if (this.getAnimationTick() == 44) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 100.0f, 1.0f);
                this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 100.0f, 0.5f);
            }
            if (this.getAnimationTick() == 48) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                for (int i = 0; i < 4; ++i) {
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 20.0f, 1.0f);
                }
                double d8 = 24.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                List entities4 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 4.0, 32.0).move(dx, -2.0, dz));
                for (Entity entity : entities4) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.attackEntity(livingEntity, amount);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * 3.0, 0.0, Math.cos((double)this.getYRot() * Math.PI / 180.0) * 3.0);
                }
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 30 || this.getAnimationTick() == 70) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
            }
            if (this.getAnimationTick() == 190) {
                this.shakeNearbyPlayerCameras(40000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 0.9f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            }
            if (this.getAnimationTick() == 200) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 0.5f);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getAnimationID() == 0 && this.getTarget() != null) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 1);
                } else {
                    switch (this.getRandom().nextInt(4)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 6);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 7);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 8);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 9);
                        }
                    }
                }
            } else if (this.getRandom().nextInt(160) == 0) {
                AnimationUtils.sendPacket(this, 5);
            }
        }
        if (this.getDeltaMovement().y > 1.0) {
            this.setTitanDeltaMovement(this.getDeltaMovement().x, 1.0, this.getDeltaMovement().z);
        }
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(96.0, 96.0, 96.0));
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof IronGolem)) continue;
            IronGolem ironGolem = (IronGolem)entity;
            if (ironGolem.horizontalCollision) {
                ironGolem.setDeltaMovement(this.getDeltaMovement().x, 0.25, this.getDeltaMovement().z);
            }
            if (ironGolem.getTarget() == null && ironGolem.distanceToSqr((Entity)this) > 4096.0) {
                ironGolem.getLookControl().setLookAt((Entity)this, 180.0f, 40.0f);
                ironGolem.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), 1.0);
            }
            if (ironGolem.tickCount != 20) continue;
            ironGolem.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityTitan>((Mob)this, EntityTitan.class, 0, false, false, PredicateTitanTarget.IronGolemTitanSorter));
        }
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.isAlive() && this.tickCount % 20 == 0 && (double)randomRate < (Double)TheTitansNeoConfigs.ironGolemTitanSummonMinionSpawnRate.get()) {
            IronGolem ironGolem = new IronGolem(EntityType.IRON_GOLEM, this.level());
            ironGolem.setPos(this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)this.getEyeHeight(), this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth());
            ironGolem.setYRot(this.getYRot());
            ironGolem.getAttribute(Attributes.MAX_HEALTH).setBaseValue(2000.0);
            ironGolem.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(32.0);
            ironGolem.setHealth(2000.0f);
            ironGolem.setCustomName((Component)Component.translatable((String)"entity.thetitansneo.reinforced_iron_golem"));
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)ironGolem);
            }
        }
        this.meleeTitan = true;
        this.animationTick();
    }
}

