/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishAttack1;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishAttack2;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishAttack3;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishBodySlam;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishBurrow;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishCreation;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishDeath;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishLightningAttack;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishStunned;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishTailSmash;
import net.byAqua3.thetitansneo.entity.ai.omegafish.AnimationOmegafishUnburrow;
import net.byAqua3.thetitansneo.entity.minion.EntityOmegafishMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityOmegafish
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    public final EntityTitanPart[] parts;
    public EntityTitanPart head = new EntityTitanPart(this, "head", 3.0f, 2.0f);
    public EntityTitanPart body = new EntityTitanPart(this, "body", 5.0f, 4.0f);
    public EntityTitanPart tailbase = new EntityTitanPart(this, "tailbase", 3.0f, 3.0f);
    public EntityTitanPart tail1 = new EntityTitanPart(this, "tail1", 3.0f, 2.0f);
    public EntityTitanPart tail2 = new EntityTitanPart(this, "tail2", 2.0f, 1.0f);
    public EntityTitanPart tailtip = new EntityTitanPart(this, "tailtip", 2.0f, 1.0f);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Player cachedOwner;
    public int damageToParts;
    public boolean isSubdued;
    public boolean isBurrowing;
    public boolean isStunned;

    public EntityOmegafish(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        for (EntityTitanPart part : this.parts = new EntityTitanPart[]{this.head, this.body, this.tailbase, this.tail1, this.tail2, this.tailtip}) {
            level.addFreshEntity((Entity)part);
        }
    }

    public EntityOmegafish(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.OMEGAFISH.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 16000.0).add(Attributes.ATTACK_DAMAGE, 150.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/omegafish.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 0x303030;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 33;
    }

    @Override
    public int getBossBarInterval() {
        return 7;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishCreation(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishBodySlam(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishBurrow(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishLightningAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishStunned(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishTailSmash(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationOmegafishUnburrow(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.OmegafishSorter));
    }

    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.level().getPlayerByUUID(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(Player owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.damageToParts = tag.getInt("DamageToParts");
        this.isSubdued = tag.getBoolean("IsSubdued");
        this.isBurrowing = tag.getBoolean("IsBurrowing");
        this.isStunned = tag.getBoolean("IsStunned");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.putInt("DamageToParts", this.damageToParts);
        tag.putBoolean("IsSubdued", this.isSubdued);
        tag.putBoolean("IsBurrowing", this.isBurrowing);
        tag.putBoolean("IsStunned", this.isStunned);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setWaiting(true);
        return groupData;
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(16000.0 + (double)this.getExtraPower() * 400.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(150.0 + (double)this.getExtraPower() * 80.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8000.0 + (double)this.getExtraPower() * 200.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(75.0 + (double)this.getExtraPower() * 40.0);
        }
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        ArrayList parts = Lists.newArrayList((Object[])this.parts);
        return !parts.contains(entity) && !(entity instanceof EntityOmegafishMinion) && (!this.isSubdued || !(entity instanceof Player));
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isBurrowing && !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && !this.getWaiting() && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + 100.0;
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getTitanHealth() <= this.getMaxHealth() / 4.0f;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.omegafishMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.omegafishPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.omegafishZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.omegafishBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.omegafishTemplarSpawnCap.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    @Override
    public float getSpeed() {
        return (float)(this.isBurrowing ? 0.9 + (double)this.getExtraPower() * 0.001 : 0.7 + (double)this.getExtraPower() * 0.001);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        if (entity instanceof Player) {
            double d8 = 1.5 + (double)this.getExtraPower() * 0.05;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            return this.position().add(dx, this.isBurrowing ? 0.5 + (double)this.getExtraPower() * 0.05 : 3.0 + (double)this.getExtraPower() * 0.05, dz);
        }
        return super.getPassengerRidingPosition(entity);
    }

    protected SoundEvent getAmbientSound() {
        if (!this.isStunned && !this.getWaiting() && this.getAnimationID() != 2) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_SILVERFISH_LIVING.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_SILVERFISH_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_SILVERFISH_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        if (entityTitanPart == this.head) {
            amount *= 2.0f;
        }
        if (this.hurt(damageSource, amount) && damageSource.getEntity() != null && damageSource.getEntity() instanceof Player && this.damageToParts < 8 && !this.isStunned) {
            ++this.damageToParts;
            this.hurt(damageSource, 100.0f);
            this.setTarget((LivingEntity)damageSource.getEntity());
            if (this.damageToParts >= 1) {
                this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
                this.isStunned = true;
                this.damageToParts = 0;
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isArmored()) {
            amount /= 2.0f;
        }
        if (this.isStunned) {
            amount *= 3.0f;
        }
        return super.hurt(damageSource, amount);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (this.isStunned && !this.isSubdued) {
            if (item == Items.GOLDEN_APPLE) {
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                player.swing(hand, true);
                float randomRate = this.getRandom().nextFloat() * 100.0f;
                if ((double)randomRate < (Double)TheTitansNeoConfigs.omegafishSubdueRate.get()) {
                    this.playSound(SoundEvents.PLAYER_LEVELUP, 10.0f, 1.0f);
                    this.isSubdued = true;
                    this.setOwner(player);
                    player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.titan.subdued", (Object[])new Object[]{this.getName(), player.getName()}));
                }
            }
        } else if (!this.isStunned && this.isSubdued && this.getOwner() == player) {
            if (!itemStack.isEmpty()) {
                if (this.getAnimationID() == 0) {
                    if (itemStack.getItem() == Items.DIAMOND) {
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                        }
                        player.swing(hand, true);
                        AnimationUtils.sendPacket(this, 9);
                    }
                    if (itemStack.getItem() == Items.COOKED_CHICKEN) {
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                        }
                        player.swing(hand, true);
                        AnimationUtils.sendPacket(this, 3);
                    }
                    if (itemStack.getItem() == Items.BONE) {
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                        }
                        player.swing(hand, true);
                        switch (this.getRandom().nextInt(2)) {
                            case 0: {
                                AnimationUtils.sendPacket(this, 5);
                                break;
                            }
                            case 1: {
                                AnimationUtils.sendPacket(this, 6);
                            }
                        }
                    }
                    if (itemStack.getItem() instanceof ShovelItem) {
                        player.swing(hand, true);
                        if (this.isBurrowing) {
                            AnimationUtils.sendPacket(this, 2);
                        } else {
                            AnimationUtils.sendPacket(this, 1);
                        }
                    }
                }
            } else if (!player.isPassenger()) {
                player.swing(hand, true);
                player.startRiding((Entity)this);
            }
        }
        return InteractionResult.PASS;
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        if (!this.isAlive()) {
            player.stopRiding();
        }
        this.setTarget(null);
        this.setYRot(player.getYRot());
        this.yRotO = player.yRotO;
        this.yHeadRot = player.yHeadRot;
        if (player.zza > 0.0f) {
            this.moveRelative(this.getSpeed(), new Vec3(0.0, 0.0, 1.0));
        } else if (player.zza < 0.0f) {
            this.moveRelative(-this.getSpeed() * 0.25f, new Vec3(0.0, 0.0, 1.0));
        }
        if (player.xxa != 0.0f) {
            this.moveRelative(this.getSpeed() * 0.5f * Math.signum(player.xxa), new Vec3(1.0, 0.0, 0.0));
        }
        if (this.onGround() && player.getXRot() < -80.0f) {
            this.jumpFromGround();
        }
        if (!this.isControlledByLocalInstance()) {
            this.calculateEntityAnimation(false);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < 6; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 3000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.PAPER), 96);
        drops.put(new ItemStack((ItemLike)Items.COAL), 32);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 4);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 4);
        rateDrops.put(new ItemStack((ItemLike)Blocks.INFESTED_STONE), 4);
        drops.put(new ItemStack((ItemLike)Blocks.STONE), 16);
        drops.put(new ItemStack((ItemLike)Blocks.COBBLESTONE), 16);
        rateDrops.put(new ItemStack((ItemLike)Items.PAPER), 96);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        rateDrops.put(new ItemStack((ItemLike)Blocks.INFESTED_STONE), 8);
        rateDrops.put(new ItemStack((ItemLike)Blocks.STONE), 48);
        rateDrops.put(new ItemStack((ItemLike)Blocks.COBBLESTONE), 48);
        rateDrops.put(new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE), 48);
        rateDrops.put(new ItemStack((ItemLike)Blocks.STONE_BRICKS), 32);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM_NUGGET.get()), 4);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isBurrowing = false;
        this.isStunned = false;
        if (this.deathTicks >= 300) {
            this.setInvulTime(this.getInvulTime() + 8);
            this.setAnimationTick(this.getAnimationTick() - 1);
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL && entity instanceof EntityOmegafishMinion) {
            EntityOmegafishMinion omegafishMinion = (EntityOmegafishMinion)entity;
            omegafishMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
        }
    }

    public void animationTick() {
        LivingEntity livingEntity;
        List entities;
        int knockbackAmount;
        float amount;
        Vec3 vec3;
        LivingEntity livingEntity2;
        List entities2;
        int knockbackAmount2;
        float amount2;
        if (this.getAnimationID() == 13) {
            this.addDayTime(14000L, 50L);
            if (this.getAnimationTick() == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 100.0f, 1.25f);
            }
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SILVERFISH_LIVING.get(), this.getSoundVolume(), 0.7f);
            }
            if (this.getAnimationTick() == 150) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), this.getSoundVolume(), 1.0f);
            }
        }
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 50) {
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.25f);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount2 = this.getKnockbackAmount() * 3;
            entities2 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0, 16.0, 16.0));
            for (Entity entity : entities2) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity2 = (LivingEntity)entity;
                this.attackEntity(livingEntity2, amount2);
                livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            }
        }
        if (this.getAnimationID() == 2) {
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.QUICK_APPERENCE.get(), 20.0f, 1.0f);
                this.destroyBlocksInAABB(this.getBoundingBox().move(0.0, -2.0, 0.0));
                this.setTitanDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 0.75f), 1.0, (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 0.75f)));
                amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount2 = this.getKnockbackAmount();
                entities2 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0, 16.0, 16.0));
                for (Entity entity : entities2) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity2 = (LivingEntity)entity;
                    this.attackEntity(livingEntity2, amount2);
                    livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
                }
            }
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
                amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount2 = this.getKnockbackAmount() * 3;
                entities2 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0, 16.0, 16.0));
                for (Entity entity : entities2) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity2 = (LivingEntity)entity;
                    this.attackEntity(livingEntity2, amount2);
                    livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 3 && this.getAnimationTick() == 36) {
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.5f);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount2 = this.getKnockbackAmount();
            entities2 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(64.0, 4.0, 64.0));
            for (Entity entity : entities2) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity2 = (LivingEntity)entity;
                this.attackEntity(livingEntity2, amount2 * 4.0f);
                livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            }
        }
        if (this.getAnimationID() == 4 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.75f);
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount2 = this.getKnockbackAmount();
            this.attackEntity(this.getTarget(), amount2);
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            entities2 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(4.0, 4.0, 4.0));
            for (Entity entity : entities2) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity2 = (LivingEntity)entity;
                this.attackEntity(livingEntity2, amount2);
                livingEntity2.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            }
        }
        if (this.getAnimationID() == 5) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.75f);
                double d8 = 4.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
            if (this.getAnimationTick() == 26) {
                double d8 = 8.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
            if (this.getAnimationTick() == 30) {
                double d8 = 16.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
        }
        if (this.getAnimationID() == 6) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.75f);
                double d8 = 4.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
            if (this.getAnimationTick() == 26) {
                double d8 = 8.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
            if (this.getAnimationTick() == 30) {
                double d8 = 16.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 1.0, 1.0).move(dx, 0.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity, amount * 2.0f);
                    livingEntity.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2, (double)knockbackAmount * 0.7, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 1.2);
                }
            }
        }
        if (this.getAnimationID() == 7 && this.getAnimationTick() == 20) {
            double d8 = -3.0;
            vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getX() + dx, this.getY() + 8.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
            }
            EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 0.5f, 0.5f, 0.5f);
            colorLightningBolt1.setPos(this.getX() + dx, this.getY() + 8.0, this.getZ() + dz);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt1);
            }
            if (this.getTarget() != null) {
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                }
                EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 0.25f, 0.25f, 0.25f);
                colorLightningBolt2.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt2);
                }
                this.attackEntity(this.getTarget(), amount);
                this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2 + 2.0, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                List entities3 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(2.0, 2.0, 2.0));
                for (Entity entity : entities3) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity3 = (LivingEntity)entity;
                    this.attackEntity(livingEntity3, amount);
                    livingEntity3.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2, (double)knockbackAmount * 0.2 + 1.0, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 37) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LARGE_FALL.get(), 4.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
            if (this.getAnimationTick() == 380) {
                this.isStunned = false;
            } else {
                this.setTarget(null);
            }
        }
        if (this.getAnimationID() == 9) {
            if (this.getAnimationTick() == 80) {
                this.setTitanDeltaMovement(this.getDeltaMovement().add(0.0, 9.0, 0.0));
                if (this.getTarget() != null) {
                    double d01 = this.getTarget().getX() - this.getX();
                    double d11 = this.getTarget().getZ() - this.getZ();
                    float f21 = (float)Math.sqrt(d01 * d01 + d11 * d11);
                    double hor = f21 / 16.0f;
                    this.setTitanDeltaMovement(d01 / (double)f21 * hor * hor + this.getDeltaMovement().x * hor, this.getDeltaMovement().y, d11 / (double)f21 * hor * hor + this.getDeltaMovement().z * hor);
                }
            }
            if (this.getAnimationTick() == 240) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.5f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_LAND.get(), 10000.0f, 1.0f);
                float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount2 = this.getKnockbackAmount();
                List entities4 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(96.0, 32.0, 96.0));
                for (Entity entity : entities4) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity4 = (LivingEntity)entity;
                    if (this.getRandom().nextInt(3) == 0) {
                        livingEntity4.setRemainingFireTicks(20);
                    }
                    this.attackEntity(livingEntity4, amount3 * 10.0f);
                    livingEntity4.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2 + 1.5, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
                }
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 74 || this.getAnimationTick() == 216) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 76) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
        }
        if (this.getAnimationID() == 11 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            if (this.isArmored()) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.05f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.1f);
                for (int i = 0; i < 3; ++i) {
                    this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(26.0, 26.0, 26.0)));
                }
            }
            float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount2 = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(48.0, 48.0, 48.0)));
            for (int i = 0; i < 4; ++i) {
                this.attackEntity(this.getTarget(), amount4);
            }
            this.getTarget().push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            List entities5 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities5) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity5 = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity5, amount4);
                }
                livingEntity5.push(-Math.sin((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2, (double)knockbackAmount2 * 0.2, Math.cos((double)this.getYRot() * Math.PI / 180.0) * (double)knockbackAmount2 * 0.2);
            }
        }
    }

    @Override
    public void tick() {
        float f5;
        float f4;
        float f3;
        super.tick();
        if (this.isSubdued) {
            this.setTarget(null);
        }
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned || this.isBurrowing)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                f3 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                f5 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (!(this.getAnimationID() == 2 || this.getAnimationID() == 9 || this.isPassenger() || this.getWaiting() || this.isStunned || this.isBurrowing)) {
            if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > this.getMeleeRange() + 4000.0) {
                if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                    this.fallDistance = 0.0f;
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                    if (this.getDeltaMovement().y < 0.0) {
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                    }
                }
                this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
            }
            if (!this.onGround()) {
                f3 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                f5 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getWaiting()) {
            AnimationUtils.sendPacket(this, 13);
            Player player = this.level().getNearestPlayer((Entity)this, 24.0);
            if (player != null) {
                this.setWaiting(false);
                this.lookAt((Entity)player, 180.0f, 0.0f);
            }
        } else if (this.getAnimationID() == 13) {
            this.setTitanDeltaMovement(0.0, 0.0, 0.0);
            this.setOnGround(true);
        }
        if (this.getAnimationID() == 1) {
            this.isBurrowing = true;
        } else if (this.getAnimationID() == 2) {
            this.isBurrowing = false;
        }
        if (this.tickCount > 5) {
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            this.head.setPos(this.getX() - (double)(Mth.sin((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 3.0f), this.getY() - (double)(Mth.sin((float)(this.getXRot() * (float)Math.PI / 180.0f)) * 2.0f), this.getZ() + (double)(Mth.cos((float)(this.yHeadRot * (float)Math.PI / 180.0f)) * 3.0f));
            this.body.setPos(this.getX(), this.getY(), this.getZ());
            this.tailbase.setPos(this.getX() + (double)f1 * 4.0, this.getY(), this.getZ() - (double)f2 * 4.0);
            this.tail1.setPos(this.getX() + (double)f1 * 7.0, this.getY(), this.getZ() - (double)f2 * 7.0);
            this.tail2.setPos(this.getX() + (double)f1 * 9.5, this.getY(), this.getZ() - (double)f2 * 9.5);
            this.tailtip.setPos(this.getX() + (double)f1 * 11.5, this.getY(), this.getZ() - (double)f2 * 11.5);
            if (this.isAlive() && !this.isStunned) {
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.tailbase, this.level().getEntities((Entity)this, this.tailbase.getBoundingBox()));
                this.collideWithEntities(this.tail1, this.level().getEntities((Entity)this, this.tail1.getBoundingBox()));
                this.collideWithEntities(this.tail2, this.level().getEntities((Entity)this, this.tail2.getBoundingBox()));
                this.collideWithEntities(this.tailtip, this.level().getEntities((Entity)this, this.tailtip.getBoundingBox()));
            }
            for (EntityTitanPart part : this.parts) {
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null && !this.isStunned) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.isBurrowing) {
                    AnimationUtils.sendPacket(this, 2);
                } else if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 11);
                } else {
                    switch (this.getRandom().nextInt(3)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 6);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 5);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 4);
                        }
                    }
                }
            } else if (!this.isBurrowing && this.getRandom().nextInt(this.isArmored() ? 20 : 60) == 0) {
                if (this.getTarget().getY() > this.getY() + 12.0) {
                    AnimationUtils.sendPacket(this, 7);
                } else {
                    switch (this.getRandom().nextInt(4)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 7);
                            break;
                        }
                        case 2: {
                            if (!this.isBurrowing) {
                                AnimationUtils.sendPacket(this, 1);
                                break;
                            }
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 3: {
                            if (this.getRandom().nextInt(3) == 0) {
                                AnimationUtils.sendPacket(this, 9);
                                break;
                            }
                            AnimationUtils.sendPacket(this, 3);
                        }
                    }
                }
            }
        }
        if (this.isBurrowing) {
            if (this.tickCount % 40 == 0) {
                int i;
                for (i = 10; i > 6; --i) {
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), 10.0f, 1.0f);
                }
                for (i = 5; i > 1; --i) {
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_QUAKE.get(), i, 1.0f);
                }
            }
            this.destroyBlocksInAABB(this.getBoundingBox().inflate(2.0, 0.0, 2.0));
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        if (this.isStunned || this.deathTicks > 0) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        }
        this.meleeTitan = true;
        this.animationTick();
        if (this.getFirstPassenger() instanceof Player) {
            Player player = (Player)this.getFirstPassenger();
            this.tickRidden(player, new Vec3((double)this.xxa, (double)this.yya, (double)this.zza));
        }
    }
}

