/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.PredicateTitanTarget;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.snowtitan.EntityAISnowGolemTitanShoot;
import net.byAqua3.thetitansneo.entity.projectile.EntitySnowballTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntitySnowGolemTitan
extends EntityTitan
implements RangedAttackMob,
IBossBarDisplay {
    public EntitySnowGolemTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
    }

    public EntitySnowGolemTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.SNOW_GOLEM_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 4000.0).add(Attributes.ATTACK_DAMAGE, 60.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/snow_golem_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 0xBCBCBC;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 27;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new EntityAISnowGolemTitanShoot(this, 20, 512.0f));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, PredicateTitanTarget.SnowGolemTitanSorter));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(4000.0 + (double)this.getExtraPower() * 200.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(60.0 + (double)this.getExtraPower() * 36.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(2000.0 + (double)this.getExtraPower() * 100.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(30.0 + (double)this.getExtraPower() * 18.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        return !(entity instanceof EntitySnowGolemTitan) && !(entity instanceof SnowGolem);
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    public int getArmorValue() {
        return 15;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SNOW_STEP;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    public void kill() {
        super.kill();
        this.setTitanHealth(0.0f);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 10.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.lookAt((Entity)target, 180.0f, 30.0f);
        EntitySnowballTitan snowballTitan = new EntitySnowballTitan(this.level(), (LivingEntity)this);
        snowballTitan.setPos(this.getX(), this.getEyeY() - 5.0, this.getZ());
        double d1 = target.getX() - this.getX();
        double d2 = target.getEyeY() - snowballTitan.getY();
        double d3 = target.getZ() - this.getZ();
        snowballTitan.shoot(d1, d2, d3, 1.0f, 0.0f);
        if (!this.level().isClientSide()) {
            this.level().addFreshEntity((Entity)snowballTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        for (int x = 0; x < 2; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 1000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.SNOWBALL), 256);
        rateDrops.put(new ItemStack((ItemLike)Items.SNOWBALL), 256);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 4);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 4);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            if (this.level().isClientSide()) continue;
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getTarget() != null) {
            double d0;
            if (this.tickCount % 30 == 0 && (d0 = this.distanceToSqr((Entity)this.getTarget())) <= this.getMeleeRange()) {
                this.swing(InteractionHand.MAIN_HAND);
                this.getLookControl().setLookAt((Entity)this.getTarget(), 180.0f, 30.0f);
                float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                this.attackEntity(this.getTarget(), amount);
            }
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(128.0, 128.0, 128.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof SnowGolem)) continue;
                SnowGolem snowGolem = (SnowGolem)entity;
                snowGolem.setTarget(this.getTarget());
                snowGolem.getLookControl().setLookAt((Entity)this.getTarget(), 40.0f, 40.0f);
                if (snowGolem.horizontalCollision) {
                    snowGolem.setDeltaMovement(snowGolem.getDeltaMovement().x, 0.25, snowGolem.getDeltaMovement().y);
                }
                if (this.level().isClientSide() || entity.tickCount % 20 != 0) continue;
                snowGolem.performRangedAttack(this.getTarget(), 1.0f);
            }
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        this.animateHurt(180.0f);
        this.destroyBlocksInAABB(this.getBoundingBox());
        if (this.deathTicks >= 20) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        for (int i = 0; i < 1024; ++i) {
            int x = Mth.floor((double)(this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth()));
            int y = Mth.floor((double)this.getY());
            int z = Mth.floor((double)(this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth()));
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockState blockState = this.level().getBlockState(blockPos);
            if (!blockState.isAir() || !(((Biome)this.level().getBiome(blockPos).value()).getBaseTemperature() < 1.3f) || !Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level(), blockPos)) continue;
            this.level().setBlockAndUpdate(blockPos, Blocks.SNOW.defaultBlockState());
        }
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.isAlive() && this.tickCount % 20 == 0 && (double)randomRate < (Double)TheTitansNeoConfigs.snowGolemTitanSummonMinionSpawnRate.get()) {
            SnowGolem snowGolem = new SnowGolem(EntityType.SNOW_GOLEM, this.level());
            snowGolem.setPos(this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)this.getEyeHeight(), this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth());
            snowGolem.setYRot(this.getYRot());
            snowGolem.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
            snowGolem.setHealth(20.0f);
            snowGolem.setCustomName((Component)Component.translatable((String)"entity.thetitansneo.reinforced_snow_golem"));
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)snowGolem);
            }
        }
    }
}

