/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.animation.IAnimatedEntity;
import net.byAqua3.thetitansneo.damage.DamageSourceTitanAttack;
import net.byAqua3.thetitansneo.entity.IEntityAnimatedHealth;
import net.byAqua3.thetitansneo.entity.ai.EntityAITitanLookIdle;
import net.byAqua3.thetitansneo.entity.ai.EntityAITitanWatchClosest;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.projectile.EntityHarcadiumArrow;
import net.byAqua3.thetitansneo.entity.projectile.IEntityProjectileTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityCreeperTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossusCrystal;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityGhastTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySlimeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanSpirit;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.loader.TheTitansNeoAttributes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDimensions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMinions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTriggers;
import net.byAqua3.thetitansneo.trigger.TriggerTitanDeath;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.byAqua3.thetitansneo.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;

public class EntityTitan
extends AmbientCreature
implements IAnimatedEntity,
IEntityAnimatedHealth {
    private static final EntityDataAccessor<Integer> ANIMATION_ID = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANTI_TITAN_ATTACK__ANIMATION_ID = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EXTRAPOWER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> INVULTIME = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> WAITING = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> TITAN_HEALTH = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ANIMATED_TITAN_HEALTH = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> MINION_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PRIEST_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ZEALOT_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BISHOP_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TEMPLAR_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPECIAL_MINION_NUMBER = SynchedEntityData.defineId(EntityTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int invulnerableTicks;
    public int deathTicks;
    public boolean shouldParticlesBeUpward;
    public boolean isRejuvinating;
    public boolean meleeTitan;
    public int footID;
    protected int nextStepDistanceTitan;

    public EntityTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.invulnerableDuration = 30;
        this.refreshAttributes();
        this.setTitanHealth(this.getMaxHealth());
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createLivingAttributes().add(Attributes.MAX_HEALTH, Double.MAX_VALUE).add(Attributes.FOLLOW_RANGE, 512.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new EntityAITitanWatchClosest(this, EntityTitanSpirit.class, 128.0f, 0.25f));
        this.goalSelector.addGoal(8, (Goal)new EntityAITitanWatchClosest(this, EntityTitan.class, 128.0f, 0.5f));
        this.goalSelector.addGoal(9, (Goal)new EntityAITitanWatchClosest(this, Player.class, 128.0f));
        this.goalSelector.addGoal(10, (Goal)new EntityAITitanLookIdle(this));
    }

    @Override
    public int getAnimationID() {
        return (Integer)this.entityData.get(ANIMATION_ID);
    }

    @Override
    public void setAnimationID(int id) {
        this.entityData.set(ANIMATION_ID, (Object)id);
    }

    @Override
    public int getAnimationTick() {
        return (Integer)this.entityData.get(ANIMATION_TICK);
    }

    @Override
    public void setAnimationTick(int tick) {
        this.entityData.set(ANIMATION_TICK, (Object)tick);
    }

    public int getAntiTitanAttackAnimationID() {
        return (Integer)this.entityData.get(ANTI_TITAN_ATTACK__ANIMATION_ID);
    }

    public void setAntiTitanAttackAnimationID(int id) {
        this.entityData.set(ANTI_TITAN_ATTACK__ANIMATION_ID, (Object)id);
    }

    public int getExtraPower() {
        return (Integer)this.entityData.get(EXTRAPOWER);
    }

    public void setExtraPower(int extraPower) {
        this.entityData.set(EXTRAPOWER, (Object)extraPower);
    }

    public int getInvulTime() {
        return (Integer)this.entityData.get(INVULTIME);
    }

    public void setInvulTime(int invulTime) {
        if (invulTime < 0) {
            this.entityData.set(INVULTIME, (Object)0);
        } else {
            this.entityData.set(INVULTIME, (Object)invulTime);
            if (this instanceof EntityCreeperTitan) {
                this.setXRot((float)invulTime / (float)this.getThreashHold() * 40.0f);
            } else {
                this.setXRot((float)invulTime / (float)this.getThreashHold() * 180.0f);
            }
        }
    }

    public boolean getWaiting() {
        return (Boolean)this.entityData.get(WAITING);
    }

    public void setWaiting(boolean waiting) {
        this.entityData.set(WAITING, (Object)waiting);
    }

    public float getTitanHealth() {
        return ((Float)this.entityData.get(TITAN_HEALTH)).floatValue();
    }

    public void setTitanHealth(float health) {
        this.entityData.set(TITAN_HEALTH, (Object)Float.valueOf(health));
    }

    public float getHealth() {
        return this.getTitanHealth();
    }

    @Override
    public float getAnimatedHealth() {
        return ((Float)this.entityData.get(ANIMATED_TITAN_HEALTH)).floatValue();
    }

    @Override
    public void setAnimatedHealth(float animatedHealth) {
        this.entityData.set(ANIMATED_TITAN_HEALTH, (Object)Float.valueOf(animatedHealth));
    }

    public int getMinionNumber() {
        return (Integer)this.entityData.get(MINION_NUMBER);
    }

    public void setMinionNumber(int number) {
        this.entityData.set(MINION_NUMBER, (Object)number);
    }

    public int getPriestNumber() {
        return (Integer)this.entityData.get(PRIEST_NUMBER);
    }

    public void setPriestNumber(int number) {
        this.entityData.set(PRIEST_NUMBER, (Object)number);
    }

    public int getZealotNumber() {
        return (Integer)this.entityData.get(ZEALOT_NUMBER);
    }

    public void setZealotNumber(int number) {
        this.entityData.set(ZEALOT_NUMBER, (Object)number);
    }

    public int getBishopNumber() {
        return (Integer)this.entityData.get(BISHOP_NUMBER);
    }

    public void setBishopNumber(int number) {
        this.entityData.set(BISHOP_NUMBER, (Object)number);
    }

    public int getTemplarNumber() {
        return (Integer)this.entityData.get(TEMPLAR_NUMBER);
    }

    public void setTemplarNumber(int number) {
        this.entityData.set(TEMPLAR_NUMBER, (Object)number);
    }

    public int getSpecialMinionNumber() {
        return (Integer)this.entityData.get(SPECIAL_MINION_NUMBER);
    }

    public void setSpecialMinionNumber(int number) {
        this.entityData.set(SPECIAL_MINION_NUMBER, (Object)number);
    }

    public boolean canAttack() {
        return this.meleeTitan;
    }

    public boolean canAttack(LivingEntity target) {
        return this.canAttackEntity((Entity)target) && target.canBeSeenByAnyone();
    }

    public boolean canAttackType(EntityType<?> type) {
        return true;
    }

    public boolean canAttackEntity(Entity entity) {
        return entity != null;
    }

    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldMove() {
        if (this.getTarget() == null) return false;
        double d = this.distanceToSqr((Entity)this.getTarget());
        double d2 = this.getMeleeRange();
        double d3 = this.meleeTitan ? 0.0 : 10000.0;
        if (!(d > d2 + d3)) return false;
        return true;
    }

    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + 800.0;
    }

    public int getKnockbackAmount() {
        switch (this.getTitanStatus()) {
            case GOD: {
                return 24;
            }
            case GREATER: {
                return 16;
            }
            case AVERAGE: {
                return 8;
            }
        }
        return 4;
    }

    public int getFootID() {
        return this.footID;
    }

    public int getFootStepModifer() {
        return 2;
    }

    public boolean canRegen() {
        return true;
    }

    public int getRegenTime() {
        return 20;
    }

    public boolean isArmored() {
        return false;
    }

    public SimpleParticleType getParticles() {
        switch (this.getTitanStatus()) {
            case GOD: {
                return ParticleTypes.FIREWORK;
            }
            case GREATER: {
                return ParticleTypes.ENCHANTED_HIT;
            }
            case AVERAGE: {
                return ParticleTypes.CRIT;
            }
        }
        return ParticleTypes.ENCHANT;
    }

    public int getParticleCount() {
        return 6;
    }

    public int getMinionCap() {
        return 0;
    }

    public int getPriestCap() {
        return 0;
    }

    public int getZealotCap() {
        return 0;
    }

    public int getBishopCap() {
        return 0;
    }

    public int getTemplarCap() {
        return 0;
    }

    public int getSpecialMinionCap() {
        return 0;
    }

    public boolean canSpawnMinion() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonLoyalistSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public boolean canSpawnPriest() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonPriestSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public boolean canSpawnZealot() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonZealotSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public boolean canSpawnBishop() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonBishopSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public boolean canSpawnTemplar() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonTemplarSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public boolean canSpawnSpecialMinion() {
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return (double)randomRate < (Double)TheTitansNeoConfigs.titanSummonSpecialMinionSpawnRate.get() || this.getInvulTime() > 1 && this.tickCount % 20 == 0;
    }

    public int getThreashHold() {
        switch (this.getTitanStatus()) {
            case SIMPLE: {
                return 150;
            }
            case GREATER: {
                return 1310;
            }
            case GOD: {
                return 7100;
            }
        }
        return 850;
    }

    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION_ID, (Object)0);
        builder.define(ANIMATION_TICK, (Object)0);
        builder.define(ANTI_TITAN_ATTACK__ANIMATION_ID, (Object)0);
        builder.define(EXTRAPOWER, (Object)0);
        builder.define(INVULTIME, (Object)0);
        builder.define(WAITING, (Object)false);
        builder.define(TITAN_HEALTH, (Object)Float.valueOf(1.0f));
        builder.define(ANIMATED_TITAN_HEALTH, (Object)Float.valueOf(1.0f));
        builder.define(MINION_NUMBER, (Object)0);
        builder.define(PRIEST_NUMBER, (Object)0);
        builder.define(ZEALOT_NUMBER, (Object)0);
        builder.define(BISHOP_NUMBER, (Object)0);
        builder.define(TEMPLAR_NUMBER, (Object)0);
        builder.define(SPECIAL_MINION_NUMBER, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setAnimationID(tag.getInt("AnimationID"));
        this.setAnimationTick(tag.getInt("AnimationTick"));
        this.setAntiTitanAttackAnimationID(tag.getInt("AntiTitanAttackAnimationID"));
        this.setExtraPower(tag.getInt("ExtraPower"));
        this.setInvulTime(tag.getInt("InvulTime"));
        this.setWaiting(tag.getBoolean("Waiting"));
        if (tag.contains("TitanHealth", 5)) {
            this.setTitanHealth(tag.getFloat("TitanHealth"));
        }
        this.setMinionNumber(tag.getInt("MinionNumber"));
        this.setPriestNumber(tag.getInt("PriestNumber"));
        this.setZealotNumber(tag.getInt("ZealotNumber"));
        this.setBishopNumber(tag.getInt("BishopNumber"));
        this.setTemplarNumber(tag.getInt("TemplarNumber"));
        this.setSpecialMinionNumber(tag.getInt("SpecialMinionNumber"));
        this.deathTicks = tag.getInt("DeathTicks");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("AnimationID", this.getAnimationID());
        tag.putInt("AnimationTick", this.getAnimationTick());
        tag.putInt("AntiTitanAttackAnimationID", this.getAntiTitanAttackAnimationID());
        tag.putInt("ExtraPower", this.getExtraPower());
        tag.putInt("InvulTime", this.getInvulTime());
        tag.putBoolean("Waiting", this.getWaiting());
        tag.putFloat("TitanHealth", this.getTitanHealth());
        tag.putInt("MinionNumber", this.getMinionNumber());
        tag.putInt("PriestNumber", this.getPriestNumber());
        tag.putInt("ZealotNumber", this.getZealotNumber());
        tag.putInt("BishopNumber", this.getBishopNumber());
        tag.putInt("TemplarNumber", this.getTemplarNumber());
        tag.putInt("SpecialMinionNumber", this.getSpecialMinionNumber());
        tag.putInt("DeathTicks", this.deathTicks);
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isInvulnerable() {
        return this.getInvulTime() >= 1 || this.getWaiting() || this.getAnimationID() == 13 || this.deathTicks > 0 || super.isInvulnerable();
    }

    public boolean addEffect(MobEffectInstance mobEffectInstance, Entity entity) {
        return false;
    }

    public boolean addTitanEffect(MobEffectInstance mobEffectInstance, Entity entity) {
        return super.addEffect(mobEffectInstance, entity);
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        return this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    protected float getSoundVolume() {
        return 100.0f;
    }

    public boolean isDeadOrDying() {
        return this.getTitanHealth() <= 0.0f;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public float getSpeed() {
        return 0.3f + (float)this.getExtraPower() * 0.001f;
    }

    public float getScale() {
        return 1.0f;
    }

    protected void tickDeath() {
        this.deathTime = 0;
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this || !this.canAttackEntity((Entity)target)) {
            return;
        }
        if (target instanceof EntityTitan && (this.level().dimension() == TheTitansNeoDimensions.THE_VOID || ((EntityTitan)target).getInvulTime() > 0 || ((EntityTitan)target).getWaiting() || ((EntityTitan)target).getAnimationID() == 13) && !(target instanceof EntityWitherzilla)) {
            super.setTarget(null);
            return;
        }
        super.setTarget(target);
    }

    public void heal(float healAmount) {
        if (healAmount <= 0.0f) {
            return;
        }
        float f = this.getTitanHealth();
        if (f > 0.0f) {
            this.setTitanHealth(Math.min(f + healAmount, this.getMaxHealth()));
        }
    }

    public void updateFluidHeightAndDoFluidPushing() {
    }

    public void knockback(double strength, double x, double z) {
    }

    public void push(Vec3 vector) {
    }

    public void push(double x, double y, double z) {
    }

    public void push(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(entity == null || !this.isAlive() || this.getWaiting() || this.getAnimationID() == 13 || !this.canAttackEntity(entity) || this.hasPassenger(entity) || this.getVehicle() == entity || entity instanceof EntityTitanPart || entity instanceof IEntityProjectileTitan || entity instanceof EntityExperienceOrbTitan || entity instanceof EntityItemTitan || !((d2 = Mth.absMax((double)(d0 = entity.getX() - this.getX()), (double)(d1 = entity.getZ() - this.getZ()))) >= (double)0.01f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= 0.25;
            d1 *= 0.25;
            if (entity.getBbHeight() >= 6.0f || entity instanceof EntityTitan) {
                this.setTitanDeltaMovement(this.getDeltaMovement().add(-d0, 0.0, -d1));
            }
            entity.push(d0 *= 4.0, 0.75, d1 *= 4.0);
        }
    }

    protected void pushEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1, 0.1, 0.1));
        if (!this.getWaiting() && this.getAnimationID() != 13) {
            for (Entity entity : entities) {
                if (!this.isAlive() || !entity.isAlive() || !entity.isPushable() && !(entity instanceof EntityTitan) && (!(entity instanceof Projectile) || ((Projectile)entity).getOwner() == this) || !(entity.getBbHeight() > 6.0f) || entity instanceof Player) continue;
                this.doPush(entity);
            }
        }
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 2.0f);
        this.setTitanDeltaMovement(this.getDeltaMovement().add(0.0, 2.0, 0.0));
    }

    protected void jumpAtEntity(LivingEntity entity) {
        this.setTitanDeltaMovement(this.getDeltaMovement().add(0.0, 1.25, 0.0));
        this.setPos(this.getX(), this.getY() + (double)1.55f, this.getZ());
        double d1 = entity.getX() - this.getX();
        double d2 = entity.getZ() - this.getZ();
        float d = (float)Math.atan2(d2, d1);
        float f2 = (float)((double)d * 180.0 / Math.PI) - 90.0f;
        this.setYRot(f2);
        d1 = Math.sqrt(d1 * d1 + d2 * d2);
        this.setTitanDeltaMovement(0.0, 0.0, 0.0);
        this.setTitanDeltaMovement(d1 * 0.05 * Math.cos(d) + this.getDeltaMovement().x, this.getDeltaMovement().y, d1 * 0.05 * Math.sin(d) + this.getDeltaMovement().z);
        this.hasImpulse = true;
    }

    public void addDeltaMovement(Vec3 addend) {
        this.setTitanDeltaMovement(this.getDeltaMovement().add(addend));
    }

    public void setTitanDeltaMovement(Vec3 deltaMovement) {
        super.setDeltaMovement(deltaMovement);
    }

    public void setTitanDeltaMovement(double x, double y, double z) {
        this.setTitanDeltaMovement(new Vec3(x, y, z));
    }

    public void remove(Entity.RemovalReason reason) {
    }

    public void removeTitan(Entity.RemovalReason reason) {
        if (this.getTitanHealth() > 0.0f && this.deathTicks <= 0) {
            return;
        }
        super.remove(reason);
    }

    public void move(MoverType type, Vec3 pos) {
        if (this.noPhysics) {
            this.setPos(this.getX() + pos.x, this.getY() + pos.y, this.getZ() + pos.z);
        } else {
            Vec3 vec3;
            double d0;
            this.wasOnFire = this.isOnFire();
            if (type == MoverType.PISTON && (pos = this.limitPistonMovement(pos)).equals((Object)Vec3.ZERO)) {
                return;
            }
            this.level().getProfiler().push("move");
            if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                pos = pos.multiply(this.stuckSpeedMultiplier);
                this.stuckSpeedMultiplier = Vec3.ZERO;
                this.setDeltaMovement(Vec3.ZERO);
            }
            if ((d0 = (vec3 = this.collide(pos = this.maybeBackOffFromEdge(pos, type))).lengthSqr()) > 1.0E-7) {
                BlockHitResult blockhitresult;
                if (this.fallDistance != 0.0f && d0 >= 1.0 && (blockhitresult = this.level().clip(new ClipContext(this.position(), this.position().add(vec3), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).getType() != HitResult.Type.MISS) {
                    this.resetFallDistance();
                }
                this.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
            }
            this.level().getProfiler().pop();
            this.level().getProfiler().push("rest");
            boolean flag4 = !Mth.equal((double)pos.x, (double)vec3.x);
            boolean flag = !Mth.equal((double)pos.z, (double)vec3.z);
            this.horizontalCollision = flag4 || flag;
            this.verticalCollision = pos.y != vec3.y;
            this.verticalCollisionBelow = this.verticalCollision && pos.y < 0.0;
            this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3) : false;
            this.setOnGroundWithMovement(this.verticalCollisionBelow, vec3);
            BlockPos blockpos = this.getOnPosLegacy();
            BlockState blockstate = this.level().getBlockState(blockpos);
            this.checkFallDamage(vec3.y, this.onGround(), blockstate, blockpos);
            if (this.isRemoved()) {
                this.level().getProfiler().pop();
            } else {
                Entity.MovementEmission entity$movementemission;
                if (this.horizontalCollision) {
                    Vec3 vec31 = this.getDeltaMovement();
                    this.setDeltaMovement(flag4 ? 0.0 : vec31.x, vec31.y, flag ? 0.0 : vec31.z);
                }
                Block block = blockstate.getBlock();
                if (pos.y != vec3.y) {
                    block.updateEntityAfterFallOn((BlockGetter)this.level(), (Entity)this);
                }
                if (this.onGround()) {
                    block.stepOn(this.level(), blockpos, blockstate, (Entity)this);
                }
                if ((entity$movementemission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                    double d1 = vec3.x;
                    double d2 = vec3.y;
                    double d3 = vec3.z;
                    this.flyDist = (float)((double)this.flyDist + vec3.length() * 0.6);
                    BlockPos blockpos1 = this.getOnPos();
                    BlockState blockstate1 = this.level().getBlockState(blockpos1);
                    boolean flag1 = this.isStateClimbable(blockstate1);
                    if (!flag1) {
                        d2 = 0.0;
                    }
                    this.walkDist += (float)vec3.horizontalDistance() * 0.6f;
                    this.moveDist += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.moveDist > (float)this.nextStepDistanceTitan && !blockstate1.isAir()) {
                        boolean flag2 = blockpos1.equals((Object)blockpos);
                        boolean flag3 = this.vibrationAndSoundEffectsFromBlock(blockpos, blockstate, entity$movementemission.emitsSounds(), flag2, pos);
                        if (!flag2) {
                            flag3 |= this.vibrationAndSoundEffectsFromBlock(blockpos1, blockstate1, false, entity$movementemission.emitsEvents(), pos);
                        }
                        if (flag3) {
                            this.nextStepDistanceTitan = (int)this.moveDist + this.getFootStepModifer();
                        } else if (this.isInWater()) {
                            this.nextStepDistanceTitan = (int)this.moveDist + this.getFootStepModifer();
                            if (entity$movementemission.emitsSounds()) {
                                this.waterSwimSound();
                            }
                            if (entity$movementemission.emitsEvents()) {
                                this.gameEvent((Holder)GameEvent.SWIM);
                            }
                        }
                    } else if (blockstate1.isAir()) {
                        this.processFlappingMovement();
                    }
                } else if (this.isPassenger() || this.onGround()) {
                    this.nextStepDistanceTitan = this.getFootStepModifer();
                    this.walkDist = 0.0f;
                    this.moveDist = 0.0f;
                    this.footID = 0;
                }
                this.level().getProfiler().pop();
            }
        }
    }

    public void retractMinionNumFromType(EnumMinionType minionType) {
        switch (minionType) {
            case LOYALIST: {
                this.setMinionNumber(this.getMinionNumber() - 1);
                break;
            }
            case PRIEST: {
                this.setPriestNumber(this.getPriestNumber() - 1);
                break;
            }
            case ZEALOT: {
                this.setZealotNumber(this.getZealotNumber() - 1);
                break;
            }
            case BISHOP: {
                this.setBishopNumber(this.getBishopNumber() - 1);
                break;
            }
            case TEMPLAR: {
                this.setTemplarNumber(this.getTemplarNumber() - 1);
                break;
            }
            case SPECIAL: {
                this.setSpecialMinionNumber(this.getSpecialMinionNumber() - 1);
            }
        }
    }

    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
    }

    public void summomMinions() {
        ComponentContents componentContents = this.getName().getContents();
        if (componentContents instanceof TranslatableContents) {
            IMinion minion;
            Mob mob;
            double d2;
            double d1;
            double d0;
            Entity entity;
            Constructor<? extends Entity> constructor;
            Class<? extends Entity> clazz;
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            if (TheTitansNeoMinions.MINIONS.containsKey(translatableContents.getKey())) {
                try {
                    clazz = TheTitansNeoMinions.MINIONS.get(translatableContents.getKey());
                    if (this.getMinionNumber() < this.getMinionCap() && this.canSpawnMinion()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(0);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setMinionNumber(this.getMinionNumber() + 1);
                        }
                    }
                    if (this.getPriestNumber() < this.getPriestCap() && this.canSpawnPriest()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(1);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setPriestNumber(this.getPriestNumber() + 1);
                        }
                    }
                    if (this.getZealotNumber() < this.getZealotCap() && this.canSpawnZealot()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(2);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setZealotNumber(this.getZealotNumber() + 1);
                        }
                    }
                    if (this.getBishopNumber() < this.getBishopCap() && this.canSpawnBishop()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(3);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setBishopNumber(this.getBishopNumber() + 1);
                        }
                    }
                    if (this.getTemplarNumber() < this.getTemplarCap() && this.canSpawnTemplar()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(4);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setTemplarNumber(this.getTemplarNumber() + 1);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (TheTitansNeoMinions.SPECIAL_MINIONS.containsKey(translatableContents.getKey())) {
                try {
                    clazz = TheTitansNeoMinions.SPECIAL_MINIONS.get(translatableContents.getKey());
                    if (this.getSpecialMinionNumber() < this.getSpecialMinionCap() && this.canSpawnSpecialMinion()) {
                        constructor = clazz.getDeclaredConstructor(Level.class);
                        entity = constructor.newInstance(this.level());
                        d0 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        d1 = this.getY();
                        d2 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (72.0 + (double)this.getBbWidth());
                        if (entity instanceof Mob && entity instanceof IMinion) {
                            mob = (Mob)entity;
                            minion = (IMinion)entity;
                            mob.setPos(d0, d1, d2);
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(this);
                            minion.setMinionType(0);
                            this.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            mob.push(0.0, (double)mob.getBbHeight() / 4.0, 0.0);
                            this.level().addFreshEntity((Entity)mob);
                            mob.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SUMMON_MINION.get(), 10.0f, 0.5f);
                            this.setSpecialMinionNumber(this.getSpecialMinionNumber() + 1);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void grow() {
        if (this instanceof EntitySnowGolemTitan || this instanceof EntitySlimeTitan) {
            this.setInvulTime(150);
        } else {
            this.setInvulTime(this.getThreashHold());
        }
        this.setWaiting(false);
    }

    protected void refreshAttributes() {
    }

    protected void dropRateItem() {
    }

    protected void dropAllItem() {
    }

    protected void onDeath() {
        TranslatableContents translatableContents;
        ComponentContents componentContents;
        if (!this.level().isClientSide() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropRateItem();
            this.dropAllItem();
        }
        if ((componentContents = this.getName().getContents()) instanceof TranslatableContents && TheTitansNeoMinions.MINIONS.containsKey((translatableContents = (TranslatableContents)componentContents).getKey())) {
            EntityTitanSpirit titanSpirit = new EntityTitanSpirit(this.level(), translatableContents.getKey());
            titanSpirit.setPos(this.getX(), this.getY(), this.getZ());
            titanSpirit.setYRot(this.getYRot());
            titanSpirit.setVesselHunting(false);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)titanSpirit);
            }
        }
    }

    protected void tickTitanDeath() {
        ++this.deathTicks;
        if (this.deathTicks == 1) {
            this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
            if (!this.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                for (ServerPlayer serverPlayer : serverLevel.players()) {
                    ((TriggerTitanDeath)((Object)TheTitansNeoTriggers.TITAN_DEATH.get())).trigger(serverPlayer, (Entity)this);
                }
            }
        }
        if (this.deathTicks < this.getThreashHold() && !(this instanceof EntityWitherzilla)) {
            for (int i = 0; i < this.getParticleCount(); ++i) {
                if (this.shouldParticlesBeUpward) {
                    this.level().addParticle((ParticleOptions)this.getParticles(), this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.getRandom().nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.25, 0.0);
                    continue;
                }
                this.level().addParticle((ParticleOptions)this.getParticles(), this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.getRandom().nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        }
        this.setTitanDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        this.setTarget(null);
    }

    public void destroyBlocksInAABB(AABB aabb) {
        if (this.getWaiting() || aabb == null) {
            return;
        }
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int i1 = Mth.floor((double)aabb.maxY);
        int j1 = Mth.floor((double)aabb.maxZ);
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    Block block = blockState.getBlock();
                    if (this.level().isClientSide() || this.tickCount <= 5 || !this.level().hasChunkAt(blockPos) || blockState.isAir() || !(blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) >= 0.0f)) continue;
                    if (block instanceof LiquidBlock || block == Blocks.FIRE || block == Blocks.COBWEB) {
                        this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (this.getRandom().nextInt(3) == 0) {
                        FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)this.level(), (BlockPos)blockPos, (BlockState)blockState);
                        double d0 = (this.getBoundingBox().minX + this.getBoundingBox().maxX) / 2.0;
                        double d1 = (this.getBoundingBox().minZ + this.getBoundingBox().maxZ) / 2.0;
                        double d2 = fallingBlock.getX() - d0;
                        double d3 = fallingBlock.getZ() - d1;
                        double d4 = d2 * d2 + d3 * d3;
                        fallingBlock.setRemainingFireTicks(10);
                        fallingBlock.push(d2 / d4 * 10.0, 2.0 + this.getRandom().nextGaussian(), d3 / d4 * 10.0);
                        continue;
                    }
                    if (this.level().getNearestPlayer((Entity)this, 16.0) != null) {
                        this.level().destroyBlock(blockPos, true);
                        continue;
                    }
                    this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                    List blockDrops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)blockPos, null);
                    if (blockDrops.isEmpty()) continue;
                    for (ItemStack stack : blockDrops) {
                        ItemEntity itemEntity = new ItemEntity(this.level(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), stack);
                        itemEntity.setDefaultPickUpDelay();
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                }
            }
        }
    }

    public void destroyBlocksInAABBTopless(AABB aabb) {
        if (this.getWaiting() || aabb == null) {
            return;
        }
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int i1 = Mth.floor((double)aabb.maxY);
        int j1 = Mth.floor((double)aabb.maxZ);
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    Block block = blockState.getBlock();
                    if (this.tickCount <= 5 || this.level().isClientSide() || !this.level().hasChunkAt(blockPos) || blockState.isAir() || !this.level().isEmptyBlock(blockPos.above()) || !(blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) >= 0.0f)) continue;
                    if (block instanceof LiquidBlock || block == Blocks.FIRE || block == Blocks.COBWEB) {
                        this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (this.getRandom().nextInt(3) == 0) {
                        FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)this.level(), (BlockPos)blockPos, (BlockState)blockState);
                        double d0 = (this.getBoundingBox().minX + this.getBoundingBox().maxX) / 2.0;
                        double d1 = (this.getBoundingBox().minZ + this.getBoundingBox().maxZ) / 2.0;
                        double d2 = fallingBlock.getX() - d0;
                        double d3 = fallingBlock.getZ() - d1;
                        double d4 = d2 * d2 + d3 * d3;
                        fallingBlock.setRemainingFireTicks(10);
                        fallingBlock.push(d2 / d4 * 10.0, 2.0 + this.getRandom().nextGaussian(), d3 / d4 * 10.0);
                        continue;
                    }
                    if (this.level().getNearestPlayer((Entity)this, 16.0) != null) {
                        this.level().destroyBlock(blockPos, true);
                        continue;
                    }
                    this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                    List blockDrops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)blockPos, null);
                    if (blockDrops.isEmpty()) continue;
                    for (ItemStack stack : blockDrops) {
                        ItemEntity itemEntity = new ItemEntity(this.level(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), stack);
                        itemEntity.setDefaultPickUpDelay();
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                }
            }
        }
    }

    public boolean destroyBlocksInAABBGriefingBypass(AABB aabb) {
        if (this.getWaiting() || aabb == null) {
            return false;
        }
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int i1 = Mth.floor((double)aabb.maxY);
        int j1 = Mth.floor((double)aabb.maxZ);
        boolean flag = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    if (this.level().isClientSide() || blockState.isAir() || !(blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) >= 0.0f)) continue;
                    flag = this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState()) || flag;
                }
            }
        }
        return false;
    }

    public void destroyBlocksInAABBGriefingBypassAsync(AABB aabb) {
        if (this.getWaiting() || aabb == null) {
            return;
        }
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int i1 = Mth.floor((double)aabb.maxY);
        int j1 = Mth.floor((double)aabb.maxZ);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int l1 = i1; l1 > j; --l1) {
            for (int k1 = i; k1 <= l; ++k1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    if (blockState.isAir() || !(blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) >= 0.0f)) continue;
                    list.add(blockPos);
                }
            }
        }
        CompletableFuture.runAsync(() -> {
            for (int index = 0; index < list.size(); ++index) {
                BlockPos blockPos = (BlockPos)list.get(index);
                BlockState blockState = this.level().getBlockState(blockPos);
                if (this.level().isClientSide() || blockState.isAir() || !(blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) >= 0.0f)) continue;
                this.level().setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
            }
        });
    }

    public void collideWithEntities(EntityTitanPart part, List<Entity> entities) {
        if (this.getWaiting()) {
            return;
        }
        if (part != null && part.level() != null) {
            double d0 = (part.getBoundingBox().minX + part.getBoundingBox().maxX) / 2.0;
            double d1 = (part.getBoundingBox().minZ + part.getBoundingBox().maxZ) / 2.0;
            for (Entity entity : entities) {
                FishingHook fishingHook;
                boolean leg;
                boolean bl = leg = part.getPartName() == "rightleg" || part.getPartName() == "leftleg" || part.getPartName() == "leg1" || part.getPartName() == "leg2" || part.getPartName() == "leg3" || part.getPartName() == "leg4";
                if (entity == null || !this.canAttackEntity(entity) || entity instanceof WitherSkull || entity instanceof IEntityProjectileTitan || entity instanceof EntityHarcadiumArrow || entity instanceof EntityExperienceOrbTitan || entity instanceof EntityItemTitan || entity instanceof EntityTitan || entity instanceof EntityTitanPart || entity instanceof EntityTitanSpirit) continue;
                double d2 = entity.getX() - d0;
                double d3 = entity.getZ() - d1;
                double d4 = d2 * d2 + d3 * d3;
                entity.push(d2 / d4 * (leg ? 5.0 : 1.5), leg ? 1.75 : 0.5, d3 / d4 * (leg ? 5.0 : 1.5));
                if (entity.getY() <= part.getY() - (double)part.getBbHeight() - 0.01) {
                    entity.hurt(this.damageSources().thorns((Entity)this), 20.0f);
                }
                if (entity instanceof LivingEntity && this instanceof EntitySkeletonTitan && ((EntitySkeletonTitan)this).getSkeletonType() == 1) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 1200, 3));
                }
                if (!(entity instanceof FishingHook) || (fishingHook = (FishingHook)entity).getHookedIn() == null || this.level().isClientSide()) continue;
                fishingHook.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void shakeNearbyPlayerCameras(double distance) {
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ServerChunkCache serverChunkCache = serverLevel.getChunkSource();
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(distance, distance, distance));
            for (Entity entity : entities) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || entity instanceof EntityTitan) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.animateHurt(180.0f);
                for (ServerPlayer player : serverLevel.players()) {
                    serverChunkCache.broadcastAndSend((Entity)player, (Packet)new ClientboundHurtAnimationPacket(livingEntity));
                }
            }
        }
    }

    public void addDayTime(long maxDayTime, long addTime) {
        if (this.getWaiting()) {
            return;
        }
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ServerChunkCache serverChunkCache = serverLevel.getChunkSource();
            if (serverLevel.getDayTime() < maxDayTime) {
                serverLevel.setDayTime(serverLevel.getDayTime() + 50L);
            }
            for (ServerPlayer player : serverLevel.players()) {
                serverChunkCache.broadcastAndSend((Entity)player, (Packet)new ClientboundSetTimePacket(serverLevel.getGameTime(), serverLevel.getDayTime(), serverLevel.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
            }
        }
    }

    public void removeEntity(Entity entity) {
        if (entity.getBbHeight() >= 6.0f) {
            for (int i = 0; i < 1000; ++i) {
                float f = (this.getRandom().nextFloat() - 0.5f) * entity.getBbWidth();
                float f1 = (this.getRandom().nextFloat() - 0.5f) * entity.getBbHeight();
                float f2 = (this.getRandom().nextFloat() - 0.5f) * entity.getBbWidth();
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, this.getRandom().nextDouble() - 0.5, 0.0, this.getRandom().nextDouble() - 0.5);
            }
        }
        if (!entity.level().isClientSide()) {
            entity.level().broadcastEntityEvent(entity, (byte)60);
            entity.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void attackEntity(LivingEntity entity, float amount) {
        if (entity instanceof EntityEnderColossusCrystal) {
            return;
        }
        DamageSourceTitanAttack damageSource = new DamageSourceTitanAttack((Entity)this);
        if (entity instanceof Player) {
            double titanResistance;
            Player player = (Player)entity;
            if ((ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.ULTIMA_BLADE.get()) || ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.OPTIMA_AXE.get())) && amount <= 2000.0f) {
                amount = 1.0f;
            }
            if ((titanResistance = player.getAttributeValue(TheTitansNeoAttributes.TITAN_RESISTANCE)) > 0.0) {
                amount = (float)((double)amount - Math.min((double)amount * (titanResistance / 100.0), (double)amount));
            }
            for (ItemStack itemStack : player.getArmorSlots()) {
                if (itemStack.isEmpty() || !itemStack.isDamaged()) continue;
                itemStack.setDamageValue(itemStack.getDamageValue() + (int)amount);
            }
        }
        if (entity instanceof EntityTitan) {
            EntityTitan titan = (EntityTitan)entity;
            if (titan.getInvulTime() <= 0) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                titan.hurt(damageSource, amount);
            }
        } else {
            float health = entity.getHealth();
            entity.hurt((DamageSource)damageSource, amount);
            if (entity.getHealth() > Math.max(health - amount, 0.0f)) {
                entity.setHealth(Math.max(health - amount, 0.0f));
            }
            if (entity.getHealth() <= 0.0f || health - amount <= 0.0f) {
                if (!(entity instanceof Player)) {
                    entity.getAttribute(Attributes.MAX_HEALTH).setBaseValue(0.0);
                }
                entity.setAbsorptionAmount(0.0f);
                entity.setHealth(0.0f);
                entity.die((DamageSource)damageSource);
            }
            if ((entity.getHealth() > 0.0f && health - amount <= 0.0f && entity.getMaxHealth() <= 1.0f || entity.deathTime >= 20) && !(entity instanceof Player)) {
                this.removeEntity((Entity)entity);
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return groupData;
    }

    public void handleDamageEvent(DamageSource damageSource) {
        super.handleDamageEvent(damageSource);
        this.invulnerableTicks = 30;
    }

    public boolean baseHurt(DamageSource damageSource, float amount) {
        boolean flag2;
        LivingShieldBlockEvent ev;
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (damageSource.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        this.damageContainers.push(new DamageContainer(damageSource, amount));
        if (CommonHooks.onEntityIncomingDamage((LivingEntity)this, (DamageContainer)((DamageContainer)this.damageContainers.peek()))) {
            return false;
        }
        if (this.isSleeping() && !this.level().isClientSide()) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        amount = ((DamageContainer)this.damageContainers.peek()).getNewDamage();
        boolean flag = false;
        if (amount > 0.0f && (ev = CommonHooks.onDamageBlock((LivingEntity)this, (DamageContainer)((DamageContainer)this.damageContainers.peek()), (boolean)this.isDamageSourceBlocked(damageSource))).getBlocked()) {
            Entity entity;
            ((DamageContainer)this.damageContainers.peek()).setBlockedDamage(ev);
            if (ev.shieldDamage() > 0.0f) {
                this.hurtCurrentlyUsedShield(ev.shieldDamage());
            }
            amount = ev.getDamageContainer().getNewDamage();
            if (!damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.blockUsingShield(livingentity);
            }
            boolean bl = flag = amount <= 0.0f;
        }
        if (damageSource.is(DamageTypeTags.IS_FREEZING) && this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
            amount *= 5.0f;
        }
        if (damageSource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.hurtHelmet(damageSource, amount);
            amount *= 0.75f;
        }
        ((DamageContainer)this.damageContainers.peek()).setNewDamage(amount);
        this.walkAnimation.setSpeed(1.5f);
        boolean flag1 = true;
        if (this.invulnerableTicks > 10 && !damageSource.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (amount <= this.lastHurt) {
                this.damageContainers.pop();
                return false;
            }
            this.actuallyHurt(damageSource, amount - this.lastHurt);
            this.lastHurt = amount;
            flag1 = false;
        } else {
            this.lastHurt = amount;
            this.invulnerableTicks = ((DamageContainer)this.damageContainers.peek()).getPostAttackInvulnerabilityTicks();
            this.actuallyHurt(damageSource, amount);
            this.hurtTime = this.hurtDuration = 10;
        }
        amount = ((DamageContainer)this.damageContainers.peek()).getNewDamage();
        Entity entity = damageSource.getEntity();
        if (entity != null) {
            TamableAnimal tamableAnimal;
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (!(damageSource.is(DamageTypeTags.NO_ANGER) || damageSource.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                    this.setLastHurtByMob(livingentity1);
                }
            }
            if (entity instanceof Player) {
                Player player1 = (Player)entity;
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = player1;
            } else if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
                Player player;
                this.lastHurtByPlayerTime = 100;
                LivingEntity livingEntity = tamableAnimal.getOwner();
                this.lastHurtByPlayer = livingEntity instanceof Player ? (player = (Player)livingEntity) : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level().broadcastEntityEvent((Entity)this, (byte)29);
            } else {
                this.level().broadcastDamageEvent((Entity)this, damageSource);
            }
            if (!(damageSource.is(DamageTypeTags.NO_IMPACT) || flag && !(amount > 0.0f))) {
                this.markHurt();
            }
            if (!damageSource.is(DamageTypeTags.NO_KNOCKBACK)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity2 = damageSource.getDirectEntity();
                if (entity2 instanceof Projectile) {
                    Projectile projectile = (Projectile)entity2;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = projectile.calculateHorizontalHurtKnockbackDirection((LivingEntity)this, damageSource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damageSource.getSourcePosition() != null) {
                    d0 = damageSource.getSourcePosition().x() - this.getX();
                    d1 = damageSource.getSourcePosition().z() - this.getZ();
                }
                this.knockback(0.4f, d0, d1);
                if (!flag) {
                    this.indicateDamage(d0, d1);
                }
            }
        }
        if (!this.isDeadOrDying() && flag1) {
            this.playHurtSound(damageSource);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.lastDamageSource = damageSource;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance mobeffectinstance : this.getActiveEffects()) {
                mobeffectinstance.onMobHurt((LivingEntity)this, damageSource, amount);
            }
        }
        this.damageContainers.pop();
        return flag2;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (!(damageSource instanceof DamageSourceTitanAttack) && amount > 1000.0f) {
            amount = 1000.0f;
        }
        if (entity == null || this.isInvulnerable() || amount <= 20.0f) {
            return false;
        }
        if (damageSource.is(DamageTypes.MAGIC) || damageSource.is(DamageTypes.INDIRECT_MAGIC) || damageSource.is(DamageTypes.EXPLOSION) || damageSource.is(DamageTypes.PLAYER_EXPLOSION) || damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE) || damageSource.is(DamageTypes.LAVA) || damageSource.is(DamageTypes.IN_WALL) || damageSource.is(DamageTypes.DROWN) || damageSource.is(DamageTypes.STARVE) || damageSource.is(DamageTypes.CACTUS) || damageSource.is(DamageTypes.FALL) || damageSource.is(DamageTypes.GENERIC) || damageSource.is(DamageTypes.FELL_OUT_OF_WORLD) || damageSource.is(DamageTypes.WITHER) || damageSource.is(DamageTypes.FALLING_BLOCK) || damageSource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (entity instanceof Player && !this.canBeHurtByPlayer()) {
            return false;
        }
        if (this.baseHurt(damageSource, amount)) {
            if (entity != null && entity instanceof LivingEntity && this.getAnimationTick() <= 12) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.setTarget(livingEntity);
            }
            this.setTitanHealth(Math.max(this.getTitanHealth() - amount, 0.0f));
            return true;
        }
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        this.setOnGround(true);
        this.hasImpulse = false;
        if (fallDistance <= 0.0f) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.getEffect(MobEffects.JUMP);
        float f1 = mobEffectInstance != null ? (float)(mobEffectInstance.getAmplifier() + 1) : 0.0f;
        int i = Mth.ceil((float)(fallDistance - 24.0f - f1));
        if (i > 0) {
            this.shakeNearbyPlayerCameras(400000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_LAND.get(), 10000.0f, 1.0f);
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(48.0, 4.0, 48.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity) || entity instanceof EntityTitan) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                float smash = 50.0f - this.distanceTo((Entity)livingEntity);
                if (smash <= 1.0f) {
                    smash = 1.0f;
                }
                this.attackEntity(livingEntity, smash);
                double d0 = this.getBoundingBox().minX + this.getBoundingBox().maxX;
                double d1 = this.getBoundingBox().minZ + this.getBoundingBox().maxZ;
                double d2 = entity.getX() - d0;
                double d3 = entity.getZ() - d1;
                double d4 = d2 * d2 + d3 * d3;
                entity.push(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
            }
        }
        return super.causeFallDamage(fallDistance, multiplier, damageSource);
    }

    public void aiStep() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox());
        for (Entity entity : entities) {
            this.push(entity);
        }
        if (this.getRandom().nextInt(1000) == 0 && this.getHealth() < this.getMaxHealth() / 20.0f && this.deathTicks <= 0 || this.getHealth() < this.getMaxHealth() / 2.0f && this.deathTicks <= 0 && this.getTarget() != null && this.getTarget() instanceof EntityTitan && !this.isRejuvinating && ((EntityTitan)this.getTarget()).isRejuvinating && !(this instanceof EntitySlimeTitan) && !(this instanceof EntitySnowGolemTitan) && !(this instanceof EntityIronGolemTitan)) {
            this.isRejuvinating = true;
            if (!this.isSilent()) {
                this.level().globalLevelEvent(1023, this.blockPosition(), 0);
            }
            this.setExtraPower(this.getExtraPower() + 1);
            this.refreshAttributes();
            this.jumpFromGround();
        }
        if (this.isAlive() && this.isRejuvinating) {
            this.setTarget(null);
            this.setInvulTime(this.getInvulTime() + 5);
            this.animateHurt(180.0f);
            if (this.getInvulTime() > this.getThreashHold()) {
                this.isRejuvinating = false;
            }
        }
        if (this.getWaiting()) {
            this.setOnGround(true);
            this.setTitanDeltaMovement(0.0, 0.0, 0.0);
        } else if (this.getInvulTime() > 0) {
            this.setOnGround(true);
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                if (!(this instanceof EntitySnowGolemTitan || this instanceof EntityIronGolemTitan || this.level().isClientSide())) {
                    this.level().explode((Entity)this, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), this.getBbHeight(), false, Level.ExplosionInteraction.MOB);
                }
                this.destroyBlocksInAABB(this.getBoundingBox());
                if (this instanceof EntityZombieTitan && !((EntityZombieTitan)this).isArmed()) {
                    AnimationUtils.sendPacket(this, 2);
                }
            }
            this.setInvulTime(i);
            if (this.tickCount % 1 == 0) {
                if (this instanceof EntitySnowGolemTitan || this instanceof EntitySlimeTitan) {
                    this.heal(this.getMaxHealth() / 150.0f);
                } else {
                    this.heal(this.getMaxHealth() / (float)this.getThreashHold());
                }
            }
        } else {
            super.aiStep();
            if (this.canRegen()) {
                float healAmount = 0.0f;
                healAmount = this.getTitanStatus() == EnumTitanStatus.AVERAGE ? 3.0f : (this.getTitanStatus() == EnumTitanStatus.GREATER ? 6.0f : (this.getTitanStatus() == EnumTitanStatus.GOD ? 20.0f : 1.0f));
                if ((this instanceof EntityZombieTitan || this instanceof EntitySkeletonTitan) && this.level().isDay()) {
                    healAmount /= 3.0f;
                }
                if (this instanceof EntitySnowGolemTitan || this instanceof EntityIronGolemTitan) {
                    healAmount = 0.1f;
                }
                for (int i = 0; i < 2 + this.getRandom().nextInt(10); ++i) {
                    this.heal(healAmount);
                }
            }
        }
    }

    public void tick() {
        int i;
        if (this.getAnimationID() == 13 && this.getAnimationTick() == 4 && this.level().getNearestPlayer((Entity)this, 32.0) != null) {
            this.getLookControl().setLookAt((Entity)this.level().getNearestPlayer((Entity)this, 32.0), 180.0f, 0.0f);
        }
        if (this.getAnimationID() == 0) {
            this.setAnimationTick(0);
            if (!(this instanceof EntityGhastTitan) && !(this instanceof EntityWitherzilla) && this.getTarget() != null) {
                this.getLookControl().setLookAt((Entity)this.getTarget(), 5.0f, (float)this.getMaxHeadXRot());
            }
        } else if (!(this instanceof EntityGhastTitan) && !(this instanceof EntityWitherzilla)) {
            if (this.getAnimationID() != 13) {
                this.setYRot(this.yHeadRot);
                this.yBodyRot = this.yHeadRot;
            } else {
                this.yHeadRot = this.getYRot();
            }
        }
        if (!this.getWaiting() && this.getAnimationID() != 0 && this.deathTicks < this.getThreashHold()) {
            int animationTick = 1;
            if (this.isBaby()) {
                ++animationTick;
            }
            if (this.isArmored()) {
                ++animationTick;
            }
            if (animationTick <= 1 || this.deathTicks > 0) {
                this.setAnimationTick(this.getAnimationTick() + 1);
            } else {
                for (i = 0; i < animationTick; ++i) {
                    this.setAnimationTick(this.getAnimationTick() + 1);
                }
            }
        }
        if (this.shouldMove() && this.getAnimationID() == 0 && this.getTarget() != null) {
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getZ() - this.getZ();
            float f2 = (float)Math.sqrt(d0 * d0 + d1 * d1);
            this.setYRot(this.yHeadRot);
            this.yBodyRot = this.yHeadRot;
            this.setTitanDeltaMovement(d0 / (double)f2 * (double)this.getSpeed() * (double)this.getSpeed() + this.getDeltaMovement().x, this.getDeltaMovement().y, d1 / (double)f2 * (double)this.getSpeed() * (double)this.getSpeed() + this.getDeltaMovement().z);
        }
        if (this.invulnerableTicks > 0) {
            --this.invulnerableTicks;
        }
        if (this.getTitanHealth() <= 0.0f) {
            this.setTitanHealth(0.0f);
            this.tickTitanDeath();
        } else {
            this.deathTicks = 0;
            if (this.getAnimationID() == 10) {
                AnimationUtils.sendPacket(this, 0);
            }
        }
        if (this.getY() <= -64.0) {
            this.setPos(this.getX(), -64.0, this.getZ());
            this.setOnGround(true);
            this.hasImpulse = false;
            this.fallDistance = 0.0f;
            if (this.getDeltaMovement().y < 0.0) {
                this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
            }
        }
        if (this.onGround() && this.getDeltaMovement().x != 0.0 && this.getDeltaMovement().z != 0.0) {
            for (int u = 0; u < 30; ++u) {
                i = Mth.floor((double)this.getX());
                int j = Mth.floor((double)(this.getY() - (double)0.2f));
                int k = Mth.floor((double)this.getZ());
                BlockPos blockPos = new BlockPos(i, j, k);
                BlockState blockState = this.level().getBlockState(blockPos);
                if (blockState.isAir()) continue;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), this.getBoundingBox().minY + 0.1, this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.getRandom().nextFloat() - 0.5), 0.5, ((double)this.getRandom().nextFloat() - 0.5) * 4.0);
            }
        }
        if (this.isAlive() && !this.getWaiting() && this.getAnimationID() != 13 && !this.level().isClientSide() && this.level().getDifficulty() != Difficulty.PEACEFUL) {
            if (!(this instanceof EntityWitherzilla)) {
                if (this.level().dimension() != TheTitansNeoDimensions.THE_VOID) {
                    this.summomMinions();
                }
            } else {
                this.summomMinions();
            }
        }
        if (this.getTitanHealth() >= this.getMaxHealth()) {
            this.refreshAttributes();
            this.setTitanHealth(this.getMaxHealth());
        }
        if (this.goalSelector.getAvailableGoals().isEmpty() || this.targetSelector.getAvailableGoals().isEmpty()) {
            this.registerGoals();
        }
        this.setHealth(this.getTitanHealth());
        this.updateAnimatedHealth(this.getTitanHealth(), this.getMaxHealth());
        super.tick();
    }
}

