/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.List;
import net.byAqua3.thetitansneo.entity.EntityFlying;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityBlazeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityCaveSpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityCreeperTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossusCrystal;
import net.byAqua3.thetitansneo.entity.titan.EntityGhastTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityOmegafish;
import net.byAqua3.thetitansneo.entity.titan.EntityPigZombieTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDamageTypes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMinions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityTitanSpirit
extends EntityFlying {
    private static final EntityDataAccessor<String> SPIRIT_NAME = SynchedEntityData.defineId(EntityTitanSpirit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> SOUL = SynchedEntityData.defineId(EntityTitanSpirit.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public boolean isSearchingForVessel = true;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public int ambientSoundTime;

    public EntityTitanSpirit(EntityType<? extends EntityFlying> entityType, Level level) {
        super(entityType, level);
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 10000.0f, 2.0f);
    }

    public EntityTitanSpirit(Level level, String spiritName) {
        this((EntityType<? extends EntityFlying>)((EntityType)TheTitansNeoEntities.TITAN_SPIRIT.get()), level);
        this.setSpiritName(spiritName);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 3.4028234663852886E38);
    }

    public String getSpiritName() {
        return (String)this.entityData.get(SPIRIT_NAME);
    }

    public void setSpiritName(String name) {
        this.entityData.set(SPIRIT_NAME, (Object)name);
    }

    public float getSoul() {
        return ((Float)this.entityData.get(SOUL)).floatValue();
    }

    public void setSoul(float soul) {
        this.entityData.set(SOUL, (Object)Float.valueOf(soul));
    }

    public float getMaxSoul() {
        switch (this.getSpiritName()) {
            case "entity.thetitansneo.omegafish": {
                return 8000.0f;
            }
            case "entity.thetitansneo.zombie_titan": {
                return 20000.0f;
            }
            case "entity.thetitansneo.zombie_baby_titan": {
                return 10000.0f;
            }
            case "entity.thetitansneo.zombie_villager_titan": {
                return 20000.0f;
            }
            case "entity.thetitansneo.zombie_villager_baby_titan": {
                return 10000.0f;
            }
            case "entity.thetitansneo.skeleton_titan": {
                return 20000.0f;
            }
            case "entity.thetitansneo.wither_skeleton_titan": {
                return 100000.0f;
            }
            case "entity.thetitansneo.creeper_titan": {
                return 25000.0f;
            }
            case "entity.thetitansneo.charged_creeper_titan": {
                return 50000.0f;
            }
            case "entity.thetitansneo.spider_titan": {
                return 16000.0f;
            }
            case "entity.thetitansneo.cave_spider_titan": {
                return 12000.0f;
            }
            case "entity.thetitansneo.pig_zombie_titan": {
                return 20000.0f;
            }
            case "entity.thetitansneo.pig_zombie_baby_titan": {
                return 10000.0f;
            }
            case "entity.thetitansneo.blaze_titan": {
                return 40000.0f;
            }
            case "entity.thetitansneo.ender_colossus": {
                return 150000.0f;
            }
            case "entity.thetitansneo.ghast_titan": {
                return 200000.0f;
            }
            case "entity.thetitansneo.witherzilla": {
                return 1.0E7f;
            }
        }
        return 1.0f;
    }

    public boolean isVesselHunting() {
        return this.isSearchingForVessel;
    }

    public void setVesselHunting(boolean isSearchingForVessel) {
        this.isSearchingForVessel = isSearchingForVessel;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPIRIT_NAME, (Object)"");
        builder.define(SOUL, (Object)Float.valueOf(1.0f));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("SpiritName", 8)) {
            this.setSpiritName(tag.getString("SpiritName"));
        }
        if (tag.contains("Soul", 5)) {
            this.setSoul(tag.getFloat("Soul"));
        }
        if (tag.contains("IsVesselHunting", 1)) {
            this.setVesselHunting(tag.getBoolean("IsVesselHunting"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("SpiritName", this.getSpiritName());
        tag.putFloat("Soul", this.getSoul());
        tag.putBoolean("IsVesselHunting", this.isVesselHunting());
    }

    public boolean transformTitan() {
        if (!this.level().isClientSide()) {
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.omegafish")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 18.0f, true, Level.ExplosionInteraction.MOB);
                EntityOmegafish omegafish = new EntityOmegafish(this.level());
                omegafish.setPos(this.getX(), this.getY(), this.getZ());
                omegafish.setYRot(this.getYRot());
                omegafish.grow();
                this.discard();
                this.level().addFreshEntity((Entity)omegafish);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.zombie_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.zombie_baby_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.zombie_villager_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.zombie_villager_baby_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 18.0f, true, Level.ExplosionInteraction.MOB);
                EntityZombieTitan zombieTitan = new EntityZombieTitan(this.level());
                zombieTitan.setPos(this.getX(), this.getY(), this.getZ());
                zombieTitan.setYRot(this.getYRot());
                zombieTitan.setBaby(this.getSpiritName().contains("baby"));
                zombieTitan.setVillager(this.getSpiritName().contains("villager"));
                zombieTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)zombieTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.skeleton_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.wither_skeleton_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 18.0f, true, Level.ExplosionInteraction.MOB);
                EntitySkeletonTitan skeletonTitan = new EntitySkeletonTitan(this.level());
                skeletonTitan.setPos(this.getX(), this.getY(), this.getZ());
                skeletonTitan.setYRot(this.getYRot());
                skeletonTitan.setSkeletonType(this.getSpiritName().contains("wither") ? 1 : 0);
                skeletonTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)skeletonTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.creeper_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.charged_creeper_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 18.0f, true, Level.ExplosionInteraction.MOB);
                EntityCreeperTitan creeperTitan = new EntityCreeperTitan(this.level());
                creeperTitan.setPos(this.getX(), this.getY(), this.getZ());
                creeperTitan.setYRot(this.getYRot());
                creeperTitan.setCharged(this.getSpiritName().contains("charged"));
                creeperTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)creeperTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.spider_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 12.0f, true, Level.ExplosionInteraction.MOB);
                EntitySpiderTitan spiderTitan = new EntitySpiderTitan(this.level());
                spiderTitan.setPos(this.getX(), this.getY(), this.getZ());
                spiderTitan.setYRot(this.getYRot());
                spiderTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)spiderTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.cave_spider_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 12.0f, true, Level.ExplosionInteraction.MOB);
                EntityCaveSpiderTitan caveSpiderTitan = new EntityCaveSpiderTitan(this.level());
                caveSpiderTitan.setPos(this.getX(), this.getY(), this.getZ());
                caveSpiderTitan.setYRot(this.getYRot());
                caveSpiderTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)caveSpiderTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.pig_zombie_titan") || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.pig_zombie_baby_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 18.0f, true, Level.ExplosionInteraction.MOB);
                EntityPigZombieTitan pigZombieTitan = new EntityPigZombieTitan(this.level());
                pigZombieTitan.setPos(this.getX(), this.getY(), this.getZ());
                pigZombieTitan.setYRot(this.getYRot());
                pigZombieTitan.setBaby(this.getSpiritName().contains("baby"));
                pigZombieTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)pigZombieTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.blaze_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 16.0f, true, Level.ExplosionInteraction.MOB);
                EntityBlazeTitan blazeTitan = new EntityBlazeTitan(this.level());
                blazeTitan.setPos(this.getX(), this.getY(), this.getZ());
                blazeTitan.setYRot(this.getYRot());
                blazeTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)blazeTitan);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.ender_colossus")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 45.0f, true, Level.ExplosionInteraction.MOB);
                EntityEnderColossus enderColossus = new EntityEnderColossus(this.level());
                enderColossus.setPos(this.getX(), this.getY(), this.getZ());
                enderColossus.setYRot(this.getYRot());
                enderColossus.grow();
                this.discard();
                this.level().addFreshEntity((Entity)enderColossus);
                return true;
            }
            if (this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.ghast_titan")) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 8.0f, true, Level.ExplosionInteraction.MOB);
                EntityGhastTitan ghastTitan = new EntityGhastTitan(this.level());
                ghastTitan.setPos(this.getX(), this.getY(), this.getZ());
                ghastTitan.setYRot(this.getYRot());
                ghastTitan.grow();
                this.discard();
                this.level().addFreshEntity((Entity)ghastTitan);
                return true;
            }
        }
        return false;
    }

    public boolean transformTitan(Entity entity) {
        IMinion minion;
        if (!this.level().isClientSide() && entity.getClass() == TheTitansNeoMinions.MINIONS.get(this.getSpiritName()) && entity instanceof IMinion && (minion = (IMinion)entity).getMinionType() == EnumMinionType.TEMPLAR) {
            entity.discard();
            return this.transformTitan();
        }
        return false;
    }

    public Component getName() {
        return Component.translatable((String)this.getSpiritName());
    }

    protected SoundEvent getAmbientSound() {
        switch (this.getSpiritName()) {
            case "entity.thetitansneo.omegafish": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_SILVERFISH_LIVING.get();
            }
            case "entity.thetitansneo.zombie_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.zombie_baby_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.zombie_villager_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.zombie_villager_baby_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.skeleton_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_LIVING.get();
            }
            case "entity.thetitansneo.wither_skeleton_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_WITHER_SKELETON_LIVING.get();
            }
            case "entity.thetitansneo.creeper_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_LIVING.get();
            }
            case "entity.thetitansneo.charged_creeper_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_CREEPER_LIVING.get();
            }
            case "entity.thetitansneo.spider_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_LIVING.get();
            }
            case "entity.thetitansneo.cave_spider_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_LIVING.get();
            }
            case "entity.thetitansneo.pig_zombie_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_PIG_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.pig_zombie_baby_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_PIG_ZOMBIE_LIVING.get();
            }
            case "entity.thetitansneo.blaze_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_BLAZE_BREATHE.get();
            }
            case "entity.thetitansneo.ender_colossus": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_LIVING.get();
            }
            case "entity.thetitansneo.ghast_titan": {
                return (SoundEvent)TheTitansNeoSounds.TITAN_GHAST_LIVING.get();
            }
            case "entity.thetitansneo.witherzilla": {
                return (SoundEvent)TheTitansNeoSounds.WITHERZILLA_LIVING.get();
            }
        }
        return SoundEvents.WITHER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    protected void playHurtSound(DamageSource damageSource) {
        this.resetAmbientSoundTime();
        super.playHurtSound(damageSource);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isAttackable() {
        return false;
    }

    protected void serverAiStep() {
        block14: {
            block13: {
                super.serverAiStep();
                if (this.waypointY <= 0.0) {
                    this.waypointY = 0.0;
                }
                if (this.waypointY > 255.0) {
                    this.waypointY = 255.0;
                }
                if (this.isVesselHunting() && this.tickCount % 20 == 0 && this.getRandom().nextInt(5) == 0) {
                    Player player = this.level().getNearestPlayer((Entity)this, 256.0);
                    if (player != null) {
                        this.waypointX = player.getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        this.waypointY = player.getY() + 32.0 + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 16.0f);
                        this.waypointZ = player.getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f);
                    } else {
                        this.waypointX = this.getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        this.waypointY = this.getY() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        this.waypointZ = this.getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 32.0f);
                    }
                }
                double d0 = this.waypointX - this.getX();
                double d1 = this.waypointY - this.getY();
                double d2 = this.waypointZ - this.getZ();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = Math.sqrt(d3);
                if (this.isVesselHunting() && this.distanceToSqr(this.waypointX, this.waypointY, this.waypointZ) > 40000.0) {
                    this.waypointX = this.getX();
                    this.waypointY = this.getY();
                    this.waypointZ = this.getZ();
                }
                if (this.distanceToSqr(this.waypointX, this.waypointY, this.waypointZ) > 4.0) {
                    this.push(d0 / d3 * 0.15, d1 / d3 * 0.15, d2 / d3 * 0.15);
                }
                if (this.isVesselHunting()) break block13;
                this.waypointX = this.getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 128.0f);
                this.waypointY = 255.0;
                this.waypointZ = this.getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 128.0f);
                if (!(this.getY() >= 254.0)) break block14;
                this.setVesselHunting(true);
                if (this.getRandom().nextInt(2) == 0 || this.getSpiritName().equalsIgnoreCase("entity.thetitansneo.witherzilla")) {
                    if (!this.isSilent()) {
                        this.level().globalLevelEvent(1023, this.blockPosition(), 0);
                    }
                    for (Player player : this.level().players()) {
                        this.playAmbientSound();
                        if (this.level().isClientSide()) continue;
                        player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.titan_spirit.back", (Object[])new Object[]{this.getName(), player.getName()}));
                    }
                } else {
                    this.setPos(this.getX() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 1024.0f), 250.0, this.getZ() + (double)((this.getRandom().nextFloat() * 2.0f - 1.0f) * 1024.0f));
                }
                break block14;
            }
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            for (Entity entity : entities) {
                if (entity == null) continue;
                if (this.getSpiritName() == "entity.thetitansneo.witherzilla") {
                    if (!(entity instanceof Player)) continue;
                    this.waypointX = entity.getX();
                    this.waypointY = entity.getY();
                    this.waypointZ = entity.getZ();
                    continue;
                }
                if (entity.getClass() != TheTitansNeoMinions.MINIONS.get(this.getSpiritName()) || !(entity instanceof IMinion) || !(entity instanceof Mob)) continue;
                IMinion minion = (IMinion)entity;
                Mob mob = (Mob)entity;
                if (minion.getMinionType() != EnumMinionType.TEMPLAR) continue;
                mob.setTarget((LivingEntity)this);
                this.waypointX = entity.getX();
                this.waypointY = entity.getY();
                this.waypointZ = entity.getZ();
            }
        }
    }

    public void baseTick() {
        super.baseTick();
        this.level().getProfiler().push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        this.level().getProfiler().pop();
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        this.noPhysics = true;
        this.noCulling = true;
        this.stuckSpeedMultiplier = Vec3.ZERO;
        this.deathTime = 0;
        if (this.getSoul() < 0.0f) {
            this.setSoul(0.0f);
        } else if (this.getSoul() >= this.getMaxSoul()) {
            this.transformTitan();
        }
        if (this.getY() <= -100.0) {
            this.setPos(this.getX(), -100.0, this.getZ());
        }
        for (int i = 0; i < 30; ++i) {
            float f = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            float f1 = (this.getRandom().nextFloat() - 0.5f) * this.getBbHeight();
            float f2 = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 4.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
            this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, this.getX() + (double)f, this.getY() + 4.0 + (double)f1, this.getZ() + (double)f2, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        }
        Holder.Reference damageType = this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(TheTitansNeoDamageTypes.TITAN_SPIRIT_ATTACK);
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 32.0, 32.0));
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || entity instanceof EntityEnderColossusCrystal) continue;
            livingEntity = (LivingEntity)entity;
            if (this.tickCount % 40 == 0) {
                livingEntity.hurt(new DamageSource((Holder)damageType, (Entity)this), 2.0f);
                this.setSoul(this.getSoul() + 2.0f);
            }
            double speed = livingEntity.isCrouching() ? 0.2 : 0.4;
            double mx = this.getX() - livingEntity.getX();
            double my = this.getY() + (double)(this.getBbHeight() / 2.0f) - (livingEntity.getY() + (double)(livingEntity.getBbHeight() / 2.0f));
            double mz = this.getZ() - livingEntity.getZ();
            float f2 = (float)Math.sqrt(mx * mx + my * my + mz * mz);
            entity.push(mx / (double)f2 * speed * speed, my / (double)f2 * speed * speed, mz / (double)f2 * speed * speed);
            int short1 = (int)this.distanceTo((Entity)livingEntity);
            for (int f = 0; f < short1; ++f) {
                double d9 = (double)f / ((double)short1 - 1.0);
                double d6 = this.getX() + mx * -d9;
                double d7 = this.getY() + 4.0 + my * -d9;
                double d8 = this.getZ() + mz * -d9;
                this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, d6, d7, d8, livingEntity.getDeltaMovement().x, livingEntity.getDeltaMovement().y, livingEntity.getDeltaMovement().z);
            }
        }
        entities = this.level().getEntities((Entity)this, this.getBoundingBox());
        for (Entity entity : entities) {
            if (entity == null) continue;
            if (entity instanceof LivingEntity && !(entity instanceof EntityTitan) && !(entity instanceof EntityTitanSpirit) && !this.transformTitan(entity)) {
                livingEntity = (LivingEntity)entity;
                livingEntity.hurt(new DamageSource((Holder)damageType, (Entity)this), 100.0f);
                if (this.level().isClientSide()) continue;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 300, 3));
                continue;
            }
            if (!(entity instanceof EndCrystal)) continue;
            EndCrystal endCrystal = (EndCrystal)entity;
            endCrystal.hurt(new DamageSource((Holder)damageType, (Entity)this), 100.0f);
        }
    }
}

