/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.byAqua3.thetitansneo.TheTitansNeo;
import net.byAqua3.thetitansneo.entity.titan.EntityBlazeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityCaveSpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityCreeperTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityGhastTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityMagmaCubeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityOmegafish;
import net.byAqua3.thetitansneo.entity.titan.EntityPigZombieTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySlimeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.AABB;

public class FeatureTitanSpawn
extends Feature<NoneFeatureConfiguration> {
    private List<BlockPos> spawnedPos = new ArrayList<BlockPos>();

    public FeatureTitanSpawn(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public float distanceToPos(BlockPos blockPos1, BlockPos blockPos2) {
        int x = blockPos1.getX() - blockPos2.getX();
        int y = blockPos1.getY() - blockPos2.getY();
        int z = blockPos1.getZ() - blockPos2.getZ();
        return Mth.sqrt((float)(x * x + y * y + z * z));
    }

    public boolean isTitanSpawned(WorldGenLevel level, Entity entity, double range) {
        for (BlockPos blockPos : this.spawnedPos) {
            if (!((double)this.distanceToPos(blockPos, entity.blockPosition()) < range)) continue;
            return true;
        }
        return false;
    }

    public void setTitanSpawned(WorldGenLevel level, Entity entity) {
        this.spawnedPos.add(entity.blockPosition());
    }

    public boolean hasTitan(WorldGenLevel level, Entity entity, double range) {
        List entities = level.getLevel().getEntitiesOfClass(EntityTitan.class, entity.getBoundingBox().inflate(range, range, range));
        return !entities.isEmpty();
    }

    public int getSurface(WorldGenLevel level, int x, int z) {
        int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
        for (int i = level.getMinBuildHeight(); i < y - 1; ++i) {
            BlockPos blockPos = new BlockPos(x, i, z);
            if (!level.isEmptyBlock(blockPos) || level.isEmptyBlock(blockPos.below())) continue;
            return i;
        }
        return y;
    }

    public int getNetherSurface(WorldGenLevel level, int x, int z) {
        if (((Boolean)TheTitansNeoConfigs.titanSpawnNetherTop.get()).booleanValue()) {
            return level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
        }
        return this.getSurface(level, x, z);
    }

    public void destroyBlocksInAABB(WorldGenLevel level, AABB aabb) {
        if (aabb == null) {
            return;
        }
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int i1 = Mth.floor((double)aabb.maxY);
        int j1 = Mth.floor((double)aabb.maxZ);
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = level.getBlockState(blockPos);
                    Block block = blockState.getBlock();
                    if (level.isClientSide() || blockState.isAir() || !(blockState.getDestroySpeed((BlockGetter)level, blockPos) >= 0.0f)) continue;
                    if (!(block instanceof BaseFireBlock)) {
                        level.levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
                    }
                    level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 0);
                }
            }
        }
    }

    public EntityTitan generateTitan(WorldGenLevel level, RandomSource random, EntityTitan titan, int x, int y, int z, boolean spawnPosProtect, boolean canSpawnLiquid) {
        ServerChunkCache serverChunkCache = level.getLevel().getChunkSource();
        if (Thread.currentThread() != serverChunkCache.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.generateTitan(level, random, titan, x, y, z, spawnPosProtect, canSpawnLiquid), (Executor)serverChunkCache.mainThreadProcessor).join();
        }
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockState blockState = level.getBlockState(blockPos);
        BlockPos belowPos = blockPos.below();
        BlockState belowState = level.getBlockState(belowPos);
        Block belowBlock = belowState.getBlock();
        if (spawnPosProtect && ((Boolean)TheTitansNeoConfigs.playerSpawnPosProtect.get()).booleanValue() && (double)this.distanceToPos(blockPos, level.getLevel().getSharedSpawnPos()) <= (Double)TheTitansNeoConfigs.playerSpawnPosDistance.get()) {
            return null;
        }
        if (!canSpawnLiquid && belowBlock instanceof LiquidBlock) {
            return null;
        }
        if (blockState.isAir()) {
            titan.setPos((double)x + 0.5, y, (double)z + 0.5);
            titan.setYRot(random.nextFloat() * 360.0f);
            if (!this.isTitanSpawned((WorldGenLevel)level.getLevel(), (Entity)titan, 512.0)) {
                titan.finalizeSpawn((ServerLevelAccessor)level.getLevel(), level.getCurrentDifficultyAt(titan.blockPosition()), MobSpawnType.STRUCTURE, null);
                titan.setTitanHealth(titan.getMaxHealth());
                this.destroyBlocksInAABB(level, titan.getBoundingBox());
                level.getLevel().addFreshEntity((Entity)titan);
                this.setTitanSpawned(level, (Entity)titan);
                TheTitansNeo.LOGGER.info("Found a succesfully spawned {} at {}, {}, {}.", new Object[]{titan.getName().getString(), Mth.floor((double)titan.getX()), Mth.floor((double)titan.getY()), Mth.floor((double)titan.getZ())});
                return titan;
            }
        }
        return null;
    }

    public void generateWeb(WorldGenLevel level, int x, int y, int z) {
        for (int l1 = x - 11; l1 <= x + 11; ++l1) {
            for (int j1 = y - 11; j1 <= y; ++j1) {
                for (int i2 = z - 11; i2 <= z + 11; ++i2) {
                    BlockPos blockPos = new BlockPos(l1, j1, i2);
                    BlockState blockState = level.getBlockState(blockPos);
                    if (!(blockState.getDestroySpeed((BlockGetter)level, blockPos) >= 0.0f)) continue;
                    level.setBlock(blockPos, Blocks.COBWEB.defaultBlockState(), 0, 2);
                }
            }
        }
    }

    public void generateGold(WorldGenLevel level, int x, int y, int z, int diax, int diaz) {
        for (int l1 = x - diax; l1 <= x + diax; ++l1) {
            for (int i2 = z - diaz; i2 <= z + diaz; ++i2) {
                BlockPos blockPos = new BlockPos(l1, y, i2);
                BlockState blockState = level.getBlockState(blockPos);
                if (blockState.isSolidRender((BlockGetter)level, blockPos)) continue;
                level.setBlock(blockPos, Blocks.GOLD_BLOCK.defaultBlockState(), 0, 1);
            }
        }
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        float randomRate = randomSource.nextFloat() * 100.0f;
        if (worldGenLevel.getLevel().dimension() == TheTitansNeoDimensions.THE_VOID) {
            if (blockPos.getX() == 0 && blockPos.getZ() == 0) {
                this.generateTitan(worldGenLevel, randomSource, new EntityWitherzilla((Level)worldGenLevel.getLevel()), 0, 200, 0, false, true);
            }
        } else if (worldGenLevel.getLevel().dimension() == TheTitansNeoDimensions.THE_NOWHERE) {
            randomRate = randomSource.nextFloat() * 100.0f;
            if ((double)randomRate < (Double)TheTitansNeoConfigs.enderColossusSpawnRate.get()) {
                int i = blockPos.getX() + randomSource.nextInt(16) + 8;
                int j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                int k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityEnderColossus((Level)worldGenLevel.getLevel()), i, k, j, false, false);
            }
        } else if (worldGenLevel.getLevel().dimension() == Level.NETHER) {
            int k;
            int j;
            int i;
            randomRate = randomSource.nextFloat() * 100.0f;
            if ((double)randomRate < (Double)TheTitansNeoConfigs.magmaCubeTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getNetherSurface(worldGenLevel, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityMagmaCubeTitan((Level)worldGenLevel.getLevel()), i, k, j, true, true);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.witherSkeletonTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getNetherSurface(worldGenLevel, i, j);
                EntitySkeletonTitan skeletonTitan = new EntitySkeletonTitan((Level)worldGenLevel.getLevel());
                skeletonTitan.setSkeletonType(1);
                this.generateTitan(worldGenLevel, randomSource, skeletonTitan, i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.pigZombieTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getNetherSurface(worldGenLevel, i, j);
                EntityTitan pigZombieTitan = this.generateTitan(worldGenLevel, randomSource, new EntityPigZombieTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
                if (pigZombieTitan != null) {
                    this.generateGold(worldGenLevel, i, k + 4, j, 5, 5);
                    this.generateGold(worldGenLevel, i, k + 3, j, 6, 6);
                    this.generateGold(worldGenLevel, i, k + 2, j, 7, 7);
                    this.generateGold(worldGenLevel, i, k + 1, j, 8, 8);
                    this.generateGold(worldGenLevel, i, k, j, 9, 9);
                }
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.blazeTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getNetherSurface(worldGenLevel, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityBlazeTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.blazeTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityGhastTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
        } else if (worldGenLevel.getLevel().dimension() == Level.OVERWORLD) {
            EntityTitan spiderTitan;
            int k;
            int j;
            int i;
            randomRate = randomSource.nextFloat() * 100.0f;
            if ((double)randomRate < (Double)TheTitansNeoConfigs.slimeTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntitySlimeTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.omegafishSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getSurface(worldGenLevel, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityOmegafish((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.zombieTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityZombieTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.skeletonTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntitySkeletonTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.creeperTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                this.generateTitan(worldGenLevel, randomSource, new EntityCreeperTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.spiderTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                spiderTitan = this.generateTitan(worldGenLevel, randomSource, new EntitySpiderTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
                if (spiderTitan != null) {
                    this.generateWeb(worldGenLevel, i, k, j);
                }
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.caveSpiderTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = this.getSurface(worldGenLevel, i, j);
                EntityTitan caveSpiderTitan = this.generateTitan(worldGenLevel, randomSource, new EntityCaveSpiderTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
                if (caveSpiderTitan != null) {
                    this.generateWeb(worldGenLevel, i, k, j);
                }
            }
            if ((double)(randomRate = randomSource.nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.spiderJockeyTitanSpawnRate.get()) {
                i = blockPos.getX() + randomSource.nextInt(16) + 8;
                j = blockPos.getZ() + randomSource.nextInt(16) + 8;
                k = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, j);
                spiderTitan = this.generateTitan(worldGenLevel, randomSource, new EntitySpiderTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
                EntityTitan skeletonTitan = this.generateTitan(worldGenLevel, randomSource, new EntitySkeletonTitan((Level)worldGenLevel.getLevel()), i, k, j, true, false);
                if (skeletonTitan != null && spiderTitan != null) {
                    skeletonTitan.startRiding((Entity)spiderTitan);
                }
            }
        }
        return true;
    }
}

