/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.item.ItemAdminiumSword;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ItemAdminiumHoe
extends HoeItem {
    public ItemAdminiumHoe(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.ADMINIUM, properties.attributes(ItemAdminiumSword.createAttributes(1.0E9f, Float.MAX_VALUE)));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null && (entity.getBbHeight() >= 6.0f || entity instanceof EntityTitan || !entity.onGround())) {
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            entity.hurt(entity.damageSources().mobAttack(attacker), 1.0E9f);
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (level.getBlockState(blockPos.atY(blockPos.getY() + 1)).isAir() && (block == Blocks.SPONGE || block == Blocks.WET_SPONGE || block == Blocks.GRAVEL)) {
            level.playSound(player, blockPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(blockPos, Blocks.FARMLAND.defaultBlockState());
            if (!level.isClientSide() && player != null) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }
}

