/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ItemAdminiumSword
extends SwordItem {
    public ItemAdminiumSword(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.ADMINIUM, properties.attributes(ItemAdminiumSword.createAttributes(1.0E9f, Float.MAX_VALUE)));
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"attack_speed"), (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"attack_damage"), (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null) {
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            if (entity instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)entity;
                if (titan.canBeHurtByPlayer() && titan.getInvulTime() <= 0) {
                    titan.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                    titan.setTitanHealth(Math.max(titan.getTitanHealth() - 1000.0f, 0.0f));
                    titan.setTarget(attacker);
                }
            } else {
                entity.invulnerableTime = 0;
                entity.hurt(entity.damageSources().mobAttack(attacker), Float.MAX_VALUE);
                entity.setHealth(0.0f);
                entity.push(0.0, 1.0, 0.0);
            }
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int time) {
        Player player = (Player)livingEntity;
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        int max = this.getUseDuration(stack, livingEntity);
        int j = max - time;
        float f = (float)j / 60.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 1.0f, 2.0f);
        stack.hurtAndBreak(tool.damagePerBlock(), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        player.swing(player.getUsedItemHand());
        Vec3 vec3 = player.getViewVector(1.0f);
        double dx = vec3.x * 4.0;
        double dy = (double)player.getEyeHeight() + vec3.y * 4.0;
        double dz = vec3.z * 4.0;
        List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(4.0, 4.0, 4.0).move(dx, dy, dz));
        for (Entity entity : entities) {
            if (entity == null) continue;
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            if (entity instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)entity;
                if (!titan.canBeHurtByPlayer() || titan.getInvulTime() > 0) continue;
                entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                titan.animateHurt(180.0f);
                titan.setTitanHealth(Math.max(titan.getTitanHealth() - 2000.0f * (f + 1.0f), 0.0f));
                titan.setTarget((LivingEntity)player);
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity1 = (LivingEntity)entity;
            livingEntity1.animateHurt(180.0f);
            livingEntity1.setHealth(Math.max(livingEntity1.getHealth() - 2000.0f * (f + 1.0f), 0.0f));
            if (livingEntity1.getHealth() <= 0.0f) {
                livingEntity1.die(entity.damageSources().playerAttack(player));
            }
            livingEntity1.push(0.0, 1.0, 0.0);
        }
    }
}

