/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.projectile.EntityHarcadiumArrow;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.util.ItemUtils;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class ItemHarcadiumBow
extends BowItem {
    public ItemHarcadiumBow(Item.Properties properties) {
        super(properties.durability(12001));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean flag;
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        boolean bl = flag = player.isCreative() || EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.INFINITY), (ItemStack)stack) > 0;
        if (flag || ItemUtils.hasItem((List<ItemStack>)player.getInventory().items, (Item)TheTitansNeoItems.HARCADIUM_ARROW.get()) || ItemUtils.hasItem((List<ItemStack>)player.getInventory().offhand, (Item)TheTitansNeoItems.HARCADIUM_ARROW.get())) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int time) {
        boolean flag;
        Player player = (Player)entity;
        boolean bl = flag = player.isCreative() || EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.INFINITY), (ItemStack)stack) > 0;
        if (flag || ItemUtils.hasItem((List<ItemStack>)player.getInventory().items, (Item)TheTitansNeoItems.HARCADIUM_ARROW.get()) || ItemUtils.hasItem((List<ItemStack>)player.getInventory().offhand, (Item)TheTitansNeoItems.HARCADIUM_ARROW.get())) {
            int l;
            int k;
            int max = this.getUseDuration(stack, entity);
            int j = max - time;
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if ((double)f > 1.0) {
                f = 1.0f;
            }
            EntityHarcadiumArrow arrow = new EntityHarcadiumArrow(level);
            arrow.setPos(player.getX(), player.getEyeY(), player.getZ());
            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 1.0f);
            arrow.setBaseDamage(30.0);
            arrow.setOwner((Entity)player);
            if (f == 1.0f) {
                arrow.setCritArrow(true);
            }
            if ((k = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.POWER), (ItemStack)stack)) > 0) {
                arrow.setBaseDamage(arrow.getBaseDamage() + (double)k * 100.0);
            }
            if ((l = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.PUNCH), (ItemStack)stack)) > 0) {
                arrow.setKnockback(l * 3);
            }
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.FLAME), (ItemStack)stack) > 0) {
                arrow.igniteForSeconds(500.0f);
            }
            stack.hurtAndBreak(this.getDurabilityUse(stack), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            if (flag) {
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            } else if (ItemUtils.hasItem((List<ItemStack>)player.getInventory().offhand, (Item)TheTitansNeoItems.HARCADIUM_ARROW.get())) {
                for (ItemStack itemStack : player.getInventory().offhand) {
                    if (!itemStack.is((Item)TheTitansNeoItems.HARCADIUM_ARROW.get())) continue;
                    itemStack.shrink(1);
                    break;
                }
            } else {
                for (ItemStack itemStack : player.getInventory().items) {
                    if (!itemStack.is((Item)TheTitansNeoItems.HARCADIUM_ARROW.get())) continue;
                    itemStack.shrink(1);
                    break;
                }
            }
            if (!level.isClientSide()) {
                level.addFreshEntity((Entity)arrow);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        return new EntityHarcadiumArrow(arrow.level());
    }
}

