/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ItemHarcadiumSword
extends SwordItem {
    public ItemHarcadiumSword(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.HARCADIUM, properties.attributes(SwordItem.createAttributes((Tier)TheTitansNeoTiers.HARCADIUM, (int)50, (float)-2.4f)));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null && (entity.getBbHeight() >= 6.0f || entity instanceof EntityTitan || !entity.onGround())) {
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            entity.hurt(entity.damageSources().mobAttack(attacker), 500.0f);
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int time) {
        Player player = (Player)livingEntity;
        int max = this.getUseDuration(stack, livingEntity);
        int j = max - time;
        float f = (float)j / 60.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 1.0f, 2.0f);
        player.swing(player.getUsedItemHand());
        Vec3 vec3 = player.getViewVector(1.0f);
        double dx = vec3.x * 4.0;
        double dy = (double)player.getEyeHeight() + vec3.y * 4.0;
        double dz = vec3.z * 4.0;
        List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(4.0, 4.0, 4.0).move(dx, dy, dz));
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            entity.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 2.0f, 1.25f);
            entity.hurt(entity.damageSources().mobAttack((LivingEntity)player), 1000.0f * (f + 1.0f));
        }
    }
}

