/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.animation.Animator;
import net.byAqua3.thetitansneo.entity.titan.EntityCreeperTitan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelCreeperTitan
extends EntityModel<EntityCreeperTitan> {
    private Animator animator;
    public ModelPart bottomBody;
    public ModelPart leftfrontupperleg;
    public ModelPart leftbackupperleg;
    public ModelPart rightfrontupperleg;
    public ModelPart rightbackupperleg;
    public ModelPart bottomMiddle;
    public ModelPart bottomTop;
    public ModelPart head;
    public ModelPart leftfrontcalf;
    public ModelPart leftfrontfoot;
    public ModelPart leftbackcalf;
    public ModelPart leftbackfoot;
    public ModelPart rightfrontcalf;
    public ModelPart rightfrontfoot;
    public ModelPart rightbackcalf;
    public ModelPart rightbackfoot;

    public ModelCreeperTitan(float grow) {
        ModelPart root = ModelCreeperTitan.createBodyLayer(grow).bakeRoot();
        this.bottomBody = root.getChild("bottomBody");
        this.leftfrontupperleg = root.getChild("leftfrontupperleg");
        this.leftbackupperleg = root.getChild("leftbackupperleg");
        this.rightfrontupperleg = root.getChild("rightfrontupperleg");
        this.rightbackupperleg = root.getChild("rightbackupperleg");
        this.bottomMiddle = root.getChild("bottomBody").getChild("bottomMiddle");
        this.bottomTop = root.getChild("bottomBody").getChild("bottomMiddle").getChild("bottomTop");
        this.head = root.getChild("bottomBody").getChild("bottomMiddle").getChild("bottomTop").getChild("head");
        this.leftfrontcalf = root.getChild("leftfrontupperleg").getChild("leftfrontcalf");
        this.leftfrontfoot = root.getChild("leftfrontupperleg").getChild("leftfrontcalf").getChild("leftfrontfoot");
        this.leftbackcalf = root.getChild("leftbackupperleg").getChild("leftbackcalf");
        this.leftbackfoot = root.getChild("leftbackupperleg").getChild("leftbackcalf").getChild("leftbackfoot");
        this.rightfrontcalf = root.getChild("rightfrontupperleg").getChild("rightfrontcalf");
        this.rightfrontfoot = root.getChild("rightfrontupperleg").getChild("rightfrontcalf").getChild("rightfrontfoot");
        this.rightbackcalf = root.getChild("rightbackupperleg").getChild("rightbackcalf");
        this.rightbackfoot = root.getChild("rightbackupperleg").getChild("rightbackcalf").getChild("rightbackfoot");
        this.animator = new Animator(root);
    }

    public static LayerDefinition createBodyLayer(float grow) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(grow);
        partDefinition.addOrReplaceChild("bottomBody", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bottomBody").addOrReplaceChild("bottomMiddle", CubeListBuilder.create().texOffs(16, 24).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bottomBody").getChild("bottomMiddle").addOrReplaceChild("bottomTop", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bottomBody").getChild("bottomMiddle").getChild("bottomTop").addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftfrontupperleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftfrontupperleg").addOrReplaceChild("leftfrontcalf", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftfrontupperleg").getChild("leftfrontcalf").addOrReplaceChild("leftfrontfoot", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftbackupperleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftbackupperleg").addOrReplaceChild("leftbackcalf", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftbackupperleg").getChild("leftbackcalf").addOrReplaceChild("leftbackfoot", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightfrontupperleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightfrontupperleg").addOrReplaceChild("rightfrontcalf", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightfrontupperleg").getChild("rightfrontcalf").addOrReplaceChild("rightfrontfoot", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightbackupperleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightbackupperleg").addOrReplaceChild("rightbackcalf", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightbackupperleg").getChild("rightbackcalf").addOrReplaceChild("rightbackfoot", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityCreeperTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.leftfrontupperleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightbackupperleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bottomBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftbackupperleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightfrontupperleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setAngles() {
        float f = 16.1f;
        this.rightbackupperleg.setPos(-3.0f, f, 1.0f);
        this.leftfrontupperleg.setPos(3.0f, f, -1.0f);
        this.bottomBody.setPos(0.0f, f, 0.0f);
        this.leftbackupperleg.setPos(3.0f, f, 1.0f);
        this.rightfrontupperleg.setPos(-3.0f, f, -1.0f);
        this.rightbackcalf.xRot = 0.7853982f;
        this.leftfrontcalf.xRot = 0.7853982f;
        this.leftbackcalf.xRot = 0.7853982f;
        this.rightfrontcalf.xRot = 0.7853982f;
        this.rightbackfoot.xRot = 0.5235988f;
        this.leftfrontfoot.xRot = 0.5235988f;
        this.rightfrontfoot.xRot = 0.5235988f;
        this.leftbackfoot.xRot = 0.5235988f;
        this.leftfrontupperleg.xRot = -1.3089969f;
        this.leftfrontupperleg.yRot = -0.525f;
        this.rightbackupperleg.yRot = 2.625f;
        this.rightbackupperleg.xRot = -1.3089969f;
        this.leftbackupperleg.yRot = -2.625f;
        this.leftbackupperleg.xRot = -1.3089969f;
        this.rightfrontupperleg.xRot = -1.3089969f;
        this.rightfrontupperleg.yRot = 0.525f;
    }

    public void animate(EntityCreeperTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        this.animator.update(entity);
        this.setAngles();
        float f6 = Mth.cos((float)(ageInTicks * 0.1f));
        if (entity.deathTicks <= 0) {
            float faceYaw = headYaw * (float)Math.PI / 180.0f;
            float facePitch = headPitch * (float)Math.PI / 180.0f;
            this.bottomBody.zRot = Mth.cos((float)(limbSwing * 0.25f)) * 0.3f * limbSwingAmount;
            this.bottomMiddle.zRot = Mth.cos((float)(limbSwing * 0.25f - 1.0f)) * 0.3f * limbSwingAmount;
            this.bottomTop.zRot = Mth.cos((float)(limbSwing * 0.25f - 2.0f)) * 0.3f * limbSwingAmount;
            this.head.zRot = Mth.cos((float)(limbSwing * 0.25f - 3.0f)) * 0.3f * limbSwingAmount;
            if (entity.getAnimationID() == 8 && entity.getAnimationTick() > 130 && entity.getAnimationTick() < 430) {
                this.bottomMiddle.yRot = Mth.cos((float)(ageInTicks * 0.05f + 2.0f)) * 0.2f;
                this.bottomTop.yRot = Mth.cos((float)(ageInTicks * 0.05f + 1.0f)) * 0.2f;
                this.head.yRot = Mth.cos((float)(ageInTicks * 0.05f)) * 0.2f;
                this.bottomMiddle.xRot = (-0.025f + -0.0125f * Mth.cos((float)(ageInTicks * 0.1f - 2.0f))) * (float)Math.PI;
                this.bottomTop.xRot = (0.0125f + 0.0125f * Mth.cos((float)(ageInTicks * 0.1f - 1.0f))) * (float)Math.PI;
                this.head.xRot = (0.0125f + 0.0125f * f6) * (float)Math.PI;
            }
            if (entity.getAnimationID() == 13 && entity.getAnimationTick() < 5) {
                this.bottomMiddle.xRot = (-0.005f + -0.005f * Mth.cos((float)(ageInTicks * 0.1f - 2.0f))) * (float)Math.PI;
                this.bottomTop.xRot = (0.005f + 0.005f * Mth.cos((float)(ageInTicks * 0.1f - 1.0f))) * (float)Math.PI;
                this.head.xRot = (0.005f + 0.005f * f6) * (float)Math.PI;
            }
            if (this.riding) {
                this.rightbackupperleg.setPos(-3.0f, 21.0f, 1.0f);
                this.leftfrontupperleg.setPos(3.0f, 21.0f, -1.0f);
                this.bottomBody.setPos(0.0f, 21.0f, 0.0f);
                this.leftbackupperleg.setPos(3.0f, 21.0f, 1.0f);
                this.rightfrontupperleg.setPos(-3.0f, 21.0f, -1.0f);
                this.leftfrontupperleg.xRot = -1.6f;
                this.leftbackupperleg.xRot = -1.6f;
                this.rightfrontupperleg.xRot = -1.6f;
                this.rightbackupperleg.xRot = -1.6f;
                this.leftfrontupperleg.yRot = -0.725f;
                this.leftbackupperleg.yRot = -2.25f;
                this.rightfrontupperleg.yRot = 0.725f;
                this.rightbackupperleg.yRot = 2.25f;
                this.leftbackcalf.xRot = 1.0f;
                this.leftfrontcalf.xRot = 1.0f;
                this.rightbackcalf.xRot = 1.0f;
                this.rightfrontcalf.xRot = 1.0f;
            } else if (entity.getAnimationID() == 0) {
                this.bottomMiddle.xRot = (-0.025f + -0.0125f * Mth.cos((float)(ageInTicks * 0.1f - 2.0f))) * (float)Math.PI;
                this.bottomTop.xRot = (0.0125f + 0.0125f * Mth.cos((float)(ageInTicks * 0.1f - 1.0f))) * (float)Math.PI;
                this.head.xRot = (0.0125f + 0.0125f * f6) * (float)Math.PI;
                this.leftfrontupperleg.xRot = -1.3089969f + Mth.cos((float)(limbSwing * 0.25f + 0.25f)) * 0.75f * limbSwingAmount;
                this.leftbackupperleg.xRot = -1.3089969f + Mth.cos((float)(limbSwing * 0.25f + 3.3915927f)) * 0.75f * limbSwingAmount;
                this.rightfrontupperleg.xRot = -1.3089969f + Mth.cos((float)(limbSwing * 0.25f + 3.3915927f)) * 0.75f * limbSwingAmount;
                this.rightbackupperleg.xRot = -1.3089969f + Mth.cos((float)(limbSwing * 0.25f + 0.25f)) * 0.75f * limbSwingAmount;
                this.leftfrontupperleg.yRot = -0.525f + Mth.cos((float)(limbSwing * 0.25f + 2.6415927f)) * 0.5f * limbSwingAmount;
                this.leftbackupperleg.yRot = -2.625f + Mth.cos((float)(limbSwing * 0.25f - 0.5f)) * 0.5f * limbSwingAmount;
                this.rightfrontupperleg.yRot = 0.525f - Mth.cos((float)(limbSwing * 0.25f - 0.75f)) * 0.5f * limbSwingAmount;
                this.rightbackupperleg.yRot = 2.625f - Mth.cos((float)(limbSwing * 0.25f + 2.6415927f)) * 0.5f * limbSwingAmount;
                this.leftbackcalf.xRot = 0.7853982f + Mth.cos((float)(limbSwing * 0.25f)) * 0.5f * limbSwingAmount;
                this.leftfrontcalf.xRot = 0.7853982f + Mth.cos((float)(limbSwing * 0.25f + (float)Math.PI)) * 0.5f * limbSwingAmount;
                this.rightbackcalf.xRot = 0.7853982f + Mth.cos((float)(limbSwing * 0.25f + (float)Math.PI)) * 0.5f * limbSwingAmount;
                this.rightfrontcalf.xRot = 0.7853982f + Mth.cos((float)(limbSwing * 0.25f)) * 0.5f * limbSwingAmount;
                if (this.leftfrontupperleg.xRot > -1.3089969f) {
                    this.leftfrontupperleg.xRot = -1.3089969f;
                }
                if (this.rightfrontupperleg.xRot > -1.3089969f) {
                    this.rightfrontupperleg.xRot = -1.3089969f;
                }
                if (this.rightbackupperleg.xRot > -1.3089969f) {
                    this.rightbackupperleg.xRot = -1.3089969f;
                }
                if (this.leftbackupperleg.xRot > -1.3089969f) {
                    this.leftbackupperleg.xRot = -1.3089969f;
                }
                if (this.rightbackcalf.xRot < 0.7853982f) {
                    this.rightbackcalf.xRot = 0.7853982f;
                }
                if (this.rightfrontcalf.xRot < 0.7853982f) {
                    this.rightfrontcalf.xRot = 0.7853982f;
                }
                if (this.leftbackcalf.xRot < 0.7853982f) {
                    this.leftbackcalf.xRot = 0.7853982f;
                }
                if (this.leftfrontcalf.xRot < 0.7853982f) {
                    this.leftfrontcalf.xRot = 0.7853982f;
                }
                if (this.rightbackcalf.xRot < 0.7853982f) {
                    this.rightbackcalf.xRot = 0.7853982f;
                }
                if (this.rightfrontcalf.xRot < 0.7853982f) {
                    this.rightfrontcalf.xRot = 0.7853982f;
                }
            }
            this.head.xRot += facePitch * 0.3f;
            this.head.yRot += faceYaw * 0.3f;
            this.bottomTop.xRot += facePitch * 0.3f;
            this.bottomTop.yRot += faceYaw * 0.3f;
            this.bottomMiddle.xRot += facePitch * 0.3f;
            this.bottomMiddle.yRot += faceYaw * 0.3f;
            if (!entity.onGround() && !this.riding) {
                this.bottomBody.zRot = 0.0f;
                this.bottomMiddle.zRot = 0.0f;
                this.bottomTop.zRot = 0.0f;
                this.head.zRot = 0.0f;
                this.head.xRot -= entity.walkAnimation.speed(partialTicks);
                this.bottomBody.xRot += entity.walkAnimation.speed(partialTicks);
                this.leftfrontupperleg.yRot = -0.25f;
                this.rightbackupperleg.yRot = 2.75f;
                this.leftbackupperleg.yRot = -2.75f;
                this.rightfrontupperleg.yRot = 0.25f;
                this.rightbackupperleg.xRot = -2.0f - Mth.cos((float)(ageInTicks * 0.2f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) - entity.walkAnimation.speed(partialTicks);
                this.leftbackupperleg.xRot = -2.0f - Mth.cos((float)(ageInTicks * 0.2f - (float)Math.PI)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) - entity.walkAnimation.speed(partialTicks);
                this.rightfrontupperleg.xRot = -2.0f - Mth.cos((float)(ageInTicks * 0.2f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.leftfrontupperleg.xRot = -2.0f - Mth.cos((float)(ageInTicks * 0.2f - (float)Math.PI)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
            }
            if (entity.getAnimationID() == 1) {
                switch (entity.getAntiTitanAttackAnimationID()) {
                    case 0: {
                        this.animateAntiTitanAttack1();
                        break;
                    }
                    case 1: {
                        this.animateAntiTitanAttack2();
                        break;
                    }
                    case 2: {
                        this.animateAntiTitanAttack3();
                        break;
                    }
                    case 3: {
                        this.animateAntiTitanAttack4();
                    }
                }
            }
            this.animateStunned();
            this.animateThunderClap();
            this.animateSpit();
            this.animateKick();
            this.animateStomp();
            this.animateAttackStomp();
            this.animateHeadSlam();
            this.animateBirth();
        } else {
            this.animateDeath();
        }
    }

    private void animateAntiTitanAttack1() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, -3.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.rotate(this.head, -1.0f, -1.2f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.75f, 0.6f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.75f, 0.6f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.75f, -0.75f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -2.25f, -0.75f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -2.25f, 0.75f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.rotate(this.head, 0.5f, 0.75f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.75f, 0.75f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.75f, 0.5f, 0.0f);
        this.animator.rotate(this.bottomBody, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack2() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, -3.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.rotate(this.head, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 1.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, -0.75f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, 0.75f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.rotate(this.head, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, -1.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack3() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 4.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -4.0f, -0.5f, -1.3f);
        this.animator.rotate(this.leftfrontupperleg, -4.0f, 0.5f, 1.3f);
        this.animator.rotate(this.rightbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, -8.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, -8.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, -8.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, -8.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, -8.0f);
        this.animator.rotate(this.head, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, -1.3f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 1.3f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack4() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, -3.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -4.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -2.0f, 4.0f);
        this.animator.rotate(this.head, -1.0f, 1.2f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.75f, -0.6f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.75f, -0.6f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.75f, 0.75f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -2.25f, -0.75f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -2.25f, 0.75f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -8.0f);
        this.animator.rotate(this.head, 0.5f, -0.75f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.75f, -0.75f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.75f, -0.5f, 0.0f);
        this.animator.rotate(this.bottomBody, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAttackStomp() {
        this.animator.setAnimationID(2);
        this.animator.startPhase(25);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.25f, 0.5f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.25f, 0.5f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, 0.75f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -1.5f, -0.75f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.25f, -0.5f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.25f, -0.5f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.75f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.0f, -0.75f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.bottomMiddle, -0.5f, -0.25f, -0.5f);
        this.animator.rotate(this.bottomBody, -0.5f, -0.25f, -0.5f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, -0.75f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -1.5f, 0.75f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.bottomMiddle, 0.5f, -0.25f, 0.5f);
        this.animator.rotate(this.bottomBody, 0.5f, -0.25f, 0.5f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, -0.75f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.0f, 0.75f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateStomp() {
        this.animator.setAnimationID(3);
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.5f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.bottomBody, 0.0f, 1.0f, -3.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -2.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateHeadSlam() {
        this.animator.setAnimationID(4);
        this.animator.startPhase(10);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateKick() {
        this.animator.setAnimationID(5);
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, -1.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, 1.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.75f, -1.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.75f, -1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.25f, -1.5f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.25f, -0.75f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.25f, -0.75f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateSpit() {
        this.animator.setAnimationID(6);
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.25f, 0.0f, 0.0f);
        this.animator.move(this.bottomBody, 0.0f, -0.5f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateThunderClap() {
        this.animator.setAnimationID(7);
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.5f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.25f, -0.5f, -1.3f);
        this.animator.rotate(this.leftfrontupperleg, -1.25f, 0.5f, 1.3f);
        this.animator.rotate(this.rightbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -2.5f, -0.5f, -1.3f);
        this.animator.rotate(this.leftfrontupperleg, -2.5f, 0.5f, 1.3f);
        this.animator.rotate(this.rightbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.35f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.75f, -0.5f, -1.3f);
        this.animator.rotate(this.leftfrontupperleg, -0.75f, 0.5f, 1.3f);
        this.animator.rotate(this.rightbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.bottomBody, 0.0f, 1.0f, -3.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -2.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(50);
    }

    private void animateStunned() {
        this.animator.setAnimationID(8);
        this.animator.startPhase(0);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.2f, 0.25f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.2f, -0.25f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.bottomBody, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -3.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -3.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, -1.0f, 1.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.25f, 0.35f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.25f, -0.35f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(60);
        this.animator.move(this.bottomBody, 0.0f, -1.0f, 1.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 1.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.25f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(300);
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateDeath() {
        this.animator.setAnimationID(10);
        this.animator.startPhase(60);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, -4.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.25f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(60);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 1.0f, 0.0f, 2.0f);
        this.animator.rotate(this.leftbackupperleg, 1.0f, 0.0f, -2.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(60);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.rotate(this.head, 0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.25f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bottomBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(60);
        this.animator.startPhase(40);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 4.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1720);
        this.animator.resetPhase(0);
    }

    private void animateBirth() {
        this.animator.setAnimationID(13);
        this.animator.startPhase(0);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(60);
        this.animator.startPhase(60);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.bottomBody, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.25f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, -0.3f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, 0.1f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, 0.2f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bottomBody, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.bottomTop, 0.25f, 0.0f, 0.3f);
        this.animator.rotate(this.bottomMiddle, 0.25f, 0.0f, -0.1f);
        this.animator.rotate(this.bottomBody, 0.25f, 0.0f, -0.2f);
        this.animator.rotate(this.rightfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackupperleg, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightfrontfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackcalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightbackfoot, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }
}

