/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossusCrystal;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Quaternionf;

public class ModelEnderColossusCrystal
extends EntityModel<EntityEnderColossusCrystal> {
    private final ModelPart cube;
    private final ModelPart glass;

    public ModelEnderColossusCrystal() {
        ModelPart root = ModelEnderColossusCrystal.createBodyLayer().bakeRoot();
        this.cube = root.getChild("cube");
        this.glass = root.getChild("glass");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityEnderColossusCrystal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, EntityEnderColossusCrystal entity, float y, float rotation, int packedLight, int packedOverlay, int color) {
        float SIN_45 = (float)Math.sin(0.7853981633974483);
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.translate(0.0f, 0.8f + y, 0.0f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        this.glass.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        this.cube.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

