/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.animation.Animator;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelIronGolemTitan
extends EntityModel<EntityIronGolemTitan> {
    private Animator animator;
    public ModelPart head;
    public ModelPart nose;
    public ModelPart torso;
    public ModelPart body;
    public ModelPart leftArm1;
    public ModelPart leftArm2;
    public ModelPart leftArm3;
    public ModelPart leftArm4;
    public ModelPart rightArm1;
    public ModelPart rightArm2;
    public ModelPart rightArm3;
    public ModelPart rightArm4;
    public ModelPart leftLeg1;
    public ModelPart leftLeg2;
    public ModelPart rightLeg1;
    public ModelPart rightLeg2;

    public ModelIronGolemTitan() {
        ModelPart root = ModelIronGolemTitan.createBodyLayer().bakeRoot();
        this.torso = root.getChild("torso");
        this.body = root.getChild("torso").getChild("body");
        this.head = root.getChild("torso").getChild("body").getChild("head");
        this.nose = root.getChild("torso").getChild("body").getChild("head").getChild("nose");
        this.leftArm1 = root.getChild("torso").getChild("body").getChild("leftArm1");
        this.leftArm2 = root.getChild("torso").getChild("body").getChild("leftArm1").getChild("leftArm2");
        this.leftArm3 = root.getChild("torso").getChild("body").getChild("leftArm1").getChild("leftArm2").getChild("leftArm3");
        this.leftArm4 = root.getChild("torso").getChild("body").getChild("leftArm1").getChild("leftArm2").getChild("leftArm3").getChild("leftArm4");
        this.rightArm1 = root.getChild("torso").getChild("body").getChild("rightArm1");
        this.rightArm2 = root.getChild("torso").getChild("body").getChild("rightArm1").getChild("rightArm2");
        this.rightArm3 = root.getChild("torso").getChild("body").getChild("rightArm1").getChild("rightArm2").getChild("rightArm3");
        this.rightArm4 = root.getChild("torso").getChild("body").getChild("rightArm1").getChild("rightArm2").getChild("rightArm3").getChild("rightArm4");
        this.leftLeg1 = root.getChild("leftLeg1");
        this.leftLeg2 = root.getChild("leftLeg1").getChild("leftLeg2");
        this.rightLeg1 = root.getChild("rightLeg1");
        this.rightLeg2 = root.getChild("rightLeg1").getChild("rightLeg2");
        this.animator = new Animator(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 41).addBox(-4.5f, -5.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-9.0f, -12.0f, -6.0f, 18.0f, 12.0f, 11.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("head").addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(58, 13).mirror().addBox(0.0f, -3.0f, -3.0f, 4.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)9.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("leftArm1").addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(78, 13).mirror().addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("leftArm1").getChild("leftArm2").addOrReplaceChild("leftArm3", CubeListBuilder.create().texOffs(98, 13).mirror().addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("leftArm1").getChild("leftArm2").getChild("leftArm3").addOrReplaceChild("leftArm4", CubeListBuilder.create().texOffs(58, 29).mirror().addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(58, 13).addBox(-4.0f, -3.0f, -3.0f, 4.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)-9.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("rightArm1").addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(78, 13).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("rightArm1").getChild("rightArm2").addOrReplaceChild("rightArm3", CubeListBuilder.create().texOffs(98, 13).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("body").getChild("rightArm1").getChild("rightArm2").getChild("rightArm3").addOrReplaceChild("rightArm4", CubeListBuilder.create().texOffs(58, 29).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 10.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, cubeDeformation), PartPose.offsetAndRotation((float)4.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftLeg1").addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(54, 0).mirror().addBox(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(76, 0).addBox(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightLeg1").addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(98, 0).addBox(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(EntityIronGolemTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setAngles() {
        this.body.setRotation(this.attackTime, this.attackTime, this.attackTime);
        this.body.setRotation(0.0f, 0.0f, 0.0f);
        this.torso.setRotation(0.0f, 0.0f, 0.0f);
        this.leftLeg1.setRotation(0.0f, 0.0f, 0.0f);
        this.rightLeg1.setRotation(0.0f, 0.0f, 0.0f);
        this.leftLeg2.setRotation(0.0f, 0.0f, 0.0f);
        this.rightLeg2.setRotation(0.0f, 0.0f, 0.0f);
        this.leftArm1.setRotation(0.0f, 0.0f, 0.0f);
        this.rightArm1.setRotation(0.0f, 0.0f, 0.0f);
        this.leftArm2.setRotation(0.0f, 0.0f, 0.0f);
        this.rightArm2.setRotation(0.0f, 0.0f, 0.0f);
        this.leftArm3.setRotation(0.0f, 0.0f, 0.0f);
        this.rightArm3.setRotation(0.0f, 0.0f, 0.0f);
        this.leftArm4.setRotation(0.0f, 0.0f, 0.0f);
        this.rightArm4.setRotation(0.0f, 0.0f, 0.0f);
        this.rightArm1.setPos(-9.0f, -9.0f, 0.0f);
        this.rightArm2.setPos(-2.0f, 1.0f, 0.0f);
        this.rightArm3.setPos(0.0f, 8.0f, 0.0f);
        this.rightArm4.setPos(0.0f, 8.0f, 0.0f);
        this.leftArm1.setPos(9.0f, -9.0f, 0.0f);
        this.leftArm2.setPos(2.0f, 1.0f, 0.0f);
        this.leftArm3.setPos(0.0f, 8.0f, 0.0f);
        this.leftArm4.setPos(0.0f, 8.0f, 0.0f);
        this.nose.setPos(0.0f, 0.0f, -5.0f);
        this.head.setPos(0.0f, -12.0f, -3.0f);
        this.body.setPos(0.0f, -5.0f, 0.0f);
        this.torso.setPos(0.0f, 8.0f, 0.0f);
        this.rightLeg1.setPos(-4.0f, 8.0f, 0.0f);
        this.rightLeg2.setPos(0.0f, 8.0f, 0.0f);
        this.leftLeg1.setPos(4.0f, 8.0f, 0.0f);
        this.leftLeg2.setPos(0.0f, 8.0f, 0.0f);
    }

    public void animate(EntityIronGolemTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.animator.update(entity);
        this.setAngles();
        float fo = 0.22206666f;
        if (entity.deathTicks <= 0) {
            this.head.yRot = headYaw * (float)Math.PI / 180.0f;
            this.head.xRot = headPitch * (float)Math.PI / 180.0f;
            this.torso.zRot = Mth.cos((float)(ageInTicks * fo)) * 0.2f * limbSwingAmount;
            this.body.zRot = Mth.cos((float)(ageInTicks * fo - 1.0f)) * 0.2f * limbSwingAmount;
            if (entity.getAnimationID() == 0) {
                this.leftLeg1.xRot = Mth.cos((float)(ageInTicks * fo + 2.6415927f)) * 0.75f * limbSwingAmount;
                this.rightLeg1.xRot = Mth.cos((float)(ageInTicks * fo - 0.5f)) * 0.75f * limbSwingAmount;
                this.leftLeg2.xRot = Mth.cos((float)(ageInTicks * fo)) * 0.75f * limbSwingAmount;
                this.rightLeg2.xRot = Mth.cos((float)(ageInTicks * fo + (float)Math.PI)) * 0.75f * limbSwingAmount;
                this.leftArm1.xRot = Mth.cos((float)(ageInTicks * fo)) * 0.5f * limbSwingAmount;
                this.leftArm2.xRot = Mth.cos((float)(ageInTicks * fo - 1.0f)) * 0.5f * limbSwingAmount;
                this.leftArm3.xRot = Mth.cos((float)(ageInTicks * fo - 1.5f)) * 0.5f * limbSwingAmount;
                this.leftArm4.xRot = Mth.cos((float)(ageInTicks * fo - 2.0f)) * 0.5f * limbSwingAmount;
                this.rightArm1.xRot = Mth.cos((float)(ageInTicks * fo + (float)Math.PI)) * 0.5f * limbSwingAmount;
                this.rightArm2.xRot = Mth.cos((float)(ageInTicks * fo + 2.1415927f)) * 0.5f * limbSwingAmount;
                this.rightArm3.xRot = Mth.cos((float)(ageInTicks * fo + 1.6415927f)) * 0.5f * limbSwingAmount;
                this.rightArm4.xRot = Mth.cos((float)(ageInTicks * fo + 1.1415927f)) * 0.5f * limbSwingAmount;
            }
            if (this.leftLeg2.xRot < 0.0f) {
                this.leftLeg2.xRot = 0.0f;
            }
            if (this.rightLeg2.xRot < 0.0f) {
                this.rightLeg2.xRot = 0.0f;
            }
            if (this.leftArm2.xRot > 0.0f) {
                this.leftArm2.xRot = 0.0f;
            }
            if (this.rightArm2.xRot > 0.0f) {
                this.rightArm2.xRot = 0.0f;
            }
            if (this.leftArm3.xRot > 0.0f) {
                this.leftArm3.xRot = 0.0f;
            }
            if (this.rightArm3.xRot > 0.0f) {
                this.rightArm3.xRot = 0.0f;
            }
            if (this.leftArm4.xRot > 0.0f) {
                this.leftArm4.xRot = 0.0f;
            }
            if (this.rightArm4.xRot > 0.0f) {
                this.rightArm4.xRot = 0.0f;
            }
            this.animateAntiTitanAttack();
            this.animateThrow();
            this.animateSlam();
            this.animateStomp();
            this.animateSwat();
            this.animatePunch();
            this.leftLeg1.setPos(4.0f, this.torso.y, 0.0f);
            this.rightLeg1.setPos(-4.0f, this.torso.y, 0.0f);
        } else {
            this.animateDeath();
        }
    }

    private void animateAntiTitanAttack() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm1, 2.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm1, -3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateThrow() {
        this.animator.setAnimationID(5);
        this.animator.startPhase(10);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.rightArm1, -2.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -0.5f, 0.0f, -0.5f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateSlam() {
        this.animator.setAnimationID(6);
        this.animator.startPhase(15);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftArm1, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.move(this.torso, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, -1.6f, 0.2f, 0.0f);
        this.animator.rotate(this.leftLeg1, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm1, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm2, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 8.0f, -1.0f);
        this.animator.rotate(this.rightLeg1, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -2.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftArm1, -2.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.4f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateStomp() {
        this.animator.setAnimationID(7);
        this.animator.startPhase(25);
        this.animator.rotate(this.rightLeg1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftArm1, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.rotate(this.rightLeg1, -2.0f, 0.2f, 0.75f);
        this.animator.rotate(this.leftLeg1, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightLeg2, 1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftLeg2, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, -1.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightArm1, -0.75f, 0.0f, 0.5f);
        this.animator.rotate(this.leftArm1, -0.75f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftLeg1, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.5f, 0.0f, -0.4f);
        this.animator.rotate(this.rightArm1, 0.9f, 0.0f, 0.5f);
        this.animator.rotate(this.leftArm1, 0.9f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(20);
        this.animator.rotate(this.rightLeg1, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -2.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightLeg2, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.body, -1.0f, 0.0f, -0.25f);
        this.animator.rotate(this.rightArm1, 0.9f, 0.0f, 0.5f);
        this.animator.rotate(this.leftArm1, 0.9f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.3f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.5f, 0.0f, 0.4f);
        this.animator.rotate(this.rightArm1, 0.9f, 0.0f, 0.5f);
        this.animator.rotate(this.leftArm1, 0.9f, 0.0f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.2f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateSwat() {
        this.animator.setAnimationID(8);
        this.animator.startPhase(20);
        this.animator.rotate(this.leftArm1, 2.5f, 0.0f, -1.5f);
        this.animator.rotate(this.body, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.leftArm1, -1.5f, 0.0f, -1.5f);
        this.animator.rotate(this.leftArm2, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 1.5f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animatePunch() {
        this.animator.setAnimationID(9);
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.body, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm2, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.body, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -1.25f, 0.0f, 0.5f);
        this.animator.rotate(this.rightArm2, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateDeath() {
        this.animator.setAnimationID(10);
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.rightLeg1, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.leftLeg1, 0.0f, 2.0f, 4.0f);
        this.animator.rotate(this.rightLeg1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -0.5f, 0.5f, 0.5f);
        this.animator.rotate(this.leftArm1, -0.5f, -0.5f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 8.0f);
        this.animator.move(this.rightLeg1, 0.0f, 2.0f, 8.0f);
        this.animator.move(this.leftLeg1, 0.0f, 2.0f, 8.0f);
        this.animator.rotate(this.rightLeg1, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -0.5f, 0.5f, 0.5f);
        this.animator.rotate(this.leftArm1, -0.5f, -0.5f, -0.5f);
        this.animator.rotate(this.rightArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 9.0f);
        this.animator.move(this.rightLeg1, 0.0f, 2.0f, 9.0f);
        this.animator.move(this.leftLeg1, 0.0f, 2.0f, 9.0f);
        this.animator.rotate(this.rightLeg1, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.body, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -1.25f, 0.4f, 0.0f);
        this.animator.rotate(this.leftArm1, -1.25f, -0.4f, 0.0f);
        this.animator.rotate(this.rightArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.torso, 0.0f, 10.0f, 1.0f);
        this.animator.move(this.rightLeg1, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftLeg1, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, 1.4f, -0.5f, 0.0f);
        this.animator.rotate(this.leftLeg1, 1.4f, 0.5f, 0.0f);
        this.animator.rotate(this.rightLeg2, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.9f, 0.0f);
        this.animator.rotate(this.body, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -2.8f, 0.0f, -0.5f);
        this.animator.rotate(this.leftArm1, -2.8f, 0.0f, 0.5f);
        this.animator.rotate(this.rightArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftArm4, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(100);
        this.animator.move(this.torso, 0.0f, 10.0f, 1.0f);
        this.animator.move(this.rightLeg1, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftLeg1, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightLeg1, 1.4f, -0.5f, 0.0f);
        this.animator.rotate(this.leftLeg1, 1.4f, 0.5f, 0.0f);
        this.animator.rotate(this.rightLeg2, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg2, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.9f, 0.0f);
        this.animator.rotate(this.body, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightArm1, -3.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftArm1, -3.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1700);
        this.animator.resetPhase(0);
    }
}

