/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelWitherzilla
extends EntityModel<EntityWitherzilla> {
    public ModelPart[] heads = new ModelPart[3];
    public ModelPart[] spines = new ModelPart[3];

    public ModelWitherzilla(float grow) {
        int i;
        ModelPart root = ModelWitherzilla.createBodyLayer(grow).bakeRoot();
        for (i = 0; i < this.heads.length; ++i) {
            this.heads[i] = root.getChild("head" + i);
        }
        for (i = 0; i < this.spines.length; ++i) {
            this.spines[i] = root.getChild("spine" + i);
        }
    }

    public static LayerDefinition createBodyLayer(float grow) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(grow);
        partDefinition.addOrReplaceChild("head0", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("head1", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("spine0", CubeListBuilder.create().texOffs(0, 16).addBox(-10.0f, 3.9f, -0.5f, 20.0f, 3.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("spine1", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, cubeDeformation).texOffs(24, 22).addBox(-4.0f, 1.5f, 0.5f, 11.0f, 2.0f, 2.0f, cubeDeformation).texOffs(24, 22).addBox(-4.0f, 4.0f, 0.5f, 11.0f, 2.0f, 2.0f, cubeDeformation).texOffs(24, 22).addBox(-4.0f, 6.5f, 0.5f, 11.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)6.9f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(12, 22).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityWitherzilla entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float f = Mth.cos((float)(ageInTicks * 0.025f));
        this.spines[1].xRot = (0.025f + 0.05f * f) * (float)Math.PI;
        this.spines[2].setPos(-2.0f, 6.9f + Mth.cos((float)this.spines[1].xRot) * 10.0f, -0.5f + Mth.sin((float)this.spines[1].xRot) * 10.0f);
        this.spines[2].xRot = (0.265f + 0.1f * f) * (float)Math.PI;
        this.heads[0].yRot = headYaw * ((float)Math.PI / 180);
        this.heads[0].xRot = headPitch * ((float)Math.PI / 180);
        for (int i = 1; i < 3; ++i) {
            this.heads[i].yRot = (entity.getHeadYRot(i - 1) - entity.yBodyRot) * ((float)Math.PI / 180);
            this.heads[i].xRot = entity.getHeadXRot(i - 1) * ((float)Math.PI / 180);
        }
        if (entity.getInvulTime() < 1000) {
            this.heads[0].setPos(0.0f, 0.0f, 0.0f);
            this.heads[1].setPos(-10.0f, 4.0f, 0.0f);
            this.heads[2].setPos(10.0f, 4.0f, 0.0f);
            this.spines[0].setPos(0.0f, 0.0f, 0.0f);
            this.spines[1].setPos(-2.0f, 6.9f, -0.5f);
        } else {
            this.heads[0].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
            this.heads[1].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
            this.heads[2].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
            this.spines[0].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
            this.spines[1].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
            this.spines[2].setPos((float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0), (float)(entity.getRandom().nextGaussian() * 2.0));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        int i;
        for (i = 0; i < this.heads.length; ++i) {
            this.heads[i].render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
        for (i = 0; i < this.spines.length; ++i) {
            this.spines[i].render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
    }
}

