/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossusCrystal;
import net.byAqua3.thetitansneo.model.ModelEnderColossusCrystal;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderColossusCrystal
extends EntityRenderer<EntityEnderColossusCrystal> {
    public static final ResourceLocation ENDER_COLOSSUS_CRYSTAL = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/crystal.png");
    public static final ResourceLocation ENDER_COLOSSUS_CRYSTAL_BEAM = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/endercrystal_beam.png");
    private ModelEnderColossusCrystal model = new ModelEnderColossusCrystal();

    public RenderEnderColossusCrystal(EntityRendererProvider.Context context) {
        super(context);
    }

    public static void renderCrystalBeams(float x, float y, float z, float partialTicks, int tickCount, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float f = Mth.sqrt((float)(x * x + z * z));
        float f1 = Mth.sqrt((float)(x * x + y * y + z * z));
        poseStack.pushPose();
        poseStack.translate(0.0f, 2.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(z, x)) - 1.5707964f));
        poseStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(f, y)) - 1.5707964f));
        VertexConsumer vertexconsumer = multiBufferSource.getBuffer(RenderType.entitySmoothCutout((ResourceLocation)ENDER_COLOSSUS_CRYSTAL_BEAM));
        float f2 = 0.0f - ((float)tickCount + partialTicks) * 0.01f;
        float f3 = Mth.sqrt((float)(x * x + y * y + z * z)) / 32.0f - ((float)tickCount + partialTicks) * 0.01f;
        int i = 64;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose poseStack$pose = poseStack.last();
        for (int j = 1; j <= i; ++j) {
            float f7 = Mth.sin((float)((float)j * ((float)Math.PI * 2) / (float)i)) * 0.75f;
            float f8 = Mth.cos((float)((float)j * ((float)Math.PI * 2) / (float)i)) * 0.75f;
            float f9 = (float)j / (float)i;
            vertexconsumer.addVertex(poseStack$pose, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(-16777216).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(poseStack$pose, f4, f5, f1).setColor(-1).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(poseStack$pose, f7, f8, f1).setColor(-1).setUv(f9, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(poseStack$pose, f7 * 0.2f, f8 * 0.2f, 0.0f).setColor(-16777216).setUv(f9, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, -1.0f, 0.0f);
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.popPose();
    }

    public void render(EntityEnderColossusCrystal entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        float f1 = (float)entity.innerRotation + partialTicks;
        float f2 = Mth.sin((float)(f1 * 0.2f)) / 2.0f + 0.5f;
        f2 = (f2 * f2 + f2) * 0.4f - 1.4f;
        this.model.render(poseStack, multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), entity, f2 * 0.2f, f1 * 3.0f, packedLight, OverlayTexture.NO_OVERLAY, new Color(1.0f, 1.0f, 1.0f, 1.0f).getRGB());
        if (entity.owner != null) {
            float f4 = (float)entity.owner.getX();
            float f5 = (float)entity.owner.getY() + 48.0f;
            float f6 = (float)entity.owner.getZ();
            float f7 = (float)((double)f4 - entity.getX() + 0.5);
            float f8 = (float)((double)f5 - entity.getY() + 0.5);
            float f9 = (float)((double)f6 - entity.getZ() + 0.5);
            poseStack.translate(f7, f8, f9);
            RenderEnderColossusCrystal.renderCrystalBeams(-f7, -f8 + f2, -f9, partialTicks, entity.innerRotation, poseStack, multiBufferSource, packedLight);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityEnderColossusCrystal entity) {
        return ENDER_COLOSSUS_CRYSTAL;
    }
}

