/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.model.ModelIronGolemTitan;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderIronGolemTitan
extends LivingEntityRenderer<EntityIronGolemTitan, ModelIronGolemTitan> {
    public static final ResourceLocation IRON_GOLEM_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/iron_golem_titan.png");

    public RenderIronGolemTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelIronGolemTitan(), 1.0f);
    }

    public void render(EntityIronGolemTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityIronGolemTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = 24.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    protected float getShadowRadius(EntityIronGolemTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntityIronGolemTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntityIronGolemTitan entity) {
        return IRON_GOLEM_TITAN;
    }
}

