/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntitySlimeTitan;
import net.byAqua3.thetitansneo.model.ModelSlimeTitan;
import net.byAqua3.thetitansneo.render.layer.LayerSlimeTitanOuter;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSlimeTitan
extends LivingEntityRenderer<EntitySlimeTitan, ModelSlimeTitan> {
    public static final ResourceLocation SLIME_TITAN = ResourceLocation.withDefaultNamespace((String)"textures/entity/slime/slime.png");

    public RenderSlimeTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelSlimeTitan(16), 0.25f);
        this.addLayer(new LayerSlimeTitanOuter((RenderLayerParent<EntitySlimeTitan, ModelSlimeTitan>)this));
    }

    public void render(EntitySlimeTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        this.shadowRadius = 0.25f * (float)entity.getSlimeSize();
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntitySlimeTitan entity, PoseStack poseStack, float partialTick) {
        float f1 = entity.getSlimeSize();
        float f2 = Mth.lerp((float)partialTick, (float)entity.prevSquishFactor, (float)entity.squishFactor) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        poseStack.scale(f3 * f1, 1.0f / f3 * f1, f3 * f1);
        float fl = 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            fl -= ((float)i - partialTick) / 10.0f;
        }
        poseStack.scale(fl, fl, fl);
        poseStack.translate(0.0f, 0.0075f, 0.0f);
    }

    protected void setupRotations(EntitySlimeTitan entity, PoseStack poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTicks, scale);
        if (entity.deathTicks > 0) {
            float f = ((float)entity.deathTicks + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = (float)Math.sqrt(f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.scale(1.0f + f * 2.0f, 1.0f - f * 0.99f, 1.0f + f * 2.0f);
        }
    }

    protected float getShadowRadius(EntitySlimeTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntitySlimeTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntitySlimeTitan entity) {
        return SLIME_TITAN;
    }
}

