/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.render.layer.LayerSnowGolemTitanHead;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSnowGolemTitan
extends LivingEntityRenderer<EntitySnowGolemTitan, SnowGolemModel<EntitySnowGolemTitan>> {
    private static final ResourceLocation SNOW_GOLEM_TTIAN = ResourceLocation.withDefaultNamespace((String)"textures/entity/snow_golem.png");

    public RenderSnowGolemTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SnowGolemModel(context.bakeLayer(ModelLayers.SNOW_GOLEM)), 0.5f);
        this.addLayer(new LayerSnowGolemTitanHead((RenderLayerParent<EntitySnowGolemTitan, SnowGolemModel<EntitySnowGolemTitan>>)this, context.getBlockRenderDispatcher()));
    }

    public void render(EntitySnowGolemTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntitySnowGolemTitan entity, PoseStack poseStack, float partialTick) {
        float f1 = 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 10.0f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.0275f, 0.0f);
    }

    protected void setupRotations(EntitySnowGolemTitan entity, PoseStack poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTicks, scale);
        if (entity.deathTicks > 0) {
            float f = ((float)entity.deathTicks + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = (float)Math.sqrt(f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.scale(1.0f + f * 1.05f, 1.0f - f * 0.5f, 1.0f + f * 1.05f);
        }
    }

    protected float getShadowRadius(EntitySnowGolemTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntitySnowGolemTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntitySnowGolemTitan pEntity) {
        return SNOW_GOLEM_TTIAN;
    }
}

