/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntitySpiderTitan;
import net.byAqua3.thetitansneo.model.ModelSpiderTitan;
import net.byAqua3.thetitansneo.render.layer.LayerSpiderTitanArmor;
import net.byAqua3.thetitansneo.render.layer.LayerSpiderTitanEyes;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSpiderTitan
extends LivingEntityRenderer<EntitySpiderTitan, ModelSpiderTitan> {
    public static final ResourceLocation SPIDER_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/spider_titan.png");
    public static final ResourceLocation SPIDER_TITAN_EYE = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/spider_titan_eyes.png");

    public RenderSpiderTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelSpiderTitan(0.0f), 1.0f);
        this.addLayer(new LayerSpiderTitanEyes((RenderLayerParent<EntitySpiderTitan, ModelSpiderTitan>)this));
        this.addLayer(new LayerSpiderTitanArmor((RenderLayerParent<EntitySpiderTitan, ModelSpiderTitan>)this));
    }

    public void render(EntitySpiderTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntitySpiderTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    protected float getFlipDegrees(EntitySpiderTitan entity) {
        return 180.0f;
    }

    protected boolean isBodyVisible(EntitySpiderTitan entity) {
        return !entity.isInvisible();
    }

    protected float getShadowRadius(EntitySpiderTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntitySpiderTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntitySpiderTitan entity) {
        return SPIDER_TITAN;
    }
}

