/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.byAqua3.thetitansneo.model.ModelZombieTitan;
import net.byAqua3.thetitansneo.render.layer.LayerZombieTitanArmor;
import net.byAqua3.thetitansneo.render.layer.LayerZombieTitanItemInHand;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderZombieTitan
extends LivingEntityRenderer<EntityZombieTitan, ModelZombieTitan> {
    public static final ResourceLocation ZOMBIE_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/zombie_titan.png");
    public static final ResourceLocation ZOMBIE_TITAN_ARMED = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/zombie_titan_armed.png");
    public static final ResourceLocation ZOMBIE_VILLAGER_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/zombie_villager_titan.png");
    public static final ResourceLocation ZOMBIE_VILLAGER_TITAN_ARMED = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/zombie_villager_titan_armed.png");

    public RenderZombieTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelZombieTitan(0.0f), 0.5f);
        this.addLayer(new LayerZombieTitanItemInHand((RenderLayerParent<EntityZombieTitan, ModelZombieTitan>)this));
        this.addLayer(new LayerZombieTitanArmor((RenderLayerParent<EntityZombieTitan, ModelZombieTitan>)this));
    }

    public void render(EntityZombieTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityZombieTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    protected float getShadowRadius(EntityZombieTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntityZombieTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntityZombieTitan entity) {
        if (entity.isArmed()) {
            return !entity.isVillager() ? ZOMBIE_TITAN_ARMED : ZOMBIE_VILLAGER_TITAN_ARMED;
        }
        return !entity.isVillager() ? ZOMBIE_TITAN : ZOMBIE_VILLAGER_TITAN;
    }
}

