/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record BiomeModifierAddSpawns(HolderSet<Biome> biomes, MobCategory category, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public static final MapCodec<BiomeModifierAddSpawns> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(BiomeModifierAddSpawns::biomes), (App)MobCategory.CODEC.fieldOf("category").forGetter(BiomeModifierAddSpawns::category), (App)Codec.either((Codec)MobSpawnSettings.SpawnerData.CODEC.listOf(), (Codec)MobSpawnSettings.SpawnerData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(BiomeModifierAddSpawns::spawners)).apply((Applicative)builder, BiomeModifierAddSpawns::new));

    public static BiomeModifierAddSpawns singleSpawn(HolderSet<Biome> biomes, MobCategory category, MobSpawnSettings.SpawnerData spawner) {
        Codec.either((Codec)MobSpawnSettings.SpawnerData.CODEC.listOf(), (Codec)MobSpawnSettings.SpawnerData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list));
        return new BiomeModifierAddSpawns(biomes, category, List.of(spawner));
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                spawns.addSpawn(this.category, spawner);
            }
        }
    }
}

