/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.creepertitan;

import java.util.EnumSet;
import net.byAqua3.thetitansneo.entity.titan.EntityCreeperTitan;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class EntityAICreeperTitanSwell
extends Goal {
    private EntityCreeperTitan entity;
    private LivingEntity target;

    public EntityAICreeperTitanSwell(EntityCreeperTitan entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity entity = this.entity.getTarget();
        return this.entity.getCreeperState() > 0 || entity != null && this.entity.distanceToSqr((Entity)entity) < 1.0;
    }

    public void start() {
        this.entity.getNavigation().stop();
        this.target = this.entity.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            this.entity.setCreeperState(-1);
        } else if (this.entity.distanceToSqr((Entity)this.target) > 1.0) {
            this.entity.setCreeperState(-1);
        } else if (!this.entity.getSensing().hasLineOfSight((Entity)this.target)) {
            this.entity.setCreeperState(-1);
        } else {
            this.entity.setCreeperState(1);
        }
    }
}

