/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.minion;

import java.util.List;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class EntityAIFindEntityNearestInjuredAlly
extends Goal {
    private IMinion entity;
    private LivingEntity target;

    public EntityAIFindEntityNearestInjuredAlly(IMinion entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        Mob mob = (Mob)this.entity;
        if (this.entity.getMinionType() != EnumMinionType.PRIEST) {
            return false;
        }
        if (!mob.isAlive()) {
            return false;
        }
        if (this.target != null) {
            return false;
        }
        double d0 = this.getFollowDistance();
        List entities = mob.level().getEntitiesOfClass(LivingEntity.class, mob.getBoundingBox().inflate(d0, d0, d0));
        if (entities.isEmpty()) {
            return false;
        }
        for (LivingEntity livingEntity : entities) {
            if (livingEntity.getClass() != this.entity.getClass() || !(livingEntity.getHealth() < livingEntity.getMaxHealth()) || !livingEntity.isAlive()) continue;
            this.target = livingEntity;
        }
        return true;
    }

    public boolean canContinueToUse() {
        Mob mob = (Mob)this.entity;
        LivingEntity entity = this.entity.getEntityToHeal();
        if (entity == null) {
            return false;
        }
        if (!entity.isAlive()) {
            this.target = null;
            return false;
        }
        if (entity.getHealth() >= entity.getMaxHealth()) {
            this.target = null;
            return false;
        }
        double d0 = this.getFollowDistance();
        return mob.distanceToSqr((Entity)entity) <= d0 * d0;
    }

    public void start() {
        this.entity.setEntityToHeal(this.target);
    }

    public void stop() {
        this.entity.setEntityToHeal(null);
        this.target = null;
    }

    public void tick() {
        Mob mob = (Mob)this.entity;
        if (this.entity.getEntityToHeal() != null && (double)mob.distanceTo((Entity)this.entity.getEntityToHeal()) > 16.0) {
            mob.getNavigation().moveTo((Entity)this.entity.getEntityToHeal(), 1.0);
            mob.getLookControl().setLookAt((Entity)this.entity.getEntityToHeal(), 10.0f, (float)mob.getMaxHeadXRot());
        }
    }

    protected double getFollowDistance() {
        Mob mob = (Mob)this.entity;
        return mob.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue();
    }
}

